﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Seguridad;

namespace Nova.Controllers.Capacitacion
{
    public class CapacitacionIncidenciasController : Controller
    {
        


        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();
        // GET: CapacitacionIncidencias
        public ActionResult Index()
        {
            int idk=Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Capacitacion_ctCoordinadores ins = db.Capacitacion_ctCoordinadores.Where(t => t.IdKardex == idk).FirstOrDefault();
            int id = 0;

            if (ins == null)
                throw new ApplicationException("No esta asignado como coordinador de cursos");
            else
                if (ins.FechaVencimientoCoordinador < DateTime.Now.Date)
                    throw new ApplicationException("Ha finalizado su periodo como coordinador de cursos");
                else
                    id = ins.IdKardex;
            
            ViewBag.id=id;


            return View();
        }

        public ActionResult Agregar(int id)
        {
            ViewBag.id=id;
            return View();
        }

        [ValidateInput(false)]

        public ActionResult Incidencias(int id)
        {
            var model = db.Capacitacion_stIncidenciasParticipantes.Where(g=> g.IdParticipantes==id);
            Capacitacion_stParticipantes participante = db.Capacitacion_stParticipantes.Where(g => g.IdParticipantes == id).FirstOrDefault();
            ViewBag.id = id;
            ViewBag.IdInstructor = participante.Capacitacion_stConvocatoriasCursosSedesAulas.IdInstructor;
            

            return PartialView("_Incidencias", model.ToList());
        }

        [ValidateInput(false)]
        public ActionResult Listado(int id)
        {
            //var aulas = db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(r => r.IdCoordinador==id).Select(t=> t.IdConvocatoriaCursosSedesAulas).ToList();
            var model = db.Capacitacion_stParticipantes.Where(y => y.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_ctCoordinadores.IdKardex == id).OrderByDescending(v => new { v.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursos.FechaInicioCurso, v.Kardex_ctDatosPersonales.Nombre, v.Kardex_ctDatosPersonales.ApellidoPaterno,v.Kardex_ctDatosPersonales.ApellidoMaterno});
            ViewBag.id = id;
            //var cmodel = db.Capacitacion_stParticipantes.Where(y => y.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursosSedes.Capacitacion_ctSede.Sede));

            return PartialView("_Listado", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult IncidenciasAddNew(Nova.Models.Capacitacion_stIncidenciasParticipantes item)
        {
            ViewBag.id = item.IdParticipantes;
            ViewBag.IdInstructor= item.IdInstructor;
            //item.Mes = (short)item.FechaInicioIncidencias.Month;
            //item.Año = (short)item.FechaInicioIncidencias.Year;
            var model = db.Capacitacion_stIncidenciasParticipantes;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            return PartialView("_Incidencias", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult IncidenciasUpdate(Nova.Models.Capacitacion_stIncidenciasParticipantes item)
        {
            //item.Mes = (short)item.FechaInicioIncidencias.Month;
            //item.Año = (short)item.FechaInicioIncidencias.Year;

            var model = db.Capacitacion_stIncidenciasParticipantes;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IncidenciasParticipanes == item.IncidenciasParticipanes);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_Incidencias", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult IncidenciasDelete(System.Byte IdIncidencias)
        {
            var model = db.Capacitacion_stIncidenciasParticipantes;
            if (IdIncidencias != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IncidenciasParticipanes == IdIncidencias);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_Incidencias", model.ToList());
        }
    }
}