﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class CapacitacionCursoController : Controller
    {
        //
        // GET: /CapacitacionCurso/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvCapacitacionCurso()
        {
            var model = db.Capacitacion_ctCurso;
            return PartialView("_pvCapacitacionCurso", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionCursoAddNew(Nova.Models.Capacitacion_ctCurso item)
        {
            var model = db.Capacitacion_ctCurso;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvCapacitacionCurso", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionCursoUpdate(Nova.Models.Capacitacion_ctCurso item)
        {
            var model = db.Capacitacion_ctCurso;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdCurso == item.IdCurso);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvCapacitacionCurso", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionCursoDelete(System.Int16 IdCurso)
        {
            var model = db.Capacitacion_ctCurso;
            if (IdCurso != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdCurso == IdCurso);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvCapacitacionCurso", model.ToList());
        }
    }
}
