﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class CapacitacionCoordinadoresController : Controller
    {
        //
        // GET: /CapacitacionCoordinadores/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvCapacitacionCoordinadores()
        {
            var model = db.Capacitacion_ctCoordinadores;
            return PartialView("_pvCapacitacionCoordinadores", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionCoordinadoresAddNew(Nova.Models.Capacitacion_ctCoordinadores item)
        {
            var model = db.Capacitacion_ctCoordinadores;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvCapacitacionCoordinadores", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionCoordinadoresUpdate(Nova.Models.Capacitacion_ctCoordinadores item)
        {
            var model = db.Capacitacion_ctCoordinadores;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdCoordinador == item.IdCoordinador);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvCapacitacionCoordinadores", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionCoordinadoresDelete(System.Int16 IdCoordinador)
        {
            var model = db.Capacitacion_ctCoordinadores;
            if (IdCoordinador != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdCoordinador == IdCoordinador);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                   


                }
            }
            return PartialView("_pvCapacitacionCoordinadores", model.ToList());
        }
    }
}
