﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

using Nova.Libraries;
using Dapper;
using System.Net.Mail;
using System.Net;
using Seguridad;
using DevExpress.XtraReports.UI;
using System.IO;
using System.Web.UI.WebControls;
using System.Web.UI;
using DevExpress.Web;
using DevExpress.XtraPrinting;


namespace Nova.Controllers.Capacitacion
{

    public class CapacitacionConvocatoriaController : Controller
    {
        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();
        // GET: CapacitacionConvocatoria
        public ActionResult Index()
        {
            return View();
        }

        public ActionResult Publicar()
        {

            return View();
        }


        private bool EnviarEmailInvitacion(string email, List<Capacitacion_stConvocatoriasCursos> item)
        {
            bool regresa = true;
            MailMessage msg = new MailMessage();

            msg.From = new MailAddress("sistemas@cecyteo.edu.mx");
            msg.To.Add(email);
            msg.Subject = "Invitación para cursos";
            msg.IsBodyHtml = true;
            // string codificado = Cifrado.Encrypt(email + id.ToString());

            UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);

            string url = HttpContext.Request.Url.Scheme + "://" + HttpContext.Request.Url.Authority + u.Action("", "");

            msg.Body = @"<html xmlns='http://www.w3.org/1999/xhtml'>
<head>

    <!-- Define Charset -->
    <meta http-equiv='Content-Type' content='text/html; charset=utf-8'>
    <!-- Responsive Meta Tag -->
    <meta name='viewport' content='width=device-width; initial-scale=1.0; maximum-scale=1.0;'>
    <!-- Facebook sharing information tags -->
    
    <title>Invitación</title>

    <link href='https://fonts.googleapis.com/css?family=Source+Sans+Pro:200,300,400' rel='stylesheet' type='text/css'>


    <style type='text/css' data-premailer='ignore'>
        /* iPad Text Smoother */
        div, p, a, li, td {
            -webkit-text-size-adjust: none;
        }

        .ReadMsgBody {
            width: 100%;
            background-color: #ffffff;
        }

        .ExternalClass {
            width: 100%;
            background-color: #ffffff;
        }

        body {
            width: 100%;
            background-color: #ffffff;
            margin: 0;
            padding: 0;
            -webkit-font-smoothing: antialiased;
            text-align: left;
        }

        html {
            width: 100%;
        }

        img {
            border: 0px;
            outline: none;
            text-decoration: none;
            display: block;
        }

        a img {
            border: none;
        }

        a {
            color: inherit;
            text-decoration: none;
            text-align: inherit;
        }

        .Rounded_Bottom {
            border-bottom-left-radius: 3px;
            -webkit-border-bottom-left-radius: 3px;
            -moz-border-radius-bottomleft: 3px;
            border-bottom-right-radius: 3px;
            -webkit-border-bottom-right-radius: 3px;
            -moz-border-radius-bottomright: 3px;
        }

        .Rounded_Top {
            border-top-left-radius: 3px;
            -webkit-border-top-left-radius: 3px;
            -moz-border-radius-topleft: 3px;
            border-top-right-radius: 3px;
            -webkit-border-top-right-radius: 3px;
            -moz-border-radius-topright: 3px;
        }

        .Text_H1 {
            font-family: 'Source Sans Pro', sans-serif;
            font-size: 36px;
            letter-spacing: -1px;
            font-weight: 400;
            font-style: normal;
          
            color: #222427;
            line-height: 120%;
            text-align: left;
        }

        .Text_H2 {
            font-family: 'Source Sans Pro', sans-serif;
            font-size: 24px;
            letter-spacing: -1px;
            font-weight: 400;
            font-style: normal;
          
            color: #222427;
            line-height: 150%;
            text-align: left;
        }

        .Text_H3 {
            font-family: 'Source Sans Pro', sans-serif;
            font-size: 14px;
            letter-spacing: 0px;
            font-weight: 400;
            font-style: normal;
            text-decoration: none;
          
            color: #656d78;
            line-height: 175%;
            text-align: left;
        }

        .Text_H4 {
            font-family: sans-serif;
            
            font-weight: normal;
            font-style: normal;
            text-decoration: none;
            text-transform: uppercase;
            color: #DBDBDB;
            line-height: 200%;
            text-align: left;
        }

        .btn-style {
          border-color: #B3B1B1;
             border-width: 1px;
            border-style: solid;
            border-radius: 4px;
            moz-border-radius: 4px;
        }

        .plan-style {
            border-color: #ffffff;
            border-width: 1px;
            border-style: solid;
        }

        .border-style {
            border-color: #ffffff;
            border-width: 7px;
            border-style: solid;
        }
        /*-------------------------------------- Responsive 600px PC Attributes --------------------------------------*/
        @media only screen and (max-width: 900px) {
            body {
                width: auto !important;
            }
            /* Responsive Wrappers  */
            .BoxWrap {
                width: 600px !important;
            }

            .BookLeft {
                width: 300px !important;
            }

            .BookRight {
                width: 280px !important;
            }

            .Respo1Column {
                width: 560px !important;
            }

            .Respo2Column {
                width: 270px !important;
            }

            .Respo3Column {
                width: 560px !important;
            }
            /* Responsive Images  */
            .RespoImage1Col {
                width: 600px !important;
                height: auto !important;
            }

            .RespoImage1ColW Img {
                width: 600px !important;
                height: auto !important;
            }

            .RespoImage2Col {
                width: 270px !important;
                height: auto !important;
            }

            .RespoImage2ColW Img {
                width: 270px !important;
                height: auto !important;
            }

            .RespoImage3Col {
                width: 560px !important;
                height: auto !important;
            }

            .RespoImage3ColW Img {
                width: 560px !important;
                height: auto !important;
            }
            /* Responsive Images with Padding */
            .RespoImage1ColPadding {
                width: 560px !important;
                height: auto !important;
            }

            .RespoImage1ColPaddingW Img {
                width: 560px !important;
                height: auto !important;
            }
            /* Responsive Framed Images */
            .RespoImage2ColFramed {
                width: 264px !important;
                height: auto !important;
            }

            .RespoImage2ColFramedW Img {
                width: 264px !important;
                height: auto !important;
            }

            .RespoImage3ColFramed {
                width: 554px !important;
                height: auto !important;
            }

            .RespoImage3ColFramedW Img {
                width: 554px !important;
                height: auto !important;
            }
            /* Show/Hide  */
            .respo-margin {
                width: 20px !important;
            }

            .respo-hide-pc {
                display: none !important;
            }

            .respo-show-pc {
                display: block !important;
            }
            /* General  */
            .respo-text-left {
                text-align: left !important;
            }

            .respo-center-pc {
                text-align: center !important;
            }
        }

        /*-------------------------------------- Responsive 440px Tablet Attributes --------------------------------------*/
        @media only screen and (max-width: 640px) {
            body {
                width: auto !important;
            }
            /* Responsive Wrappers  */
            .BoxWrap {
                width: 440px !important;
            }

            .BookLeft {
                width: 440px !important;
            }

            .BookRight {
                width: 440px !important;
            }

            .Respo1Column {
                width: 420px !important;
            }

            .Respo2Column {
                width: 400px !important;
            }

            .Respo3Column {
                width: 400px !important;
            }

            .RespoTabletWidth {
                width: 400px !important;
            }

            .Respo2ColumnTablet {
                width: 400px !important;
            }
            /* Responsive Images  */
            .RespoImage1Col {
                width: 440px !important;
                height: auto !important;
            }

            .RespoImage1ColW Img {
                width: 440px !important;
                height: auto !important;
            }

            .RespoImage2Col {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage2ColW Img {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage3Col {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage3ColW Img {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage3ColTablet {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage3ColWTablet Img {
                width: 400px !important;
                height: auto !important;
            }
            /* Responsive Images with Padding */
            .RespoImage1ColPadding {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage1ColPaddingW Img {
                width: 400px !important;
                height: auto !important;
            }
            /* Responsive Framed Images */
            .RespoImage2ColFramed {
                width: 394px !important;
                height: auto !important;
            }

            .RespoImage2ColFramedW Img {
                width: 394px !important;
                height: auto !important;
            }

            .RespoImage3ColFramed {
                width: 394px !important;
                height: auto !important;
            }

            .RespoImage3ColFramedW Img {
                width: 394px !important;
                height: auto !important;
            }
            /* Responsive Tablet and Mobile Only */
            .RespoImage2ColTablet {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage2ColTabletW Img {
                width: 400px !important;
                height: auto !important;
            }
            /* Show/Hide  */
            .respo-hide-tablet {
                display: none !important;
            }

            .respo-show-tablet {
                display: block !important;
            }
            /* Responsive Text Align & Size */
            .Text_H1 {
                font-size: 36px !important;
                line-height: 125% !important;
            }

            .Text_H2 {
                font-size: 36px !important;
                line-height: 140% !important;
            }

            .Text_H3 {
                font-size: 14px !important;
                line-height: 150% !important;
                font-weight: normal !important;
            }

            .Text_H4 {
                font-size: 15px !important;
                line-height: 150% !important;
                font-weight: normal !important;
            }

            .respo-center-tablet {
                text-align: center !important;
            }

            .respo-spacer {
                height: 200px !important;
            }
        }

        /*-------------------------------------- Responsive 280px Mobile Attributes --------------------------------------*/
        @media only screen and (max-width: 480px) {
            body {
                width: auto !important;
            }
            /* Responsive Wrappers  */
            .BoxWrap {
                width: 280px !important;
            }

            .BookLeft {
                width: 280px !important;
            }

            .BookRight {
                width: 280px !important;
            }

            .Respo1Column {
                width: 260px !important;
            }

            .Respo2Column {
                width: 240px !important;
            }

            .Respo3Column {
                width: 240px !important;
            }

            .RespoTabletWidth {
                width: 240px !important;
            }

            .Respo2ColumnTablet {
                width: 240px !important;
            }
            /* Responsive Images  */
            .RespoImage1Col {
                width: 280px !important;
                height: auto !important;
            }

            .RespoImage1ColW Img {
                width: 280px !important;
                height: auto !important;
            }

            .RespoImage2Col {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage2ColW Img {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage3Col {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage3ColW Img {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage3ColTablet {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage3ColWTablet Img {
                width: 240px !important;
                height: auto !important;
            }
            /* Responsive Images with Padding */
            .RespoImage1ColPadding {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage1ColPaddingW Img {
                width: 240px !important;
                height: auto !important;
            }
            /* Responsive Framed Images */
            .RespoImage2ColFramed {
                width: 234px !important;
                height: auto !important;
            }

            .RespoImage2ColFramedW Img {
                width: 234px !important;
                height: auto !important;
            }

            .RespoImage3ColFramed {
                width: 234px !important;
                height: auto !important;
            }

            .RespoImage3ColFramedW Img {
                width: 234px !important;
                height: auto !important;
            }
            /* Responsive Tablet and Mobile Only */
            .RespoImage2ColTablet {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage2ColTabletW Img {
                width: 240px !important;
                height: auto !important;
            }
            /* Show/Hide  */
            .respo-hide-mobile {
                display: none !important;
            }
            /* Responsive Text Align & Size */
            .Text_H1 {
                font-size: 24px !important;
                line-height: 125% !important;
            }

            .Text_H2 {
                font-size: 24px !important;
                line-height: 140% !important;
            }

            .Text_H3 {
                font-size: 18px !important;
                line-height: 150% !important;
                font-weight: normal !important;
            }

            .Text_H4 {
                font-size: 11px !important;
                line-height: 150% !important;
                font-weight: normal !important;
            }

            .respo-center-mobile {
                text-align: center !important;
            }

            .respo-spacer {
                height: 100px !important;
            }
        }

#list2 { }
#list2 ol { font-size:24px; color:#666;  }
#list2 ol li { }
#list2 ol li p { padding:8px; font-style:normal; font-size:13px; color:#000; border-left: 1px solid #999; }
#list2 ol li p em { display:block; }

    </style>


</head>
<body>

    <!-- ********************************************************************************************************* -->
    <!-- Begin Module: 1 Column | NoPadding | NoBreak -->
    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        <tbody>
            <tr>
                <td align='center'>
                    <table class='BoxWrap' width='800' align='center' cellpadding='0' cellspacing='0'>
                        <tbody>
                            <tr>
                                <td height='20'></td>
                            </tr>
                            <tr>
                                <td>
                                    <table width='100%' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td class='Text_H3' style='text-align:center; color:#ffffff!important;' mc:edit='Text_H31'>
                                                    <span><i>" + item[0].Capacitacion_stConvocatoria.Convocatoria + " con vigencia del " + item[0].Capacitacion_stConvocatoria.FechaInicioConvocatoria.ToShortDateString() + " al " + item[0].Capacitacion_stConvocatoria.FechaTerminoConvocatoria.ToShortDateString() + @"</i></span>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                            </tr>
                            <tr>
                                <td height='20'></td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
            <!-- End Module: 1 Column | NoPadding | NoBreak -->
        </tbody>
    </table>

    <!-- ********************************************************************************************************* -->
    <!-- Begin Module: 2 Column | Padding | BreakOnPC -->
    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        <tbody>
            <tr>
                <td align='center'>
                    <table class='BoxWrap BackgroundColor05 Rounded_Top' bgcolor='#DBDBDB' width='800' align='center' cellpadding='0' cellspacing='0'>
                        <tbody>
                            <tr>
                                <td colspan='3' width='100%' height='20'></td>
                            </tr>
                            <tr>
                                <td width='120' class='respo-margin'></td>
                                <td width='560'>
                                    <!-- // Begin: First Column \\ -->
                                    <table class='Respo1Column' align='left' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td width='75' class='Respo1Column' align='center' valign='top'>
                                                    <img mc:edit='' src='https://www.cecyteo.edu.mx/Nova/App_Themes/Nova2015/img/logocecyte.png' alt=' ' border=' 0' style='width: 75px; display: block;'>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <!-- // End: First Column \\ -->
                                    <!-- ************************** -->
                                    <!-- // Begin: Second Column \\ -->
                                    <table class='Respo1Column' align='right' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <table align='center' cellpadding='0' cellspacing='0'>
                                                        <tbody>
                                                            <tr>
                                                                <td class='Text_H3' style='line-height:50px!important; color:#242424 !important;' mc:edit='Text_H32'>
                                                                    COLEGIO DE ESTUDIOS CIENTÍFICOS Y TECNOLÓGICOS DEL ESTADO DE OAXACA.
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <!-- // End: Second Column \\ -->
                                </td>
                                <td width='120' class='respo-margin'></td>
                            </tr>
                            <tr>
                                <td colspan='3' width='100%' height='20'></td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
            <!-- End Module: 2 Column | Padding | BreakOnPC -->
        </tbody>
    </table>

    <!-- ********************************************************************************************************* -->
    <!-- Begin Module: Caption - One Column Segment -->
    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        <tbody>
            <tr>
                <td align='center'>
                    <table class='BoxWrap fixed-bg-style BackgroundColor01' bgcolor='#ffffff' width='800' align='center' cellpadding='0' cellspacing='0'>
                        <tbody>
                            <tr>
                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
                            </tr>
                            <tr>
                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
                            </tr>
                            <tr>
                                <td width='120' class='respo-margin'></td>
                                <td class='RespoTabletWidth' width='560'>
                                    <table width='100%' cellpadding='0' cellspacing='0'>
                                        <tbody>";

            foreach (var ele in item)
            {

                msg.Body = msg.Body + @"
                                            <tr>
                                                <td class='Text_H1' style='text-align:center;' mc:edit='Text_H13'>
                                                    <span>Curso : " + ele.Capacitacion_ctCurso.Curso + " del " + ele.FechaInicioCurso.ToShortDateString() + " al " + ele.FechaTerminoCurso.ToShortDateString() + @"</span>
<hr>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td width='100%' height='5'></td>
                                            </tr>
                                            <tr>
                                                <td class='Text_H3' style='text-align:center;' mc:edit='Text_H34'>
                                                
                                                </td>
                                            </tr>";
            }

            msg.Body = msg.Body + @"</tbody>
                                    </table>
                                </td>
                                <td width='120' class='respo-margin'></td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </tbody>
    </table>
 
    <!-- Begin Module: Paragraph - One Column Segment -->
    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        <tbody>
            <tr>
                <td align='center'>
                    <table class='BoxWrap fixed-bg-style BackgroundColor05' bgcolor='#DBDBDB' width='800' align='center' cellpadding='0' cellspacing='0'>
                        <tbody>
                            <tr>
                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
                            </tr>
                            <tr>
                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
                            </tr>
                            <tr>
                                <td width='120' class='respo-margin'></td>
                                <td class='RespoTabletWidth' width='560'>
                                    <table width='100%' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td class='Text_H1 respo-center-tablet' style='color:#ffffff!important; text-align:center;' mc:edit='Text_H117'>
                                                   <tr>
<td>

<div id='list2'>
   <ol>
      <li><p><em>Activa tu cuenta en el sistema NOVA (omite este paso si ya activaste tu cuenta previamente)</p></li>
      <li><p><em>Al ingresar al sistema en la parte superior derecha da click sobre la alerta de Invitaciones </p></li>
      <li><p><em>Selecciona el curso de tu intéres</p></li>
      <li><p><em>Inscríbete e imprime tu acuse de inscripción</p></li>
      <li><p><em>Puedes darte de baja del curso al que te has inscrito e inscribirte a otro durante todo el tiempo que dure la convocatoria</p></li>

   </ol>
<p>Si tienes algun problema técnico puedes comunicarte al teléfono 951-5032660 , con el Área de Sistemas, en el horario de 08:00 a 16:00 horas.</p>
</div>

                                                </td>
                                            </tr>
                                            <tr>
                                                <td height='20'>&nbsp;</td>
                                            </tr>
                                            <!-- Button -->
                                            <tr>
                                                <td width='100%' align='center'>
                                                    <table class='BackgroundColor05 btn-style RespoTabletWidth' bgcolor='#DBDBDB' align='center' cellpadding='7' cellspacing='0' style='border-radius:4px;'>
                                                        <tbody style='background-color: #82BA00;'>


                                                                <td>&nbsp; </td>
                                                                <td class='Text_H4' style='text-align: center; color:#ffffff; vertical-align: middle; text-transform:uppercase;' mc:edit='Text_H418'>
                                                                    <span style='color:#ffffff;'><a href='" + url + @"' style='text-align: center; color:#ffffff; vertical-align: middle; text-transform:uppercase;'>Inscríbete</a></span>
                                                                </td>
                                                                <td>&nbsp; </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                                <td width='120' class='respo-margin'></td>
                            </tr>
                            <tr>
                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
                            </tr>
                            <tr>
                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </tbody>
    </table>
    <!-- End Module: Paragraph - One Column Segment -->
    <!-- ********************************************************************************************************* -->
    <!-- Begin Module: 2 Column | Padding | BreakOnPC -->
    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        <tbody>
            <tr>
                <td align='center'>
                    <table class='BoxWrap BackgroundColor01 Rounded_Bottom' bgcolor='#ffffff' width='800' align='center' cellpadding='0' cellspacing='0'>
                        <tbody>
                            <tr>
                                <td colspan='3' width='100%' height='20'></td>
                            </tr>
                            <tr>
                                <td width='120' class='respo-margin'></td>
                                <td width='560'>
                                    <!-- // Begin: First Column \\ -->
                                    <table class='Respo1Column' align='left' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <table align='center' cellpadding='0' cellspacing='0'>
                                                        <tbody>
                                                            <tr>
                                                                <td class='Text_H3' style='line-height:50px!important; text-align:center;' mc:edit='Text_H319'>
                                                                    <span>PROGRAMA DE FORMACIÓN DOCENTE - " + DateTime.Now.Year + @" </span>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <!-- // End: First Column \\ -->
                                    <!-- ************************** -->
                                    <!-- // Begin: Second Column \\ -->
                                    <table class='Respo1Column' align='right' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <table align='center' cellpadding='0' cellspacing='0'>
                                                        <tbody>
                                                            <tr>
                                                                <td class='Text_H3' style='line-height:50px!important; text-align:center;' mc:edit='Text_H320'>
                                                                    <span><a href='https://www.cecyteo.edu.mx/Nova'> <img mc:edit='' src='https://www.cecyteo.edu.mx/Nova/App_Themes/Nova2015/img/logonovablack.png' alt='NOVA' style='display: block;'></a></span>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <!-- // End: Second Column \\ -->
                                </td>
                                <td width='120' class='respo-margin'></td>
                            </tr>
                            <tr>
                                <td colspan='3' width='100%' height='20'></td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
            <!-- End Module: 2 Column | Padding | BreakOnPC -->
        </tbody>
    </table>

    <!-- ********************************************************************************************************* -->
    <!-- Begin Module: 1 Column | NoPadding | NoBreak -->
    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        <tbody>
            <tr>
                <td align='center'>
                    <table class='BoxWrap' width='800' align='center' cellpadding='0' cellspacing='0'>
                        <tbody>
                            <tr>
                                <td height='20'></td>
                            </tr>
                            <tr>
                                <td height='20'></td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
          
        </tbody>
    </table>


</body>
</html>";
            //msg.Body = "<p>Estimado Trabajador</p><strong></strong><p>Para activar su cuenta para acceso al sistema NOVA del CECYTEO de clic en la siguiente liga <a href='" + url + "'>clic aquí</a> ";

            //msg.Body = msg.Body + " <p></p><p><strong>Cualquier duda o aclaración con este proceso favor de dirigirse con el Departamento de Sistemas a los teléfonos : (951) 666-666  ext. 666 de 08:00 a 16:00 horas de Lunes a Viernes.</strong></p> ";

            //msg.Body = msg.Body + " <p></p><p>Este correo fue generado automáticamente, favor de no responder.</p>";


            //  msg.Priority = MailPriority.High;

            SmtpClient client = new SmtpClient();


            client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
            client.Host = "smtp.gmail.com";
            client.Port = 587;
            client.DeliveryMethod = SmtpDeliveryMethod.Network;
            client.EnableSsl = true;


            try
            {
                client.Send(msg);

            }
            catch (Exception)
            {
                regresa = false;
                // throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
            }
            return regresa;
        }

        [HttpPost]
        public ActionResult InvitarXXX(int id)
        {
            Capacitacion_stConvocatoria convocatoria = db.Capacitacion_stConvocatoria.Find(id);


            convocatoria.FechaUltimaInvitacion = DateTime.Now;
            convocatoria.IdTrabajadorInvito = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.IdTrabajador;

            db.Entry(convocatoria).State = System.Data.Entity.EntityState.Modified;

            db.SaveChanges();

            List<vwDatosAspirantesTrabajadores> trabajadoresvigentes = db.vwDatosAspirantesTrabajadores.Where(r => r.EstatusTrabajador == "ALTA" && r.CorreoElectronico != "").ToList();

            List<TrabajadoresCorreos> trabajadores = new List<TrabajadoresCorreos>();

            int a = 0;
            int total = 0;
            foreach (var item in trabajadoresvigentes)
            {
                if (item.IdConvenioLaboralTrabajadorCategoria != null)
                {
                    total = total + 1;
                    List<Capacitacion_stConvocatoriasCursos> convocatorias = Capacitacion_stConvocatoriasCursosSedesAulas.getConvocagoriasDisponibles((int)item.IdTrabajador, (short)item.IdEstructuraOrganica, (short)item.IdCategoria, (short)item.IdRelacionLaboral, (short)item.IdConvenioLaboral, (short)item.IdEstructuraOrganicaPadre);
                    if (convocatorias.Count > 0)
                    {
                        TrabajadoresCorreos trabajador = new TrabajadoresCorreos();
                        trabajador.Nombre = item.Nombre;
                        trabajador.ApellidoPaterno = item.ApellidoPaterno;
                        trabajador.ApellidoMaterno = item.ApellidoMaterno;
                        trabajador.Categoria = item.Categoria;
                        trabajador.LaboraFisicamente = item.UbicacionFisica;
                        trabajador.CorreoElectronico = item.CorreoElectronico;
                        string miscursos = "";

                        foreach (var t in convocatorias)
                        {
                            miscursos = miscursos + t.Capacitacion_ctCurso.Curso + ", ";
                        }

                        //if (item.CorreoElectronico == "jcmc2@hotmail.com" || item.CorreoElectronico == "gaby_resa@hotmail.com" || item.CorreoElectronico == "rsantmont@yahoo.com"
                        //    || item.CorreoElectronico == "f_conh@hotmail.com" || item.CorreoElectronico == "enimiaelba@yahoo.com.mx" || item.CorreoElectronico == "miriandy_10@hotmail.com"
                        //    || item.CorreoElectronico == "lucityn@hotmail.com" || item.CorreoElectronico == "rovalo2002@yahoo.com" || item.CorreoElectronico == "emarcial2010@hotmail.com"
                        //    || item.CorreoElectronico == "ceibapentandra21@hotmail.com" || item.CorreoElectronico == "map_pl05etla@hotmail.com" || item.CorreoElectronico == "letymary64@hotmail.com"
                        //           || item.CorreoElectronico == "ara_pool@hotmail.com" || item.CorreoElectronico == "edipo137@hotmail.com" 
                            
 
                        //    )
                        //{
                        //    EnviarEmailInvitacion(item.CorreoElectronico, convocatorias);


                        //}
                        EnviarEmailInvitacion(item.CorreoElectronico, convocatorias);

                        trabajador.Cursos = miscursos;
                        trabajadores.Add(trabajador);
                        a = a + 1;

                    }
                }
            }

            ViewBag.enviados = a;
            ViewBag.total = total;
            return View(trabajadores);
        }


        public ActionResult Invitar(int id)
        {
            //Capacitacion_stConvocatoria convocatoria = db.Capacitacion_stConvocatoria.Find(id);


            //convocatoria.FechaUltimaInvitacion = DateTime.Now;
            //convocatoria.IdTrabajadorInvito = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.IdTrabajador;

            //db.Entry(convocatoria).State = System.Data.Entity.EntityState.Modified;

            //db.SaveChanges();
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

            string query;

            query = @"SELECT RFC
      ,IdKardex
      ,CURP
      ,Nombre
      ,ApellidoPaterno
      ,ApellidoMaterno
      ,Sexo
      ,IdTrabajador
      ,FechaAsignacion
      ,ConvenioLaboral
      ,RelacionLaboral
      ,Categoria
      ,EstructuraOrganica
      ,UbicacionFisica
      ,EstructuraOrganicaPadre
      ,EsComisionado
      ,FechaInicio
      ,FechaTermino
      ,IdConvenioLaboralTrabajador
      ,EstatusTrabajador
      ,IdConvenioLaboralTrabajadorCategoria
      ,Fotografia
      ,NSS
      ,CorreoElectronico
      ,IdCategoria
      ,IdEstructuraOrganica
      ,IdRelacionLaboral
      ,IdConvenioLaboral
      ,IdEstructuraOrganicaPadre
      ,CorreoInstitucional
      ,Telefono
      ,OrdenEstructuraOrganica
      ,IdEstructuraOrganicaFisica
      ,Antiguedad
      ,Años
      ,Meses
      ,Dias
      ,Direccion
      ,CorreoTrabajo
      ,TelefonoTrabajo
      ,ProcesoCompletado
  FROM  vwDatosAspirantesTrabajadores where EstatusTrabajador='ALTA' and CorreoElectronico <> '' ";




            List<vwDatosAspirantesTrabajadores> trabajadoresvigentes = (List<vwDatosAspirantesTrabajadores>)dp.connection.Query<vwDatosAspirantesTrabajadores>(query);

            dp.Close();

            //  List<vwDatosAspirantesTrabajadores> trabajadoresvigentes = db.vwDatosAspirantesTrabajadores.Where(r => r.EstatusTrabajador == "ALTA" && r.CorreoElectronico != "").ToList();

            List<TrabajadoresCorreos> trabajadores = new List<TrabajadoresCorreos>();

            int a = 0;
            int total = 0;
            foreach (var item in trabajadoresvigentes)
            {
                if (item.IdConvenioLaboralTrabajadorCategoria != null)
                {
                    total = total + 1;
                    List<Capacitacion_stConvocatoriasCursos> convocatorias = Capacitacion_stConvocatoriasCursosSedesAulas.getConvocagoriasDisponibles((int)item.IdTrabajador, (short)item.IdEstructuraOrganicaFisica, (short)item.IdCategoria, (short)item.IdRelacionLaboral, (short)item.IdConvenioLaboral, (short)item.IdEstructuraOrganicaPadre);
                    if (convocatorias.Count > 0)
                    {
                        TrabajadoresCorreos trabajador = new TrabajadoresCorreos();
                        trabajador.Nombre = item.Nombre;
                        trabajador.ApellidoPaterno = item.ApellidoPaterno;
                        trabajador.ApellidoMaterno = item.ApellidoMaterno;
                        trabajador.Categoria = item.Categoria;
                        trabajador.LaboraFisicamente = item.UbicacionFisica;
                        trabajador.CorreoElectronico = item.CorreoElectronico;
                        string miscursos = "";

                        foreach (var t in convocatorias)
                        {
                            miscursos = miscursos + t.Capacitacion_ctCurso.Curso + ", ";
                        }


                        trabajador.Cursos = miscursos;
                        trabajadores.Add(trabajador);
                        a = a + 1;
                        EnviarEmailInvitacion(item.CorreoElectronico, convocatorias);
                    }
                }
            }

            ViewBag.enviados = a;
            ViewBag.total = total;
            return View("Invitar", trabajadores);
        }

        public ActionResult InvitarVistaPrevia(int id)
        {
            //Capacitacion_stConvocatoria convocatoria = db.Capacitacion_stConvocatoria.Find(id);


            //convocatoria.FechaUltimaInvitacion = DateTime.Now;
            //convocatoria.IdTrabajadorInvito = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.IdTrabajador;

            //db.Entry(convocatoria).State = System.Data.Entity.EntityState.Modified;

            //db.SaveChanges();
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

            string query;

            query = @"SELECT RFC
      ,IdKardex
      ,CURP
      ,Nombre
      ,ApellidoPaterno
      ,ApellidoMaterno
      ,Sexo
      ,IdTrabajador
      ,FechaAsignacion
      ,ConvenioLaboral
      ,RelacionLaboral
      ,Categoria
      ,EstructuraOrganica
      ,UbicacionFisica
      ,EstructuraOrganicaPadre
      ,EsComisionado
      ,FechaInicio
      ,FechaTermino
      ,IdConvenioLaboralTrabajador
      ,EstatusTrabajador
      ,IdConvenioLaboralTrabajadorCategoria
      ,Fotografia
      ,NSS
      ,CorreoElectronico
      ,IdCategoria
      ,IdEstructuraOrganica
      ,IdRelacionLaboral
      ,IdConvenioLaboral
      ,IdEstructuraOrganicaPadre
      ,CorreoInstitucional
      ,Telefono
      ,OrdenEstructuraOrganica
      ,IdEstructuraOrganicaFisica
      ,Antiguedad
      ,Años
      ,Meses
      ,Dias
      ,Direccion
      ,CorreoTrabajo
      ,TelefonoTrabajo
      ,ProcesoCompletado
  FROM  vwDatosAspirantesTrabajadores where EstatusTrabajador='ALTA' and CorreoElectronico <> '' ";




            List<vwDatosAspirantesTrabajadores> trabajadoresvigentes = (List<vwDatosAspirantesTrabajadores>)dp.connection.Query<vwDatosAspirantesTrabajadores>(query);

            dp.Close();

          //  List<vwDatosAspirantesTrabajadores> trabajadoresvigentes = db.vwDatosAspirantesTrabajadores.Where(r => r.EstatusTrabajador == "ALTA" && r.CorreoElectronico != "").ToList();

            List<TrabajadoresCorreos> trabajadores = new List<TrabajadoresCorreos>();

            int a = 0;
            int total = 0;
            foreach (var item in trabajadoresvigentes)
            {
                if (item.IdConvenioLaboralTrabajadorCategoria != null)
                {
                    total = total + 1;
                    List<Capacitacion_stConvocatoriasCursos> convocatorias = Capacitacion_stConvocatoriasCursosSedesAulas.getConvocagoriasDisponibles((int)item.IdTrabajador, (short)item.IdEstructuraOrganicaFisica, (short)item.IdCategoria, (short)item.IdRelacionLaboral, (short)item.IdConvenioLaboral, (short)item.IdEstructuraOrganicaPadre,true);
                    if (convocatorias.Count > 0)
                    {
                        TrabajadoresCorreos trabajador = new TrabajadoresCorreos();
                        trabajador.Nombre = item.Nombre;
                        trabajador.ApellidoPaterno = item.ApellidoPaterno;
                        trabajador.ApellidoMaterno = item.ApellidoMaterno;
                        trabajador.Categoria = item.Categoria;
                        trabajador.LaboraFisicamente = item.UbicacionFisica;
                        trabajador.CorreoElectronico = item.CorreoElectronico;
                        string miscursos = "";

                        foreach (var t in convocatorias)
                        {
                            miscursos = miscursos + t.Capacitacion_ctCurso.Curso + ", ";
                        }


                        trabajador.Cursos = miscursos;
                        trabajadores.Add(trabajador);
                        a = a + 1;

                    }
                }
            }

            ViewBag.enviados = a;
            ViewBag.total = total;
            return View("Invitar", trabajadores);
        }



        [ValidateInput(false)]
        public ActionResult PublicarConvocatoria()
        {
            var listatrabajadores = db.Capacitacion_stConvocatoria.Where(r => r.IdTrabajadorInvito != null).Select(o => o.IdTrabajadorInvito).ToList();

            ViewBag.trabajadores = db.vwDatosAspirantesTrabajadores.Where(f => listatrabajadores.Contains(f.IdTrabajador)).ToList();

            var model = db.Capacitacion_stConvocatoria.OrderByDescending(g => g.FechaInicioConvocatoria);
            return PartialView("_Publicar", model.ToList());
        }

        public ActionResult DetalleConvocatoria(int id)
        {
            ViewData["idconvocatoria"] = id;
            return PartialView("DetalleConvocatoria", db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.IdConvocatoria == id).ToList());
        }

        [ValidateInput(false)]
        public ActionResult Convocatoria()
        {
            var model = db.Capacitacion_stConvocatoria.OrderByDescending(o=>o.FechaInicioConvocatoria);
            return PartialView("_Convocatoria", model.ToList());
        }

        private object Reimpresiones(int id)
        {


            var vv = db.Capacitacion_stConstanciasParticipantes.Where(t => t.IdParticipantes == id).ToList();
            if (vv.Count == 0)
            {
                throw new ApplicationException("No se ha impreso de formal normal ninguna constancia para este participante, por lo que no se puede reimprimir");
            }
            int IdConstanciaParticipante = db.Capacitacion_stConstanciasParticipantes.Where(t => t.IdParticipantes == id).Select(g => g.IdConstanciaParticipante).FirstOrDefault();
            ViewBag.IdConstanciaParticipante = IdConstanciaParticipante;
            ViewBag.IdParticipante = id;

            Capacitacion_stParticipantes x = db.Capacitacion_stParticipantes.Where(r => r.IdParticipantes == id).FirstOrDefault();
            ViewBag.participante = x;

            var model = db.Capacitacion_stConstanciasImpresas.Where(t => t.Capacitacion_stConstanciasParticipantes.IdParticipantes == id).ToList();
            return model;
        }

        [ValidateInput(false)]
        public ActionResult VerReimpresiones(int id)
        {
            ViewBag.Imprimir = 0;
            return View("VerReimpresiones", Reimpresiones(id));
        }

        public ActionResult ImprimirReimpresiones(int id)
        {
            ViewBag.Imprimir = id;
            return View("VerReimpresiones", Reimpresiones(id));
        }

        [ValidateInput(false)]
        public ActionResult Reimprimir(int id)
        {
            Capacitacion_stConstanciasParticipantes model = db.Capacitacion_stConstanciasParticipantes.Where(p => p.IdParticipantes == id).FirstOrDefault();
            Capacitacion_stConstanciasImpresas impresas = new Capacitacion_stConstanciasImpresas();
            impresas.IdConstanciaParticipante = model.IdConstanciaParticipante;
            impresas.IdKardexResponsable = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            impresas.FechaImpresionConstancia = DateTime.Now;

            db.Capacitacion_stConstanciasImpresas.Add(impresas);
            db.SaveChanges();

            return View("_Convocatoria");
        }


        [HttpPost, ValidateInput(false)]
        public ActionResult ConvocatoriaAddNew(Nova.Models.Capacitacion_stConvocatoria item)
        {
            var fechaInicio= item.FechaInicioConvocatoria;
            var fechaTermino = item.FechaTerminoConvocatoria;
            item.Mes = (short)item.FechaInicioConvocatoria.Month;
            item.Año = (short)item.FechaInicioConvocatoria.Year;
            item.PublicarEnWeb = false;

            var model = db.Capacitacion_stConvocatoria;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            return PartialView("_Convocatoria", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionConvocatoriaUpdate(Nova.Models.Capacitacion_stConvocatoria item)
        {
            item.Mes = (short)item.FechaInicioConvocatoria.Month;
            item.Año = (short)item.FechaInicioConvocatoria.Year;
            item.PublicarEnWeb = false;

            var model = db.Capacitacion_stConvocatoria;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdConvocatoria == item.IdConvocatoria);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_Convocatoria", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult ConvocatoriaUpdate(Nova.Models.Capacitacion_stConvocatoria item)
        {
            item.Mes = (short)item.FechaInicioConvocatoria.Month;
            item.Año = (short)item.FechaInicioConvocatoria.Year;
            item.PublicarEnWeb = true;
            //item.FechaInicioConvocatoria = item.FechaInicioConvocatoria.Date;
            //item.FechaTerminoConvocatoria = item.FechaTerminoConvocatoria.Date;

            var model = db.Capacitacion_stConvocatoria;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdConvocatoria == item.IdConvocatoria);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();

                        //limpia la sedssio para el sinlgeton de cursos para cada trabajador
                        CursosActivos limpiar = CursosActivos.Clean;
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else

                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                                   .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            var listatrabajadores = db.Capacitacion_stConvocatoria.Where(r => r.IdTrabajadorInvito != null).Select(o => o.IdTrabajadorInvito).ToList();

            ViewBag.trabajadores = db.vwDatosAspirantesTrabajadores.Where(f => listatrabajadores.Contains(f.IdTrabajador)).ToList();

            //  var model = db.Capacitacion_stConvocatoria.OrderByDescending(g => g.FechaInicioConvocatoria);
            //  model = db.Capacitacion_stConvocatoria;

            //return PartialView("_Convocatoria", model.ToList());
            return RedirectToAction("Publicar");
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult ConvocatoriaDelete(System.Byte IdConvocatoria)
        {
            var model = db.Capacitacion_stConvocatoria;
            if (IdConvocatoria != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdConvocatoria == IdConvocatoria);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message; ;
                }
            }
            return PartialView("_Convocatoria", model.ToList());
        }

        //public ActionResult ExportTo(string filterString)
        //{


        //    return GridViewExtension.ExportToXls(GridViewHelper.ExportGridViewSettings, db.Capacitacion_stConvocatoria.ToList());



        //}
        //public void ExportReport(XtraReport report, string fileName, bool saveAsFile, string fileFormat)
        //{
        //    using (MemoryStream stream = new MemoryStream())
        //    {
        //        report.ExportToXlsx(stream);

        //        string disposition = saveAsFile ? "attachment" : "inline";

        //        Response.Clear();
        //        Response.Buffer = false;
        //        Response.AppendHeader("Content-Type", string.Format("application/{0}", fileFormat));
        //        Response.AppendHeader("Content-Transfer-Encoding", "binary");
        //        Response.AppendHeader("Content-Disposition", string.Format("{0}; filename={1}.{2}", disposition, HttpUtility.UrlEncode(fileName).Replace("+", "%20"), fileFormat));
        //        Response.BinaryWrite(stream.ToArray());
        //        Response.End();
        //    }
        //}

        public ActionResult ExportDetailsTo()
        {

            var model = db.Capacitacion_stConvocatoria;
            GridViewExportFormat format = GridViewExportFormat.Xlsx;
            GridViewSettings masterGridSettings = GridViewExportDemoHelper.CreateGeneralMasterGridSettings();
            return GridViewExportDemoHelper.ExportFormatsInfo[format](masterGridSettings, db.Capacitacion_stConvocatoria.OrderByDescending(j => j.FechaInicioConvocatoria).ToList());

        }
        //public ActionResult ExportDetailsMasterPartial()
        //{
        //    return PartialView("ExportDetailsMasterPartial", db.Capacitacion_stConvocatoria.OrderByDescending(j => j.FechaInicioConvocatoria).ToList());
        //}
        //public ActionResult ExportDetailsDetailPartial(int IdConvocatoria)
        //{
        //    ViewBag.CategoryID = IdConvocatoria;
        //    return PartialView("ExportDetailsDetailPartial", db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.IdConvocatoria == IdConvocatoria).ToList());
        //}
    }

    //public static class GridViewExportDemoHelper
    //{
    //    private static GridViewExportDemoHelper exportGridViewSettings;

    //    public static GridViewExportDemoHelper ExportGridViewSettings
    //    {
    //        get
    //        {
    //            if (exportGridViewSettings == null)
    //                exportGridViewSettings = CreateExportGridViewSettings();
    //            return exportGridViewSettings;
    //        }
    //    }

    //    private static GridViewExportDemoHelper CreateExportGridViewSettings()
    //    {
    //        GridViewSettings = new GridViewSettings();
    //        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

    //        settings.Name = "GridView";
    //        //settings.CallbackRouteValues = new { Controller = "Busqueda", Action = "BuscarTrabajadores" };

    //        settings.KeyFieldName = "IdConvocatoria";
    //        //settings.Settings.ShowFilterRow = true;

    //        settings.Columns.Add("Convocatoria");
    //        settings.Columns.Add("PublicarEnWeb");

    //        settings.SettingsDetail.ShowDetailRow = true;
    //        settings.SettingsDetail.ExportMode = GridViewDetailExportMode.None;

    //        settings.SettingsExport.GetExportDetailGridViews = (s, e) =>
    //        {
    //            int IdConvocatoria = (int)DataBinder.Eval(e.DataItem, "IdConvocatoria");
    //            GridViewExtension grid = new GridViewExtension(CreateGeneralDetailGridSettings(IdConvocatoria));
    //            grid.Bind(db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.IdConvocatoria == IdConvocatoria).ToList());
    //            e.DetailGridViews.Add(grid);
    //        };


    //        return settings;
    //    }

    //    public static GridViewExportDemoHelper CreateGeneralDetailGridSettings(int uniqueKey)
    //    {
    //        GridViewSettings settings = new GridViewSettings();
    //        settings.Name = "detailGrid" + uniqueKey;
    //        settings.Width = Unit.Percentage(100);

    //        settings.KeyFieldName = "IdConvocatoriaCursosSedesAulas";
    //        settings.Columns.Add("Capacitacion_stConvocatoriasCursos.Capacitacion_ctCurso.Curso");
    //        settings.Columns.Add("Capacitacion_stAulaSede.Capacitacion_ctSede.Sede");


    //        settings.SettingsDetail.MasterGridName = "grid";

    //        return settings;
    //    }
    //}

    public enum GridViewExportFormat { None, Pdf, Xls, Xlsx, Rtf, Csv }
    public delegate ActionResult GridViewExportMethod(GridViewSettings settings, object dataObject);
    public partial class GridViewExportDemoHelper
    {

        static Dictionary<GridViewExportFormat, GridViewExportMethod> exportFormatsInfo;
        public static Dictionary<GridViewExportFormat, GridViewExportMethod> ExportFormatsInfo
        {
            get
            {
                if (exportFormatsInfo == null)
                    exportFormatsInfo = CreateExportFormatsInfo();
                return exportFormatsInfo;
            }
        }
        static Dictionary<GridViewExportFormat, GridViewExportMethod> CreateExportFormatsInfo()
        {
            return new Dictionary<GridViewExportFormat, GridViewExportMethod> {
                { GridViewExportFormat.Pdf, GridViewExtension.ExportToPdf },
                {
                    GridViewExportFormat.Xls,
                    (settings, data) => GridViewExtension.ExportToXls(settings, data, new XlsExportOptionsEx { ExportType = DevExpress.Export.ExportType.WYSIWYG })
                },
                {
                    GridViewExportFormat.Xlsx,
                    (settings, data) => GridViewExtension.ExportToXlsx(settings, data, new XlsxExportOptionsEx { ExportType = DevExpress.Export.ExportType.WYSIWYG })
                },
                { GridViewExportFormat.Rtf, GridViewExtension.ExportToRtf },
                {
                    GridViewExportFormat.Csv,
                    (settings, data) => GridViewExtension.ExportToCsv(settings, data, new CsvExportOptionsEx { ExportType = DevExpress.Export.ExportType.WYSIWYG })
                }
            };
        }
        //public static GridViewSettings CreateGeneralMasterGridSettings()
        //{
        //    return CreateGeneralMasterGridSettings();
        //}
        public static GridViewSettings CreateGeneralMasterGridSettings()
        {
            GridViewSettings settings = new GridViewSettings();
            settings.Name = "masterGrid";
            settings.Width = Unit.Percentage(100);


            Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

            settings.Name = "GridView";
            //settings.CallbackRouteValues = new { Controller = "Busqueda", Action = "BuscarTrabajadores" };

            settings.KeyFieldName = "IdConvocatoria";
            //settings.Settings.ShowFilterRow = true;

            settings.Columns.Add("Convocatoria");
            settings.Columns.Add("PublicarEnWeb");

            settings.SettingsDetail.ShowDetailRow = true;
            settings.SettingsDetail.ExportMode = GridViewDetailExportMode.None;

            settings.SettingsExport.GetExportDetailGridViews = (s, e) =>
            {
                int IdConvocatoria = (int)DataBinder.Eval(e.DataItem, "IdConvocatoria");
                GridViewExtension grid = new GridViewExtension(CreateGeneralDetailGridSettings(IdConvocatoria));
                grid.Bind(db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.IdConvocatoria == IdConvocatoria).ToList());
                e.DetailGridViews.Add(grid);
            };

            return settings;
        }

        public static GridViewSettings CreateGeneralDetailGridSettings(int uniqueKey)
        {
            GridViewSettings settings = new GridViewSettings();
            settings.Name = "detailGrid" + uniqueKey;
            settings.Width = Unit.Percentage(100);

            settings.KeyFieldName = "IdConvocatoriaCursosSedesAulas";
            settings.Columns.Add("Capacitacion_stConvocatoriasCursos.Capacitacion_ctCurso.Curso");
            settings.Columns.Add("Capacitacion_stAulaSede.Capacitacion_ctSede.Sede");


            settings.SettingsDetail.MasterGridName = "masterGrid";

            return settings;
        }
    }
}
