﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Seguridad;
using Nova.Libraries;

namespace Nova.Controllers.Capacitacion
{
    public class CapacitacionConstanciasImpresasController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: CapacitacionConstanciasImpresas
        public ActionResult Index()
        {
            var capacitacion_stConstanciasImpresas = db.Capacitacion_stConstanciasImpresas.Include(c => c.Capacitacion_stConstanciasParticipantes).Include(c => c.Kardex_ctDatosPersonales).Include(c => c.Kardex_ctDatosPersonales1);
            return View(capacitacion_stConstanciasImpresas.ToList());
        }

        // GET: CapacitacionConstanciasImpresas/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Capacitacion_stConstanciasImpresas capacitacion_stConstanciasImpresas = db.Capacitacion_stConstanciasImpresas.Find(id);
            if (capacitacion_stConstanciasImpresas == null)
            {
                return HttpNotFound();
            }
            return View(capacitacion_stConstanciasImpresas);
        }

        // GET: CapacitacionConstanciasImpresas/Create
        public ActionResult Create(int id,int idparticipante)
        {
            ViewBag.IdConstanciaParticipante = id;
            ViewBag.IdParticipante = idparticipante;
            return  PartialView();
        }

        // POST: CapacitacionConstanciasImpresas/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        
        public ActionResult Create([Bind(Include = "Observaciones,IdConstanciaParticipante")] Capacitacion_stConstanciasImpresas capacitacion_stConstanciasImpresas)
        {
            capacitacion_stConstanciasImpresas.FechaImpresionConstancia = DateTime.Now;
            capacitacion_stConstanciasImpresas.IdKardexResponsable = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            
             int IdParticipante = System.Convert.ToInt32(Request["IdParticipante"]);

            ViewBag.IdParticipante = IdParticipante;

            if (ModelState.IsValid)
            {
                db.Capacitacion_stConstanciasImpresas.Add(capacitacion_stConstanciasImpresas);
                db.SaveChanges();
                
                string[] names = new string[1];
                names[0] = IdParticipante.ToString();
                Session["IdsParticipantes"] = names;
                return RedirectToAction("ImprimirReimpresiones", "CapacitacionConvocatoria", new { id = IdParticipante });
            }
            else
            {
                MessageBox.Show(ViewData, TipoMensaje.Error, "No se ha podido completar la reimpresión, favor de notificarlo al administrador del sistema");
                return RedirectToAction("VerReimpresiones", "CapacitacionConvocatoria", new { id = IdParticipante });
            }

           
         //   ViewBag.IdConstaciaParticipante = capacitacion_stConstanciasImpresas.IdConstanciaParticipante;


            
           
            //return View(capacitacion_stConstanciasImpresas);
        }

        // GET: CapacitacionConstanciasImpresas/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Capacitacion_stConstanciasImpresas capacitacion_stConstanciasImpresas = db.Capacitacion_stConstanciasImpresas.Find(id);
            if (capacitacion_stConstanciasImpresas == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdConstanciaParticipante = new SelectList(db.Capacitacion_stConstanciasParticipantes, "IdConstanciaParticipante", "IdConstanciaParticipante", capacitacion_stConstanciasImpresas.IdConstanciaParticipante);
            ViewBag.IdKardexResponsable = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", capacitacion_stConstanciasImpresas.IdKardexResponsable);
            ViewBag.IdKardexResponsable = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", capacitacion_stConstanciasImpresas.IdKardexResponsable);
            return View(capacitacion_stConstanciasImpresas);
        }

        // POST: CapacitacionConstanciasImpresas/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdConstanciasImpresas,IdConstanciaParticipante,FechaImpresionConstancia,Observaciones,IdKardexResponsable")] Capacitacion_stConstanciasImpresas capacitacion_stConstanciasImpresas)
        {
            if (ModelState.IsValid)
            {
                db.Entry(capacitacion_stConstanciasImpresas).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdConstanciaParticipante = new SelectList(db.Capacitacion_stConstanciasParticipantes, "IdConstanciaParticipante", "IdConstanciaParticipante", capacitacion_stConstanciasImpresas.IdConstanciaParticipante);
            ViewBag.IdKardexResponsable = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", capacitacion_stConstanciasImpresas.IdKardexResponsable);
            ViewBag.IdKardexResponsable = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", capacitacion_stConstanciasImpresas.IdKardexResponsable);
            return View(capacitacion_stConstanciasImpresas);
        }

        // GET: CapacitacionConstanciasImpresas/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Capacitacion_stConstanciasImpresas capacitacion_stConstanciasImpresas = db.Capacitacion_stConstanciasImpresas.Find(id);
            if (capacitacion_stConstanciasImpresas == null)
            {
                return HttpNotFound();
            }
            return View(capacitacion_stConstanciasImpresas);
        }

        // POST: CapacitacionConstanciasImpresas/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Capacitacion_stConstanciasImpresas capacitacion_stConstanciasImpresas = db.Capacitacion_stConstanciasImpresas.Find(id);
            db.Capacitacion_stConstanciasImpresas.Remove(capacitacion_stConstanciasImpresas);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
