﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Seguridad;
using System.Collections;
using Rotativa;
namespace Nova.Controllers.Capacitacion
{
    public class CapacitacionConstanciasController : Controller
    {



        bdNovaEntities db = new bdNovaEntities();
        // GET: CapacitacionConstancias
        public ActionResult Index()
        {
            //int idk = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            //Capacitacion_ctCoordinadores ins = db.Capacitacion_ctCoordinadores.Where(t => t.IdKardex == idk).FirstOrDefault();
            //int id = 0;
            
            //if (ins == null)
            //    throw new ApplicationException("No esta asignado como coordinador de cursos");
            //else
            //    if (ins.FechaVencimientoCoordinador < DateTime.Now.Date)
            //        throw new ApplicationException("Ha finalizado su periodo como coordinador de cursos");
            //    else
            //        id = ins.IdKardex;

            //ViewBag.id = id;
            //var model = db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(r => r.Capacitacion_ctCoordinadores.IdKardex == id).ToList();

            return View();
        }

        public ActionResult ConstanciasGrupo(int IdConvocatoriaCursosSedesAulas)
        {

            string curso = "";
            string Aula = "";
            string Instructor = "";

            DateTime FechaInicioCurso = new DateTime();
            DateTime FechaTerminoCurso = new DateTime() ;

            //double diascurso = 0;
            ViewBag.IdConvocatoriaCursosSedesAulas = IdConvocatoriaCursosSedesAulas;
            var ca = (from a in db.Capacitacion_stConvocatoriasCursosSedesAulas
                      
                      join c in db.Capacitacion_stConvocatoriasCursos on a.IdConvocatoriaCursos equals c.IdConvocatoriaCursos
                      where a.IdConvocatoriaCursosSedesAulas == IdConvocatoriaCursosSedesAulas
                      select new { Curso = c.Capacitacion_ctCurso.Curso, FechaInicioCurso = c.FechaInicioCurso, FechaFinCurso = c.FechaTerminoCurso,Instructor=a.Capacitacion_ctInstructores.Nombre + " "+a.Capacitacion_ctInstructores.ApellidoPaterno + " "+a.Capacitacion_ctInstructores.ApellidoMaterno,Aula=a.Capacitacion_stAulaSede.Aula}); 

            foreach (var item in ca)
	            {
                    curso = item.Curso;
                    FechaInicioCurso = item.FechaInicioCurso;
                    FechaTerminoCurso = item.FechaFinCurso;
                    Instructor= item.Instructor;
                    Aula=item.Aula;
                //    TimeSpan diferencia = FechaTerminoCurso.Date - FechaInicioCurso.Date; 
                //diascurso =diferencia.TotalDays;
	            }

            List<Capacitacion_stParticipantes> listaparticipantes = db.Capacitacion_stParticipantes.Where(s => s.IdConvocatoriaCursosSedesAulas == IdConvocatoriaCursosSedesAulas && s.FechaCancelacion == null).OrderBy(b=> b.Kardex_ctDatosPersonales.CURP).ToList();
            if (listaparticipantes.Count() == 0)
                {

                    throw new ApplicationException("No existen participantes registrados en el curso " + curso);
                }
            if (FechaTerminoCurso.AddDays(10) < DateTime.Now)
            {
                throw new ApplicationException("El curso ha terminado y el periodo de 2 días para imprimir constancias ha expirado ");

            }

            ViewBag.curso = curso;
            ViewBag.fechainiciocurso = FechaInicioCurso;
            ViewBag.fechaterminocurso = FechaTerminoCurso;
            ViewBag.aula = Aula;
            ViewBag.instructor = Instructor;
            ViewBag.listaparticipantes = listaparticipantes;
           return View();
        }
        [HttpPost]
        public ActionResult ConstanciasGrupo(FormCollection form)
        {
            string[] datos = Request["hfdata"].Split(',');
            string valor = "";
            if (datos.Count() > 0)
            {

                foreach (var item in datos)
                {
                    if (item != "")
                    {

                        try
                        {
                            int idparticipante = System.Convert.ToInt16(item);
                            Capacitacion_stConstanciasParticipantes asis = db.Capacitacion_stConstanciasParticipantes.FirstOrDefault(s => s.IdParticipantes == idparticipante);
                            if (asis == null)
                            {
                                Capacitacion_stConstanciasParticipantes nueva = new Capacitacion_stConstanciasParticipantes();

                                valor = System.Convert.ToString(Request["check" + item]);
                                if (valor == "1")
                                {
                                    nueva.IdParticipantes = System.Convert.ToInt16(item);
                                    nueva.FechaConstancia = DateTime.Now;
                                db.Capacitacion_stConstanciasParticipantes.Add(nueva);
                                db.SaveChanges();

                                }
                            }
                        }
                        catch (Exception e)
                        {
                            ViewData["EditError"] = e.Message;
                        }
                    }

                }

                //   db.SaveChanges();
                //   scope.Complete();
                //   MessageBox.Show(ViewData, TipoMensaje.Success, "Tu solicitud ha sido enviada exitosamente");
                //}
            }
            Session["IdsParticipantes"] = datos;
            return RedirectToAction("ImpresionConstancias", "CapacitacionConstancias");

        }
        public ActionResult AcuseConstanciasGrupo(int IdConvocatoriaCursosSedesAulas)
        {

            Session["EncabezadoLista"] = null;
            string curso = "";
            string Aula = "";
            string Horario = "";
            string Convocatoria = "";
            string Grupo = "";
            string Instructor = "";
            string Sede = "";
            DateTime FechaInicioCurso = new DateTime();
            DateTime FechaTerminoCurso = new DateTime();

            //double diascurso = 0;
            //ViewBag.IdConvocatoriaCursosSedesAulas = IdConvocatoriaCursosSedesAulas;
            var ca = (from a in db.Capacitacion_stConvocatoriasCursosSedesAulas
                     
                      join c in db.Capacitacion_stConvocatoriasCursos on a.IdConvocatoriaCursos equals c.IdConvocatoriaCursos
                      where a.IdConvocatoriaCursosSedesAulas == IdConvocatoriaCursosSedesAulas
                      select new
                      {
                          Convocatoria = a.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.Convocatoria,
                          Curso = c.Capacitacion_ctCurso.Curso,
                          FechaInicioCurso = c.FechaInicioCurso,
                          FechaFinCurso = c.FechaTerminoCurso,
                          Horario = a.HorarioInicio + " - " + a.HorarioTermino,
                          Aula = a.Capacitacion_stAulaSede.Aula,
                          a.Grupo,
                          Instructor = a.Capacitacion_ctInstructores.Nombre + " " + a.Capacitacion_ctInstructores.ApellidoPaterno + " " + a.Capacitacion_ctInstructores.ApellidoMaterno,
                          Sede = a.Capacitacion_stAulaSede.Capacitacion_ctSede.Sede
                      });

            foreach (var item in ca)
            {
                Convocatoria = item.Convocatoria;
                curso = item.Curso;
                FechaInicioCurso = item.FechaInicioCurso;
                FechaTerminoCurso = item.FechaFinCurso;
                Horario = item.Horario;
                Aula = item.Aula;
                Grupo = item.Grupo;
                Instructor = item.Instructor;
                Sede = item.Sede;
                //    TimeSpan diferencia = FechaTerminoCurso.Date - FechaInicioCurso.Date; 
                //diascurso =diferencia.TotalDays;
            }
            List<Capacitacion_stConstanciasParticipantes> constacias= db.Capacitacion_stConstanciasParticipantes.Where (x=> x.EsCancelada == false).ToList();
            var listaid = constacias.Select(s => s.IdParticipantes).ToList();
            List<Capacitacion_stParticipantes> listaparticipantes = db.Capacitacion_stParticipantes.Where(s => s.IdConvocatoriaCursosSedesAulas == IdConvocatoriaCursosSedesAulas && s.FechaCancelacion == null && listaid.Contains(s.IdParticipantes)).ToList();
            if (listaparticipantes.Count() == 0)
            {

                throw new ApplicationException("No existen constancias impresas para el curso " + curso);
            }
            if (FechaTerminoCurso.AddDays(2) < DateTime.Now)
            {
                throw new ApplicationException("El curso ha terminado, no es posible imprimir el acuse de constancias");

            }

            Session["curso"] = curso;
            Session["fechainiciocurso"] = FechaInicioCurso;
            Session["fechaterminocurso"] = FechaTerminoCurso;
            Session["aula"] = Aula;
            Session["grupo"] = Grupo;
            Session["horario"] = Horario;
            Session["listaparticipantes"] = listaparticipantes;
            Session["convocatoria"] = Convocatoria;
            Session["instructor"] = Instructor;
            Session["sede"] = Sede;
            ViewBag.constancias = constacias;
            // 
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 10;
            m.Right = 5;
            m.Top = 0;

            string foot = " Fecha y hora de registro" + DateTime.Now.ToShortDateString();
            //return View();
            return new ViewAsPdf() { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = "AcuseConstancia.pdf" };
        }

        // Imprimir lista de asistencia
        public ActionResult ImpresionConstancias()
        {
            string[] datos = (string[])Session["IdsParticipantes"];
            List<Capacitacion_stParticipantes> ListaParticipantes = db.Capacitacion_stParticipantes.Where(x => datos.Any(key => x.IdParticipantes.ToString() == key)).ToList();
            ViewBag.ListaIdsParticipantes = ListaParticipantes;
            // 
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 10;
            m.Right = 5;
            m.Top = 0;
            
            string foot = " Fecha y hora de registro" + DateTime.Now.ToShortDateString();
            //return View();
            return new ViewAsPdf() { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = "ReporteConstancias.pdf" };
        }


        [ValidateInput(false)]
        public ActionResult CursoAulaSede()
        {
          //ViewBag.id  =id;

            var model = db.Capacitacion_stConvocatoriasCursosSedesAulas.OrderByDescending(s => new { s.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria ,s.Capacitacion_stConvocatoriasCursos.FechaInicioCurso}).ToList();
            //var model = db.Capacitacion_stParticipantes.Where(y => y.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_ctCoordinadores.IdKardex==id).OrderByDescending(v=> v.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursosSedes.Capacitacion_stConvocatoriasCursos.FechaInicioCurso);

            //var cmodel = db.Capacitacion_stParticipantes.Where(y => y.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursosSedes.Capacitacion_ctSede.Sede));

            return PartialView("_CursoAulaSede", model);
        }

    }
}