﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

using Nova.Libraries;

using System.Net.Mail;
using System.Net;

namespace Nova.Controllers.Capacitacion
{
    public class CapacitacionCarreraController : Controller
    {
        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        // GET: CapacitacionCarrera
        public ActionResult Index()
        {
            return View();
        }

        // GET: CapacitacionCarrera
        //public ActionResult Notificar(int id)
        //{
        //    Capacitacion_PersonalPermitidoCarrera item = db.Capacitacion_PersonalPermitidoCarrera.Find(id);

        //   List<Convenios_stConvenioLaboralTrabajadorCarrera> trabajadores = db.Convenios_stConvenioLaboralTrabajadorCarrera.Where(t => t.Plazas_stDistribucionPlazaCarrera.IdCarrera == item.IdCarrera && (t.FechaTermino == null || DateTime.Now <= t.FechaTermino)).ToList();
        //   ViewBag.trabajadores = trabajadores;
        //    return View(item);
        //}

        //[HttpPost]
        // public ActionResult EnviarNotificacion(int id)
        // {
        //     Capacitacion_PersonalPermitidoCarrera item = db.Capacitacion_PersonalPermitidoCarrera.Find(id);

        //     List<Convenios_stConvenioLaboralTrabajadorCarrera> correos = db.Convenios_stConvenioLaboralTrabajadorCarrera.Where(t => t.Plazas_stDistribucionPlazaCarrera.IdCarrera == item.IdCarrera && (t.FechaTermino == null || DateTime.Now <= t.FechaTermino)).ToList();
        //    // ViewBag.trabajadores = trabajadores;

        //     UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);

        //     string url = HttpContext.Request.Url.Scheme + "://" + HttpContext.Request.Url.Authority + u.Action("Index", "Home");

        //     Nova.Models.Capacitacion_PersonalPermitidoCarrera.EnviarEmailInvitacion("jcmc2@hotmail.com", item.Capacitacion_stConvocatoriasCursos, url);


        //    MessageBox.Show(ViewData, TipoMensaje.Success, "Se han enviado los correos electrónicos exitosamente ");

        //    Capacitacion_PersonalPermitidoCarrera variable = db.Capacitacion_PersonalPermitidoCarrera.Find(id);

        //    List<Convenios_stConvenioLaboralTrabajadorCarrera> trabajadores = db.Convenios_stConvenioLaboralTrabajadorCarrera.Where(t => t.Plazas_stDistribucionPlazaCarrera.IdCarrera == item.IdCarrera && (t.FechaTermino == null || DateTime.Now <= t.FechaTermino)).ToList();
        //    ViewBag.trabajadores = trabajadores;


        //    return View("Notificar", variable);
        // }

        [ValidateInput(false)]
        public ActionResult Carrera()
        {
            var model = db.Capacitacion_PersonalPermitidoCarrera;
            return PartialView("_Carrera", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult CarreraAddNew(Nova.Models.Capacitacion_PersonalPermitidoCarrera item)
        {
            ViewData["Item"] = item;
            var model = db.Capacitacion_PersonalPermitidoCarrera;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                    model = db.Capacitacion_PersonalPermitidoCarrera;
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            return PartialView("_Carrera", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult CarreraUpdate(Nova.Models.Capacitacion_PersonalPermitidoCarrera item)
        {

            var model = db.Capacitacion_PersonalPermitidoCarrera;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdPersonalPermitidoCarrera == item.IdPersonalPermitidoCarrera);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_Carrera", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult CarreraDelete(System.Byte IdPersonalPermitidoCarrera)
        {
            var model = db.Capacitacion_PersonalPermitidoCarrera;
            if (IdPersonalPermitidoCarrera != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPersonalPermitidoCarrera == IdPersonalPermitidoCarrera);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_Carrera", model.ToList());
        }
    }

}