﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

using Nova.Libraries;

using System.Net.Mail;
using System.Net;
using Seguridad;

using Rotativa;
using System.Transactions;
using System.Data.Entity;

namespace Nova.Controllers
{
    public class CapacitacionAulasController : Controller
    {
        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();
        // GET: CapacitacionAulas
        public ActionResult Index()
        {
            return View();
        }

        public ActionResult OficioComision(int id)
        {
            Capacitacion_stParticipantes model = db.Capacitacion_stParticipantes.Find(id);
            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 2;
            m.Left = 0;
            m.Right = 0;
            m.Top = 2;
            return new ViewAsPdf("_OficioComision", model) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Portrait, PageMargins = m, FileName = "Oficio.pdf" };
            // return View("_OficioComision",model);
        }


        public ActionResult Inscribir()
        {


            return View(getTodosLosCursos());
        }


        public ActionResult Trabajadores(string gridname, string scriptfunction)
        {
            //var model = db1.vwLocalidades;

            ViewData["gridname"] = gridname;
            ViewData["scriptfunction"] = scriptfunction;


            return PartialView("_Trabajadores");
        }

        public ActionResult OficiosComisionesAdmin(int idParticipante)
        {
            List<Capacitacion_stParticipantes> model = db.Capacitacion_stParticipantes.Where(n => n.IdParticipantes == idParticipante).ToList();
            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 0;
            m.Right = 0;
            m.Top = 0;
            return new ViewAsPdf("_OficioComision", model) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Portrait, PageMargins = m, FileName = "Oficio.pdf" };
            //   return View("_OficioComision",model);
        }

        public ActionResult OficiosComisiones(int id)
        {
            List<Capacitacion_stParticipantes> model = db.Capacitacion_stParticipantes.Where(n => n.IdParticipantes == id).ToList();
            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 0;
            m.Right = 0;
            m.Top = 0;
            return new ViewAsPdf("_OficioComision", model) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Portrait, PageMargins = m, FileName = "Oficio.pdf" };
            //   return View("_OficioComision",model);
        }

        public ActionResult ImprimirGafetes()
        {
            int idk = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Capacitacion_ctCoordinadores ins = db.Capacitacion_ctCoordinadores.Where(t => t.IdKardex == idk).OrderByDescending(g=> g.FechaRegistroCoordinador).FirstOrDefault();
            int id = idk;

            //if (ins == null)
            //    throw new ApplicationException("No esta asignado como coordinador de cursos");
            //else
            //    if (ins.FechaVencimientoCoordinador < DateTime.Now.Date)
            //        throw new ApplicationException("Ha finalizado su periodo como coordinador de cursos");
            //    else
            //        id = ins.IdKardex;

            ViewBag.id = id;
            //var model = db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(r => r.Capacitacion_ctCoordinadores.IdKardex == id).ToList();

            return View();
        }

        public ActionResult ListarGafetes()
        {


            var model = db.Capacitacion_stConvocatoriasCursosSedesAulas.OrderByDescending(y => new { y.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria, y.Capacitacion_stConvocatoriasCursos.FechaInicioCurso }).ToList();
            //if (model.Count() == 0)
            //{

            //    throw new ApplicationException("No existen cursos asignados a Ud. ");
            //}
            //var model = db.Capacitacion_stParticipantes.Where(y => y.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_ctCoordinadores.IdKardex==id).OrderByDescending(v=> v.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursosSedes.Capacitacion_stConvocatoriasCursos.FechaInicioCurso);

            //var cmodel = db.Capacitacion_stParticipantes.Where(y => y.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursosSedes.Capacitacion_ctSede.Sede));

            return PartialView("ListarGafetes", model);
        }

        public ActionResult Gafetes(int id)
        {
            List<Capacitacion_stParticipantes> model = db.Capacitacion_stParticipantes.Where(n => n.IdConvocatoriaCursosSedesAulas == id).ToList();
            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 0;
            m.Right = 0;
            m.Top = 0;
            return new ViewAsPdf("_Gafetes", model) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Portrait, PageMargins = m, FileName = "Gafetes.pdf" };
            //   return View("_OficioComision",model);
        }
        public ActionResult Participantes()
        {
            //var aulas = db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(r => r.IdCoordinador==id).Select(t=> t.IdConvocatoriaCursosSedesAulas).ToList();

            //var cmodel = db.Capacitacion_stParticipantes.Where(y => y.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursosSedes.Capacitacion_ctSede.Sede));

            return View();
        }

        public ActionResult ExportTo(string filterString)
        {
            var model = db.Capacitacion_stParticipantes.Where(t => t.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true).OrderByDescending(v => new { v.Capacitacion_stConvocatoriasCursosSedesAulas.IdConvocatoriaCursos, v.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stAulaSede.IdSede, v.Capacitacion_stConvocatoriasCursosSedesAulas.Grupo, v.Kardex_ctDatosPersonales.ApellidoPaterno, v.Kardex_ctDatosPersonales.Nombre }).ToList();
            return GridViewExtension.ExportToXls(GridViewHelper.ExportGridViewSettings, model);
        }

        [ValidateInput(false)]

        public ActionResult Listado()
        {

            var model = db.Capacitacion_stParticipantes.Where(t=>t.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb==true).OrderByDescending(v => new { v.Capacitacion_stConvocatoriasCursosSedesAulas.IdConvocatoriaCursos, v.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stAulaSede.IdSede, v.Capacitacion_stConvocatoriasCursosSedesAulas.Grupo, v.Kardex_ctDatosPersonales.ApellidoPaterno, v.Kardex_ctDatosPersonales.Nombre });

            return PartialView("_Listado", model.ToList());
        }
        public ActionResult CursosTomados()
        {
            int idkardex = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            var tomados = db.Capacitacion_stParticipantes.Where(h => h.IdKardex == idkardex).Select(g => g.IdConvocatoriaCursosSedesAulas).ToList();
            List<Capacitacion_stConvocatoriasCursosSedesAulas> cursos = db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(r => tomados.Contains(r.IdConvocatoriaCursosSedesAulas)).OrderByDescending(x=>x.Capacitacion_stConvocatoriasCursos.FechaInicioCurso).ToList();
            return PartialView(cursos);
        }

        public ActionResult MisCursos()
        {
            int idkardex = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            var tomados = db.Capacitacion_stParticipantes.Where(h => h.IdKardex == idkardex).Select(g => g.IdConvocatoriaCursosSedesAulas).ToList();
            List<Capacitacion_stConvocatoriasCursosSedesAulas> cursos = db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(r => tomados.Contains(r.IdConvocatoriaCursosSedesAulas)).OrderByDescending(x=>x.Capacitacion_stConvocatoriasCursos.FechaInicioCurso).ToList();
            return View("CursosTomados", cursos);
        }

        [HttpPost]
        public ActionResult InscribirUsuario(FormCollection form)
        {

            Int16 icsa = System.Convert.ToInt16(Request["hfidcursosedeaula"]);
            Int16 idkardex = System.Convert.ToInt16(Request["hfidkardex"]);


            Capacitacion_stConvocatoriasCursosSedesAulas aula = db.Capacitacion_stConvocatoriasCursosSedesAulas.Find(icsa);

            Capacitacion_stParticipantes participante = new Capacitacion_stParticipantes();

            participante.IdConvocatoriaCursosSedesAulas = icsa;
            participante.IdKardex = idkardex;
            participante.IdConvenioLaboralTrabajadorCategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(g => g.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex == idkardex).OrderByDescending(f => f.FechaInicio).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;
            participante.FechaRegistro = DateTime.Now;
            participante.EsCanceladoPorAdministrador = false;
            participante.Capacitacion_stConvocatoriasCursosSedesAulas = aula;




            if (participante.ValidaModelo().IsValid)
            {
                db.Capacitacion_stParticipantes.Add(participante);

                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {

                    try
                    {
                        db.SaveChanges();

                        var model = db.Capacitacion_stAsistencia;



                        for (var fecha = aula.Capacitacion_stConvocatoriasCursos.FechaInicioCurso; fecha.Date <= aula.Capacitacion_stConvocatoriasCursos.FechaTerminoCurso; fecha = fecha.AddDays(1))
                        {
                            Capacitacion_stAsistencia diaasistencia = new Capacitacion_stAsistencia();

                            diaasistencia.Asistencia = false;
                            diaasistencia.IdParticipantes = participante.IdParticipantes;
                            diaasistencia.FechaAsistencia = fecha;
                            try
                            {
                                model.Add(diaasistencia);
                                db.SaveChanges();
                            }
                            catch (Exception e)
                            {
                                throw new ApplicationException(ExceptionExtensions.GetOriginalException(e).Message);
                            }

                        }
                    }
                    catch (Exception e)
                    {
                        throw new ApplicationException(ExceptionExtensions.GetOriginalException(e).Message);
                    }

                    scope.Complete();
                }
                MessageBox.Show(ViewData, TipoMensaje.Success, "Se ha realizado la inscripción satisfactoriamente al curso");
                return View("Inscribir", getTodosLosCursos());

            }
            else
            {

                MessageBox.Show(ViewData, TipoMensaje.Error, participante.ValidaModelo().Mensaje);

                return View("Inscribir", getTodosLosCursos());
            }


        }

        [HttpPost]
        public ActionResult Inscribirme(FormCollection form)
        {

            Int16 icsa = System.Convert.ToInt16(Request["hfidcursosedeaula"]);
            string UsuarioCorreoGmail= System.Convert.ToString(Request["CorreoElectronicoGmail"]);
            string UsuarioTelefono = System.Convert.ToString(Request["Telefono"]);
            string UsuarioTelefonoCelular = System.Convert.ToString(Request["TelefonoCelular"]);
            bool UsuarioAceptaAviso = System.Convert.ToBoolean((System.Convert.ToString(Request["AceptaAviso"])==null?"false":"true"));

            try
            {
                MailAddress usuariogmail = new MailAddress(UsuarioCorreoGmail);
            }
            catch (Exception e)
            {
                string msg = ExceptionExtensions.GetOriginalException(e).Message;

                if (msg.Contains("address"))
                    msg = "El correo es un dato obligatorio";

                if (msg.Contains("La cadena especificada no tiene la forma obligatoria para una dirección de correo electrónico."))
                    msg = "El correo es un dato obligatorio";

                MessageBox.Show(ViewData, TipoMensaje.Error, msg);

                return View("Inscripcion", getCursos());
            }    

            


            if (UsuarioCorreoGmail.Trim() == "")
            {
                MessageBox.Show(ViewData, TipoMensaje.Error,"El correo es un dato obligatorio");
                
                return View("Inscripcion", getCursos());
            }


            if (!UsuarioCorreoGmail.Contains("@gmail.com"))
            {
                MessageBox.Show(ViewData, TipoMensaje.Error, "El correo debe ser del dominio @gmail.com");

                return View("Inscripcion", getCursos());
            }


            if (UsuarioTelefono.Trim()=="" || UsuarioTelefonoCelular.Trim() == "")
            {
                MessageBox.Show(ViewData, TipoMensaje.Error, "Los teléfonos son datos obligatorios");

                return View("Inscripcion", getCursos());
            }



            Models.Kardex_ctDatosPersonales UsuarioDatosPersonales = db.Kardex_ctDatosPersonales.Find(Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex);


            Capacitacion_stConvocatoriasCursosSedesAulas aula = db.Capacitacion_stConvocatoriasCursosSedesAulas.Find(icsa);

            Capacitacion_PersonalExcluidoConvocactoriaCursos restringidos = db.Capacitacion_PersonalExcluidoConvocactoriaCursos.Where(v=> v.IdConvocatoriaCursos==aula.IdConvocatoriaCursos).FirstOrDefault();
            //var cursoconrestriccion = db.Capacitacion_PersonalExcluidoConvocactoriaCursos.

            Boolean nohayrestriccion = true;
            if (restringidos!=null)
            {
                nohayrestriccion = false;
                int icltc = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                Capacitacion_PersonalExcluidoConvocactoriaCursos personalconderecho= db.Capacitacion_PersonalExcluidoConvocactoriaCursos.Where(v => v.IdConvocatoriaCursos == aula.IdConvocatoriaCursos && v.IdConvenioLaboralTrabajadorCategoria== icltc).FirstOrDefault();
                if (personalconderecho != null)
                {
                    nohayrestriccion = true;
                }
            }
            if (nohayrestriccion)
            {
                Capacitacion_stParticipantes participante = new Capacitacion_stParticipantes();

                participante.IdConvocatoriaCursosSedesAulas = icsa;
                participante.IdKardex = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
                participante.IdConvenioLaboralTrabajadorCategoria = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                participante.FechaRegistro = DateTime.Now;
                participante.EsCanceladoPorAdministrador = false;
                participante.Capacitacion_stConvocatoriasCursosSedesAulas = aula;




                if (participante.ValidaModelo().IsValid)
                {
                    db.Capacitacion_stParticipantes.Add(participante);

                    TransactionOptions transactionoptions1 = new TransactionOptions();
                    transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                    {

                        try
                        {

                            db.SaveChanges();

                            UsuarioDatosPersonales.Telefono = UsuarioTelefono;
                            UsuarioDatosPersonales.TelefonoCelular = UsuarioTelefonoCelular;
                            UsuarioDatosPersonales.CorreoElectronicoGmail = UsuarioCorreoGmail;
                            UsuarioDatosPersonales.AceptaAviso = UsuarioAceptaAviso;
                            db.Entry(UsuarioDatosPersonales).State = EntityState.Modified;
                            db.SaveChanges();
                                
                             

                            var model = db.Capacitacion_stAsistencia;



                            for (var fecha = aula.Capacitacion_stConvocatoriasCursos.FechaInicioCurso; fecha.Date <= aula.Capacitacion_stConvocatoriasCursos.FechaTerminoCurso; fecha = fecha.AddDays(1))
                            {
                                Capacitacion_stAsistencia diaasistencia = new Capacitacion_stAsistencia();

                                diaasistencia.Asistencia = false;
                                diaasistencia.IdParticipantes = participante.IdParticipantes;
                                diaasistencia.FechaAsistencia = fecha;
                                try
                                {
                                    model.Add(diaasistencia);
                                    db.SaveChanges();
                                }
                                catch (Exception e)
                                {
                                    throw new ApplicationException(ExceptionExtensions.GetOriginalException(e).Message);
                                }

                            }
                        }
                        catch (Exception e)
                        {
                            throw new ApplicationException(ExceptionExtensions.GetOriginalException(e).Message);
                        }

                        scope.Complete();
                    }
                    MessageBox.Show(ViewData, TipoMensaje.Success, "Se ha realizado la inscripción satisfactoriamente al curso");
                    return View("Inscripcion", getCursos());
                }
                else
                {

                    MessageBox.Show(ViewData, TipoMensaje.Error, participante.ValidaModelo().Mensaje);
                    //RedirectToAction("Inscripcion", new { id = icsa, mensaje = participante.ValidaModelo().Mensaje });
                    return View("Inscripcion", getCursos());
                }
            }
            else
            {

                MessageBox.Show(ViewData, TipoMensaje.Error, restringidos.Mensaje);
                //RedirectToAction("Inscripcion", new { id = icsa, mensaje = participante.ValidaModelo().Mensaje });
                return View("Inscripcion", getCursos());
            }
        }

        [HttpPost]
        public ActionResult Baja(FormCollection form)
        {

            Int16 icsa = System.Convert.ToInt16(Request["hfidcursosedeaulabaja"]);

            Int64 idusuario = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;


            Capacitacion_stParticipantes participante = db.Capacitacion_stParticipantes.Where(i => i.IdConvocatoriaCursosSedesAulas == icsa && i.IdKardex == idusuario).FirstOrDefault();


            db.Capacitacion_stParticipantes.Remove(participante);

            try
            {
                db.SaveChanges();

            }
            catch (Exception e)
            {
                throw new ApplicationException(ExceptionExtensions.GetOriginalException(e).Message);
            }


            MessageBox.Show(ViewData, TipoMensaje.Success, "Se ha realizado la baja al curso satisfactoriamente");
            //return View();


            //RedirectToAction("Inscripcion", new { id = icsa, mensaje = participante.ValidaModelo().Mensaje });
            return View("Inscripcion", getCursos());



        }

        [HttpPost]
        public ActionResult Eliminar(int id)
        {

            int icsa = id;



            Capacitacion_stParticipantes participante = db.Capacitacion_stParticipantes.Find(icsa);

            participante.FechaCancelacion = DateTime.Now.Date;

            participante.IdUsuarioCancelo = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;

            participante.EsCanceladoPorAdministrador = true;
            //db.Capacitacion_stParticipantes.e(participante);
            db.Entry(participante).State = System.Data.Entity.EntityState.Modified;


            try
            {
                db.SaveChanges();

            }
            catch (Exception e)
            {
                throw new ApplicationException(ExceptionExtensions.GetOriginalException(e).Message);
            }


            MessageBox.Show(ViewData, TipoMensaje.Success, "Se ha realizado la baja al curso satisfactoriamente");
            //return View();


            return RedirectToAction("Participantes");
            //return View("Inscripcion", getCursos());



        }


        [HttpPost]
        public ActionResult Activar(int icsa)
        {

            //int icsa = id;



            Capacitacion_stParticipantes participante = db.Capacitacion_stParticipantes.Find(icsa);

            participante.FechaCancelacion = null;

            participante.IdUsuarioCancelo = null;

            participante.EsCanceladoPorAdministrador = false;
            //db.Capacitacion_stParticipantes.e(participante);
            db.Entry(participante).State = System.Data.Entity.EntityState.Modified;


            try
            {
                db.SaveChanges();

            }
            catch (Exception e)
            {
                throw new ApplicationException(ExceptionExtensions.GetOriginalException(e).Message);
            }


            MessageBox.Show(ViewData, TipoMensaje.Success, "Se ha realizado la baja al curso satisfactoriamente");
            //return View();


            return RedirectToAction("Participantes");
            //return View("Inscripcion", getCursos());



        }
        public ActionResult Inscripcion(string mensaje = null)
        {

            //throw new System.ApplicationException("Temporalmente la inscripción a los cursos esta deshabilitada, te sugerimos estar al pendiente de la apertura la próxima semana");
            if (mensaje != null)
                MessageBox.Show(ViewData, TipoMensaje.Error, mensaje);


            return View(getCursos());
        }

        public ActionResult CancelarInscripcion(int id)
        {

            int idkardex = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Capacitacion_stParticipantes inscritoen = db.Capacitacion_stParticipantes.Find(idkardex);

            var model = db.Capacitacion_stParticipantes;


            // var item = model.FirstOrDefault(it => it.IdConvocatoriaCursosSedesAulas == IdConvocatoriaCursosSedesAulas);
            if (inscritoen != null)
                model.Remove(inscritoen);
            db.SaveChanges();

            return View("Inscripcion", getCursos());
        }

        private List<Capacitacion_stConvocatoriasCursosSedesAulas> getTodosLosCursos()
        {
            List<Capacitacion_stConvocatoriasCursosSedesAulas> model = db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(c=>c.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true).OrderByDescending(i => i.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria).OrderBy(r => new { r.Capacitacion_stConvocatoriasCursos.Capacitacion_ctCurso.Curso, r.Capacitacion_stConvocatoriasCursos.FechaInicioCurso }).ToList();

            return model;
        }

        private List<Capacitacion_stConvocatoriasCursosSedesAulas> getCursos()
        {
            int idkardex = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;

            List<Capacitacion_stConvocatoriasCursos> cursosaulas = Capacitacion_stConvocatoriasCursosSedesAulas.getConvocagoriasDisponibles(Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.IdTrabajador, Identidad.Usuario().IdEstructuraOrganica, Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.IdCategoria, Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.IdRelacionLaboral, Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.IdConvenioLaboral, Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdEstructuraOrganicaPadre); // Catalogos_ctEstructuraOrganica.IdEstructuraOrganica

            var inscritoen = db.Capacitacion_stParticipantes.Where(i => i.IdKardex == idkardex).Select(t => t.Capacitacion_stConvocatoriasCursosSedesAulas.IdConvocatoriaCursos);

            var cursos = cursosaulas.Where(r => !inscritoen.Contains(r.IdConvocatoriaCursos)).Select(b => b.IdConvocatoriaCursos);

            //var disponibles = cursosaulas.Select(b => b.IdConvocatoriaCursos);

            List<Capacitacion_stConvocatoriasCursosSedesAulas> lista = db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(r => cursos.Contains(r.IdConvocatoriaCursos)).ToList();
            return lista;
        }

        public ActionResult VerTodos()
        {

            List<Capacitacion_stConvocatoriasCursos> cursosaulas = Capacitacion_stConvocatoriasCursosSedesAulas.getConvocagoriasDisponibles(Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.IdTrabajador, Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdEstructuraOrganica, Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.IdCategoria, Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.IdRelacionLaboral, Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.IdConvenioLaboral, Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdEstructuraOrganica);
            return View(cursosaulas);
        }


        [ValidateInput(false)]
        public ActionResult Aulas()
        {
            var model = db.Capacitacion_stConvocatoriasCursosSedesAulas.OrderByDescending(e => new { e.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria, e.Capacitacion_stConvocatoriasCursos.FechaInicioCurso });
            return PartialView("_Aulas", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult AulasAddNew(Nova.Models.Capacitacion_stConvocatoriasCursosSedesAulas item)
        {
            ViewData["Item"] = item;
            var model = db.Capacitacion_stConvocatoriasCursosSedesAulas;
            item.Capacitacion_ctCoordinadores = db.Capacitacion_ctCoordinadores.Where(b => b.IdCoordinador == item.IdCoordinador).FirstOrDefault();
            item.Capacitacion_stConvocatoriasCursos = db.Capacitacion_stConvocatoriasCursos.Where(x => x.IdConvocatoriaCursos == item.IdConvocatoriaCursos).FirstOrDefault();



            if (ModelState.IsValid)
            {
                item.HorarioInicio = item.HorarioInicio.Substring(11);
                item.HorarioTermino = item.HorarioTermino.Substring(11);

                if (item.ValidaModelo().IsValid)
                {

                    try
                    {
                        model.Add(item);
                        db.SaveChanges();

                        //limpia la sedssio para el sinlgeton de cursos para cada trabajador
                        CursosActivos limpiar = CursosActivos.Clean;

                    }
                    catch (Exception e)
                    {
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }
                }
                else
                    //MessageBox.Show(ViewData, TipoMensaje.Warning, item.ValidaModelo().Mensaje);
                    ViewData["EditError"] = item.ValidaModelo().Mensaje;
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);



            return PartialView("_Aulas", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult AulasUpdate(Nova.Models.Capacitacion_stConvocatoriasCursosSedesAulas item)
        {

            var model = db.Capacitacion_stConvocatoriasCursosSedesAulas;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdConvocatoriaCursosSedesAulas == item.IdConvocatoriaCursosSedesAulas);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_Aulas", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult AulasDelete(System.Byte IdConvocatoriaCursosSedesAulas)
        {
            var model = db.Capacitacion_stConvocatoriasCursosSedesAulas;
            if (IdConvocatoriaCursosSedesAulas != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdConvocatoriaCursosSedesAulas == IdConvocatoriaCursosSedesAulas);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_Aulas", model.ToList());
        }
    }

    public static class GridViewHelper
    {
        private static GridViewSettings exportGridViewSettings;

        public static GridViewSettings ExportGridViewSettings
        {
            get
            {
                if (exportGridViewSettings == null)
                    exportGridViewSettings = CreateExportGridViewSettings();
                return exportGridViewSettings;
            }
        }

        private static GridViewSettings CreateExportGridViewSettings()
        {
            GridViewSettings settings = new GridViewSettings();

            settings.Name = "trabajadores";
            settings.CallbackRouteValues = new { Controller = "CapacitacionAulas", Action = "Listado" };

            settings.KeyFieldName = "IdParticipantes";
            settings.Settings.ShowFilterRow = true;

            settings.Columns.Add("Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.Convocatoria","Convocatoria");
            settings.Columns.Add("Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursos.Capacitacion_ctCurso.Curso","Curso");
            settings.Columns.Add("Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stAulaSede.Capacitacion_ctSede.Sede", "Sede");
            settings.Columns.Add("Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stAulaSede.Aula", "Aula");
            settings.Columns.Add("Capacitacion_stConvocatoriasCursosSedesAulas.Grupo", "Grupo");
            


            settings.Columns.Add("Kardex_ctDatosPersonales.Nombre");
            settings.Columns.Add("Kardex_ctDatosPersonales.ApellidoPaterno");
            settings.Columns.Add("Kardex_ctDatosPersonales.ApellidoMaterno");
            settings.Columns.Add("Kardex_ctDatosPersonales.Sexo");
            settings.Columns.Add("Kardex_ctDatosPersonales.CorreoElectronico");
            settings.Columns.Add("Kardex_ctDatosPersonales.CorreoElectronicoGmail");
            settings.Columns.Add("Kardex_ctDatosPersonales.Telefono");
            settings.Columns.Add("Kardex_ctDatosPersonales.TelefonoCelular");

            settings.Columns.Add("Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria");
            settings.Columns.Add("Convenios_stConvenioLaboralTrabajadorCategoria.Catalogos_ctEstructuraOrganica.EstructuraOrganica");
            settings.Columns.Add("FechaCancelacion");
            


            return settings;
        }
    }
}