﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class CapacitacionAulaSedeController : Controller
    {
        //
        // GET: /CapacitacionAulaSede/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvCapacitacionAulaSede()
        {
            var model = db.Capacitacion_stAulaSede;
            return PartialView("_pvCapacitacionAulaSede", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionAulaSedeAddNew(Nova.Models.Capacitacion_stAulaSede item)
        {
            var model = db.Capacitacion_stAulaSede;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvCapacitacionAulaSede", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionAulaSedeUpdate(Nova.Models.Capacitacion_stAulaSede item)
        {
            var model = db.Capacitacion_stAulaSede;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdAulaSede == item.IdAulaSede);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvCapacitacionAulaSede", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionAulaSedeDelete(System.Int16 IdAulaSede)
        {
            var model = db.Capacitacion_stAulaSede;
            if (IdAulaSede != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdAulaSede == IdAulaSede);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvCapacitacionAulaSede", model.ToList());
        }
    }
}
