﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Seguridad;
using System.Collections;
using Rotativa;
namespace Nova.Controllers.Capacitacion
{
    public class CapacitacionAsistenciasController : Controller
    {



        bdNovaEntities db = new bdNovaEntities();
        // GET: CapacitacionAsistencias
        public ActionResult Index()
        {  

            ViewBag.id = getidUsuarioActivo();
             
            //var model = db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(r => r.Capacitacion_ctCoordinadores.IdKardex == id).ToList();

            return View();
        }

        private int getidUsuarioActivo()
        {
            int id = 0;
            var existe = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.UsuarioKardex.FirstOrDefault();
            bool essuperusuario = false;
            if (existe != null)
                if (existe.EsSuperUsuario)
                    essuperusuario = true;

            if (essuperusuario)
            {
                id = -1;
            }
            else
            {
                int idk = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
                Capacitacion_ctCoordinadores ins = db.Capacitacion_ctCoordinadores.Where(t => t.IdKardex == idk).FirstOrDefault();


                if (ins == null)
                    throw new ApplicationException("No esta asignado como coordinador de cursos");
                else
                    if (ins.FechaVencimientoCoordinador < DateTime.Now.Date)
                    throw new ApplicationException("Ha finalizado su periodo como coordinador de cursos");
                else
                    id = ins.IdKardex;

               
            }
            return id;
        }

        public ActionResult ChecarAsistencia(int IdConvocatoriaCursosSedesAulas)
        {

            string curso = "";
            string Aula = "";
            string Instructor = "";

            DateTime FechaInicioCurso = new DateTime();
            DateTime FechaTerminoCurso = new DateTime() ;

            //double diascurso = 0;
            ViewBag.IdConvocatoriaCursosSedesAulas = IdConvocatoriaCursosSedesAulas;
            var ca = (from a in db.Capacitacion_stConvocatoriasCursosSedesAulas
                      //join b in db.Capacitacion_stConvocatoriasCursosSedes on a.IdConvocatoriaCursosSedes equals b.IdConvocatoriaCursosSedes
                      join c in db.Capacitacion_stConvocatoriasCursos on a.IdConvocatoriaCursos equals c.IdConvocatoriaCursos
                      where a.IdConvocatoriaCursosSedesAulas == IdConvocatoriaCursosSedesAulas
                      select new { Curso = c.Capacitacion_ctCurso.Curso, FechaInicioCurso = c.FechaInicioCurso, FechaFinCurso = c.FechaTerminoCurso,Instructor=a.Capacitacion_ctInstructores.Nombre + " "+a.Capacitacion_ctInstructores.ApellidoPaterno + " "+a.Capacitacion_ctInstructores.ApellidoMaterno,Aula=a.Capacitacion_stAulaSede.Aula}); 

            foreach (var item in ca)
	            {
                    curso = item.Curso;
                    FechaInicioCurso = item.FechaInicioCurso;
                    FechaTerminoCurso = item.FechaFinCurso;
                    Instructor= item.Instructor;
                    Aula=item.Aula;
                //    TimeSpan diferencia = FechaTerminoCurso.Date - FechaInicioCurso.Date; 
                //diascurso =diferencia.TotalDays;
	            }

           List<Capacitacion_stParticipantes> listaparticipantes = db.Capacitacion_stParticipantes.Where(s => s.IdConvocatoriaCursosSedesAulas == IdConvocatoriaCursosSedesAulas && s.FechaCancelacion == null).ToList();
            if (listaparticipantes.Count() == 0)
                {

                    throw new ApplicationException("No existen participantes registrados en el curso " + curso);
                }
            //long unparticipante = listaparticipantes.FirstOrDefault().IdParticipantes;
            //List<Capacitacion_stAsistencia> hayregistrosasistencia = db.Capacitacion_stAsistencia.Where(s => s.IdParticipantes == unparticipante).ToList();
            //if (hayregistrosasistencia.Count() == 0)
            //{
            //    // graba todos los día de inasistencia al curso para cada participante
            //    var model = db.Capacitacion_stAsistencia;


            //    foreach (var item in listaparticipantes)
            //    {
            //        for (var fecha = FechaInicioCurso; fecha.Date <= FechaTerminoCurso; fecha = fecha.AddDays(1))
            //        {
            //            Capacitacion_stAsistencia diaasistencia = new Capacitacion_stAsistencia();

            //            diaasistencia.Asistencia = false;
            //            diaasistencia.IdParticipantes = item.IdParticipantes;
            //            diaasistencia.FechaAsistencia = fecha;
            //            try
            //            {
            //                model.Add(diaasistencia);
            //                db.SaveChanges();
            //            }
            //            catch (Exception e)
            //            {
            //                ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
            //            }
            //        }
            //    }
            //}
            List<Capacitacion_stAsistencia> ListaAsistencia = db.Capacitacion_stAsistencia.Where(g => g.Capacitacion_stParticipantes.IdConvocatoriaCursosSedesAulas == IdConvocatoriaCursosSedesAulas).OrderBy(s => s.IdParticipantes).ThenBy(s => s.FechaAsistencia).ToList();
            ViewBag.listaasistencia = ListaAsistencia;
            ViewBag.curso = curso;
            ViewBag.fechainiciocurso = FechaInicioCurso;
            ViewBag.fechaterminocurso = FechaTerminoCurso;
            ViewBag.aula = Aula;
            ViewBag.instructor = Instructor;
            ViewBag.listaparticipantes = listaparticipantes;
           return View();
        }
        [HttpPost]
        public ActionResult ChecarAsistencia(FormCollection form)
        {
            string[] datos = Request["hfdata"].Split(',');
            string valor = "";
            if (datos.Count() > 0)
            {

                foreach (var item in datos)
                {
                    if (item != "")
                    {

                            try
                            {
                                Capacitacion_stAsistencia asis = db.Capacitacion_stAsistencia.Find(System.Convert.ToInt16(item));
                                if (asis != null)
                                {
                                     valor = System.Convert.ToString(Request["check" + item]);
                                    if (valor == "1")
                                        asis.Asistencia = true;
                                    else
                                        asis.Asistencia = false;
                                    db.Entry(asis).State = System.Data.Entity.EntityState.Modified;
                                    db.SaveChanges();
                                }
                            }
                            catch (Exception e)
                            {
                                ViewData["EditError"] = e.Message;
                            }
                    }

                }

                //   db.SaveChanges();
                //   scope.Complete();
                //   MessageBox.Show(ViewData, TipoMensaje.Success, "Tu solicitud ha sido enviada exitosamente");
                //}
            }
            return RedirectToAction("Index", "CapacitacionAsistencias");

        }

        // Imprimir lista de asistencia
        public ActionResult ImpresionLista(int id)
        {
            Session["EncabezadoLista"] = null;
            string curso = "";
            string Aula = "";
            string Horario = "";
            string Convocatoria = "";
            string Grupo = "";
            string Instructor = "";
            string Sede = "";
            DateTime FechaInicioCurso = new DateTime();
            DateTime FechaTerminoCurso = new DateTime();

            //double diascurso = 0;
            //ViewBag.IdConvocatoriaCursosSedesAulas = IdConvocatoriaCursosSedesAulas;
            var ca = (from a in db.Capacitacion_stConvocatoriasCursosSedesAulas
                      //join b in db.Capacitacion_stConvocatoriasCursosSedes on a.IdConvocatoriaCursosSedes equals b.IdConvocatoriaCursosSedes
                      join c in db.Capacitacion_stConvocatoriasCursos on a.IdConvocatoriaCursos equals c.IdConvocatoriaCursos
                      where a.IdConvocatoriaCursosSedesAulas == id
                      select new
                      {
                          Convocatoria = a.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.Convocatoria,
                          Curso = c.Capacitacion_ctCurso.Curso,
                          FechaInicioCurso = c.FechaInicioCurso,
                          FechaFinCurso = c.FechaTerminoCurso,
                          Horario = a.HorarioInicio + " - " + a.HorarioTermino,
                          Aula = a.Capacitacion_stAulaSede.Aula,
                          a.Grupo,
                          Instructor = a.Capacitacion_ctInstructores.Nombre + " " + a.Capacitacion_ctInstructores.ApellidoPaterno + " " + a.Capacitacion_ctInstructores.ApellidoMaterno,
                          Sede=a.Capacitacion_stAulaSede.Capacitacion_ctSede.Sede
                      });

            foreach (var item in ca)
            {
                Convocatoria = item.Convocatoria;
                curso = item.Curso;
                FechaInicioCurso = item.FechaInicioCurso;
                FechaTerminoCurso = item.FechaFinCurso;
                Horario = item.Horario;
                Aula = item.Aula;
                Grupo = item.Grupo;
                Instructor = item.Instructor;
                Sede = item.Sede;
                //    TimeSpan diferencia = FechaTerminoCurso.Date - FechaInicioCurso.Date; 
                //diascurso =diferencia.TotalDays;
            }

            List<Capacitacion_stParticipantes> listaparticipantes = db.Capacitacion_stParticipantes.Where(s => s.IdConvocatoriaCursosSedesAulas == id && s.FechaCancelacion == null).OrderBy(g=> g.Kardex_ctDatosPersonales.CURP).ToList();
            if (listaparticipantes.Count() == 0)
            {

                throw new ApplicationException("No existen participantes registrados en el curso " + curso);
            }
            List<Capacitacion_stAsistencia> ListaAsistencia = db.Capacitacion_stAsistencia.Where(g => g.Capacitacion_stParticipantes.IdConvocatoriaCursosSedesAulas == id).OrderBy(s => s.Capacitacion_stParticipantes.Kardex_ctDatosPersonales.CURP).ThenBy(s => s.FechaAsistencia).ToList();
            Session["listaasistencia"] = ListaAsistencia;
            Session["curso"] = curso;
            Session["fechainiciocurso"] = FechaInicioCurso;
            Session["fechaterminocurso"] = FechaTerminoCurso;
            Session["aula"] = Aula;
            Session["grupo"] = Grupo;
            Session["horario"] = Horario;
            Session["listaparticipantes"] = listaparticipantes;
            Session["convocatoria"] = Convocatoria;
            Session["instructor"] = Instructor;
            Session["sede"] = Sede;
            // 
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 10;
            m.Right = 5;
            m.Top = 0;
            
            string foot = " Fecha y hora de registro" + DateTime.Now.ToShortDateString();
            //return View();
            return new ViewAsPdf() { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = "ListaAsistencia.pdf" };
        }


        [ValidateInput(false)]
        public ActionResult CursoAulaSede(int id)
        {
            ViewBag.id = id;

            if (id != -1)
            {
                var model = db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(r => r.Capacitacion_ctCoordinadores.IdKardex == id).ToList();
                return PartialView("_CursoAulaSede", model);

            }
            else
            {
                var model = db.Capacitacion_stConvocatoriasCursosSedesAulas.ToList();

                return PartialView("_CursoAulaSede", model);

            }

        }

    }
}