﻿using Dapper;
using Nova.Libraries;
using Nova.Models;
using Nova.Models.Nombramiento;
using Rotativa;
using Rotativa.Options;
using System;
using System.Collections.Generic;
using System.Data.Entity;
using System.Globalization;
using System.Linq;
using System.Web;
using System.Web.Mvc;


namespace Nova.Controllers.Suplencia
{
    public class SolicitudSuplenciaController : BaseController
    {
        // GET: SolicitudSuplencia

        public string PrimeraMayus(string texto)
        {
            string PrimeraMayuscula = texto.Substring(0, 1) + texto.Substring(1).ToLower();

            return PrimeraMayuscula;
        }
        public ActionResult OficioPresentacionPdf(int id)
        {
            bdNovaEntities db = new bdNovaEntities();
            bdAriesEntities dba = new bdAriesEntities();
            string link = Url.Action("index", "home");

            Uri myUri = new Uri(link, UriKind.Relative);

            var trabajador = db.vwDatosAspirantesTrabajadores.Where(z => z.IdKardex == id).FirstOrDefault();

            ViewBag.IdModalidadEstudio = trabajador.IdModalidadEstudio;

            AlumnosIngresos alum = new AlumnosIngresos();
            string ciclovig = alum.NombreCicloEscolarVigente((short)trabajador.IdModalidadEstudio);


            //if (trabajador.EstatusTrabajador != "BAJA" )
            //{
            //    if (trabajador.EstatusTrabajador != "ASPIRANTE")
            //    {
            //        MessageBox.Show(ViewData, TipoMensaje.Warning, "No está habilitada esta opción para el personal con estatus: " + trabajador.EstatusTrabajador, "Aviso", myUri.ToString());
            //        return View("VError");
            //    }

            //}
            string query;
            string vista = "OficioPresentacionAdm";
            var ultimasolicitud = db.Nomina_SuplenciasSolicitudes.Where(z => z.IdKardexSuplente == id).OrderByDescending(x => x.FechaInicio).FirstOrDefault();
            if (ultimasolicitud == null)
            {
                MessageBox.Show(ViewData, TipoMensaje.Error, "No una solicitud de suplencia para el trabajador " + trabajador.Nombre + " " + trabajador.ApellidoPaterno + " " + trabajador.ApellidoMaterno, "Error", myUri.ToString());
                return View("VError");

            }
            var relaciónlaboralcategoria = db.Plazas_ctCategoria.Where(z => z.IdCategoria == ultimasolicitud.IdCategoria).FirstOrDefault();
            if (relaciónlaboralcategoria == null)
            {
                MessageBox.Show(ViewData, TipoMensaje.Error, "No existe clasificación laboral para la categoría con id " + ultimasolicitud.IdCategoria.ToString(), "Error", myUri.ToString());
                return View("VError");
            }
            var idmodalidadestudio = db.Catalogos_ctEstructuraOrganica.Where(x => x.IdEstructuraOrganica == ultimasolicitud.IdEstructuraOrganica).FirstOrDefault();

            if (ultimasolicitud.CicloEscolar == "")
                ultimasolicitud.CicloEscolar = ciclovig;

            if (relaciónlaboralcategoria.Catalogos_ctClasificacionLaboral.ClasificacionLaboral == "DOCENTE")
            {
                if (idmodalidadestudio.IdModalidadEstudio == 1)
                {
                    vista = "OficioPresentacionDocente";

                    query = @"SELECT max(k.IdSuplenciaSolicitud) as IdSuplenciaSolicitud
,max(d.Nombre) as CampoDisciplinar,0 as HorasGrupales,0 as HorasAsesoria, 0 as HorasNoGrupales,SUM(b.Horas) as HorasTotal ,c.Nombre as Asignatura

  FROM Nomina_SuplenciasSolicitudes k 
  inner join bdCtlEscSeg.dbo.stHorarioNominaDocente b on k.IdKardexSuplente=b.IdKardex 
  inner join bdCtlEscSeg.dbo.ctCicloescolar t on t.IdCicloEscolar=b.IdCicloEscolar 
  inner join bdCtlEscSeg.dbo.stHorario x on x.IdHorario=b.IdHorario
  INNER JOIN bdCtlEscSeg.dbo.stPlanEstudioAsignatura z on  z.IdPlanEstudioAsignatura=x.IdPlanEstudioAsignatura
  INNER JOIN bdCtlEscSeg.dbo.ctAsignatura c on  z.IdAsignatura=c.IdAsignatura
  INNER JOIN bdCtlEscSeg.dbo.ctAreaConocimiento d on  d.IdAreaConocimiento=c.IdAreaConocimiento
  where  k.IdKardexSuplente=" + id + " and t.Nombre= '" + ultimasolicitud.CicloEscolar + "' and (b.marcareliminado = 0 or b.marcareliminado is null) and b.IdTipoHoras in (21,22)" +
            " group by c.Nombre,b.IdTipoHoras  ";

                }
                else
                {
                    query = @"SELECT max(k.IdSuplenciaSolicitud) as IdSuplenciaSolicitud
,max(d.Nombre) as CampoDisciplinar,case when b.IdTipoHoras = 22 then sum(b.Horas) end as HorasGrupales,case when b.IdTipoHoras = 5 then sum(b.Horas) end as HorasAsesoria, case when b.IdTipoHoras = 5 or b.IdTipoHoras = 8 or b.IdTipoHoras = 15 or b.IdTipoHoras = 20 then sum(b.Horas) end as HorasNoGrupales,SUM(b.Horas) as HorasTotal ,c.Nombre as Asignatura
  FROM Nomina_SuplenciasSolicitudes k 
  inner join bdCtlEscSeg.dbo.stHorarioNominaDocente b on k.IdKardexSuplente=b.IdKardex 
  inner join bdCtlEscSeg.dbo.ctCicloescolar t on t.IdCicloEscolar=b.IdCicloEscolar 
  inner join bdCtlEscSeg.dbo.stHorario x on x.IdHorario=b.IdHorario
  INNER JOIN bdCtlEscSeg.dbo.stPlanEstudioAsignatura z on  z.IdPlanEstudioAsignatura=x.IdPlanEstudioAsignatura
  INNER JOIN bdCtlEscSeg.dbo.ctAsignatura c on  z.IdAsignatura=c.IdAsignatura
  INNER JOIN bdCtlEscSeg.dbo.ctAreaConocimiento d on  d.IdAreaConocimiento=c.IdAreaConocimiento
  where  k.IdKardexSuplente=" + id + " and t.Nombre= '" + ultimasolicitud.CicloEscolar + "' and (b.marcareliminado = 0 or b.marcareliminado is null) and b.IdTipoHoras in (21,22)" +
         " group by c.Nombre,b.IdTipoHoras  ";
                    if (ultimasolicitud.Nomina_SuplenciaTipo.TipoSuplencia == "POR BAJAS" && ultimasolicitud.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("CONTRATO"))
                    {
                        vista = "OPInterinoPlazaDefinitiva";

                    }
                    if ((ultimasolicitud.Nomina_SuplenciaTipo.TipoSuplencia == "POR LICENCIAS Y/O PERMISOS"
                        || ultimasolicitud.Nomina_SuplenciaTipo.TipoSuplencia == "POR NECESIDADES DEL CENTRO")
                        && ultimasolicitud.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("CONTRATO"))
                    {
                        vista = "OPInterinoPlazaProvisional";

                    }

                }


            }
            else
            {
                
                query = @"SELECT IdSuplenciaSolicitud,'' as CampoDisciplinar,0 as Horas,'' as Asignatura
                          FROM Nomina_SuplenciasSolicitudes
                          where  IdKardexSuplente=" + id + 
                          " order by  FechaInicio desc";


            }

            ViewBag.UbicacionCentroViene = trabajador.UbicacionFisica;
            ViewBag.ConvenioLaboral = trabajador.ConvenioLaboral;
            ViewBag.Estatus = trabajador.EstatusTrabajador;
            ViewBag.Año = DateTime.Now.Year;
            ViewBag.Atencion = "";
            ViewBag.CcpDirA = "NO";
            ViewBag.Referencia = "";
            ViewBag.NombreAtencion = "";
            ViewBag.AbreAtencion = "C. ";
            ViewBag.IdModalidad = trabajador.IdModalidadEstudio;
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 2;
            m.Left = 5;
            m.Right = 1;
            m.Top = 0;
            ViewBag.layout = "~/Views/Shared/_Rotativa2018.cshtml";
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            var t = dp.connection.Query<OficioPresentacion>(query).ToList();
            if (t.Count == 0)
            {
                MessageBox.Show(ViewData, TipoMensaje.Warning, "No existen solicitud de suplencia u horario para el trabajador", "Aviso", myUri.ToString());
                return View("VError");

            }
            var escolaridad = db.Kardex_GradoAcademico.Where(z => z.IdKardex == trabajador.IdKardex).OrderByDescending(x => x.Kardex_NivelEstudio.Orden).FirstOrDefault();
            if (escolaridad == null)
            {
                MessageBox.Show(ViewData, TipoMensaje.Warning, "No se encontro nivel de estudio para el trabajador, capturelo en la opción Grado Académico", "Aviso", myUri.ToString());
                return View("VError");


            }
            ViewBag.GradoAcademico = escolaridad.NivelEstudioDescripcion;

            var ur = t.FirstOrDefault();
            var solicitud = db.Nomina_SuplenciasSolicitudes.Where(x => x.IdSuplenciaSolicitud == ur.IdSuplenciaSolicitud).FirstOrDefault();

            dp.Close();
            vwDatosAspirantesTrabajadores dc = new vwDatosAspirantesTrabajadores();
            //if (ultimasolicitud.OficioReferencia == null)
            //{
            //    MessageBox.Show(ViewData, TipoMensaje.Error, "No existe oficio de referencia para la solicitud del trabajador " + trabajador.Nombre + " " + trabajador.ApellidoPaterno + " " + trabajador.ApellidoMaterno, "Error", myUri.ToString());
            //    return View("VError");

            //}
            ViewBag.Referencia = ultimasolicitud.OficioReferencia;
            if (ultimasolicitud.IdEstructuraOrganicaFisica == null)
            {
                if ((trabajador.IdModalidadEstudio == 1))
                {
                    dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == ultimasolicitud.IdEstructuraOrganica && (z.Categoria == "DIRECTOR DE PLANTEL \"A\"" || z.Categoria == "DIRECTOR DE PLANTEL \"B\"")).FirstOrDefault();
                    if (dc != null)
                    {
                        ViewBag.Cargo = "DIRECTOR";
                        ViewBag.CcpDirA = "SI";
                    }
                }
                else
                {
                    if (trabajador.IdModalidadEstudio == 2)
                    {
                        ViewBag.CcpDirA = "SI";
                        dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == ultimasolicitud.IdEstructuraOrganica && (z.Categoria == "RESPONSABLE DEL CENTRO \"A\"" || z.Categoria == "RESPONSABLE DEL CENTRO \"B\"" || z.Categoria == "RESPONSABLE DEL CENTRO \"C\"")).FirstOrDefault();
                        if (dc == null)
                        {
                            dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == ultimasolicitud.IdEstructuraOrganica && (z.Categoria == "AUXILIAR DEL RESPONSABLE DEL CENTRO \"A\"" || z.Categoria == "AUXILIAR DEL RESPONSABLE DEL CENTRO \"B\"" || z.Categoria == "AUXILIAR DEL RESPONSABLE DEL CENTRO \"C\"")).FirstOrDefault();
                            if (dc != null)
                            {
                                ViewBag.Cargo = "ENCARGADO";
                            }

                        }
                        else
                            ViewBag.Cargo = "RESPONSABLE";

                    }
                    else
                    {
                        switch (trabajador.IdEstructuraOrganicaFisica)
                        {
                            case 4:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "DIRECTOR DE ÁREA")).FirstOrDefault();
                                ViewBag.Cargo = "DIRECTOR ADMINISTRATIVO";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "DIRECTORA ADMINISTRATIVA";

                                }
                                break;
                            case 5:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "DIRECTOR DE ÁREA")).FirstOrDefault();
                                ViewBag.Cargo = "DIRECTOR DE PLANEACIÓN";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "DIRECTORA PLANEACIÓN";

                                }

                                break;
                            case 6:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "DIRECTOR DE ÁREA")).FirstOrDefault();
                                ViewBag.Cargo = "DIRECTOR DE EDUCACIÓN A DISTANCIA";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "DIRECTORA DE EDUCACIÓN A DISTANCIA";
                                }
                                ViewBag.CcpDirA = "NO";
                                break;
                            case 7:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "DIRECTOR DE ÁREA")).FirstOrDefault();
                                ViewBag.Cargo = "DIRECTOR DE VINCULACIÓN CON EL SECTOR PRODUCTIVO";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "DIRECTORA DE VINCULACIÓN CON EL SECTOR PRODUCTIVO";
                                }

                                break;
                            case 8:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "DIRECTOR DE ÁREA")).FirstOrDefault();
                                ViewBag.Cargo = "DIRECTOR ACADÉMICO";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "DIRECTORA ACADÉMICA";
                                }
                                ViewBag.CcpDirA = "NO";
                                break;
                            case 9:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE RECURSOS HUMANOS";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE RECURSOS HUMANOS";
                                }
                                break;
                            case 10:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE RECURSOS FINANCIEROS";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE RECURSOS FINANCIEROS";
                                }
                                break;

                            case 11:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE RECURSOS MATERIALES Y SERVICIOS";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE RECURSOS MATERIALES Y SERVICIOS";
                                }
                                break;
                            case 12:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DE LA SUBDIRECCIÓN DE PROGRAMACIÓN Y PRESUPUESTO";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DE LA SUBDIRECCIÓN DE PROGRAMACIÓN Y PRESUPUESTO";
                                }
                                break;
                            case 13:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE PLANEACIÓN DE INFRAESTRUCTURA EDUCATIVA";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE PLANEACIÓN DE INFRAESTRUCTURA EDUCATIVA";
                                }
                                break;
                            case 15:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE SISTEMAS";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE SISTEMAS";
                                }
                                break;
                            case 17:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE OPERACIÓN Y COORDINACIÓN";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE OPERACIÓN Y COORDINACIÓN";
                                }
                                break;
                            case 18:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE LA SUPERVISIÓN DE LA GESTIÓN EDUCATIVA";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE LA SUPERVISIÓN DE LA GESTIÓN EDUCATIVA";
                                }
                                break;
                            case 19:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE PROGRAMAS Y MATERIAL DIDÁCTICO";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE PROGRAMAS Y MATERIAL DIDÁCTICO";
                                }
                                break;
                            case 21:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE ORIENTACIÓN,CAPACITACIÓN Y EXT";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE ORIENTACIÓN,CAPACITACIÓN Y EXT";
                                }
                                break;
                            case 22:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE ESTADÍSTICA Y CONTROL ESCOLAR";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE ESTADÍSTICA Y CONTROL ESCOLAR";
                                }

                                break;
                            case 23:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE PLANES Y PROGRAMAS";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE PLANES Y PROGRAMAS";
                                }

                                break;
                            case 24:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE SERVICIOS DOCENTES";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE SERVICIOS DOCENTES";
                                }
                                break;
                            case 144:
                                vista = "OficioSindicatoAdm";
                                var secregral = db.ComiteSindicato.Where(z => z.IdEstructuraOrganica == 144 && z.CargoSindicato.CargoSindicato1 == "SECRETARIO GENERAL DEL STSCECyTEO").FirstOrDefault();
                                ViewBag.Cargo = secregral.CargoSindicato.CargoSindicato1;
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == 144 && (z.IdTrabajador == secregral.Idtrabajador)).FirstOrDefault();

                                var secrerec = db.ComiteSindicato.Where(z => z.IdEstructuraOrganica == 144 && z.CargoSindicato.CargoSindicato1 == "SECRETARIO DE RECURSOS DEL STSCECyTEO").FirstOrDefault();
                                var secrerecursos = db.vwDatosAspirantesTrabajadores.Where(x => x.IdEstructuraOrganicaFisica == 144 && x.IdTrabajador == secrerec.Idtrabajador).FirstOrDefault();
                                ViewBag.NombreAtencion = secrerecursos.Nombre + " " + secrerecursos.ApellidoPaterno + " " + secrerecursos.ApellidoMaterno;
                                ViewBag.Atencion = secrerec.CargoSindicato.CargoSindicato1;
                                ViewBag.CcpDirA = "SI";
                                var AbreviaturaAtencion = db.Kardex_GradoAcademico.Where(z => z.IdKardex == secrerecursos.IdKardex).FirstOrDefault();
                                ViewBag.AbreAtencion = "C. ";

                                if (AbreviaturaAtencion != null)
                                {
                                    if (AbreviaturaAtencion.AbreviaturaProfesion != null)
                                    {
                                        ViewBag.AbreAtencion = AbreviaturaAtencion.AbreviaturaProfesion;
                                    }
                                }

                                break;
                            default:

                                ViewBag.Cargo = "";
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                break;

                        }

                    }
                }

            }
            else
            {
                if (trabajador.IdModalidadEstudio == 1)
                {
                    dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == solicitud.IdEstructuraOrganicaFisica && (z.Categoria == "DIRECTOR DE PLANTEL \"A\"" || z.Categoria == "DIRECTOR DE PLANTEL \"B\"")).FirstOrDefault();
                    if (dc != null)
                    {
                        ViewBag.Cargo = "DIRECTOR";
                        ViewBag.CcpDirA = "SI";
                    }
                }
                else
                {
                    if (trabajador.IdModalidadEstudio == 2)
                    {
                        ViewBag.CcpDirA = "SI";
                        dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == solicitud.IdEstructuraOrganicaFisica && (z.Categoria == "RESPONSABLE DEL CENTRO \"A\"" || z.Categoria == "RESPONSABLE DEL CENTRO \"B\"" || z.Categoria == "RESPONSABLE DEL CENTRO \"C\"")).FirstOrDefault();
                        if (dc == null)
                        {
                            dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == solicitud.IdEstructuraOrganicaFisica && (z.Categoria == "AUXILIAR DEL RESPONSABLE DEL CENTRO \"A\"" || z.Categoria == "AUXILIAR DEL RESPONSABLE DEL CENTRO \"B\"" || z.Categoria == "AUXILIAR DEL RESPONSABLE DEL CENTRO \"C\"")).FirstOrDefault();
                            if (dc != null)
                            {
                                ViewBag.Cargo = "ENCARGADO";
                            }

                        }
                        else
                            ViewBag.Cargo = "RESPONSABLE";

                    }
                    else
                    {

                        switch (trabajador.IdEstructuraOrganicaFisica)
                        {
                            case 4:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "DIRECTOR DE ÁREA")).FirstOrDefault();
                                ViewBag.Cargo = "DIRECTOR ADMINISTRATIVO";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "DIRECTORA ADMINISTRATIVA";

                                }
                                break;
                            case 5:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "DIRECTOR DE ÁREA")).FirstOrDefault();
                                ViewBag.Cargo = "DIRECTOR DE PLANEACIÓN";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "DIRECTORA PLANEACIÓN";

                                }

                                break;
                            case 6:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "DIRECTOR DE ÁREA")).FirstOrDefault();
                                ViewBag.Cargo = "DIRECTOR DE EDUCACIÓN A DISTANCIA";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "DIRECTORA DE EDUCACIÓN A DISTANCIA";
                                }
                                ViewBag.CcpDirA = "NO";
                                break;
                            case 7:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "DIRECTOR DE ÁREA")).FirstOrDefault();
                                ViewBag.Cargo = "DIRECTOR DE VINCULACIÓN CON EL SECTOR PRODUCTIVO";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "DIRECTORA DE VINCULACIÓN CON EL SECTOR PRODUCTIVO";
                                }

                                break;
                            case 8:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "DIRECTOR DE ÁREA")).FirstOrDefault();
                                ViewBag.Cargo = "DIRECTOR ACADÉMICO";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "DIRECTORA ACADÉMICA";
                                }
                                ViewBag.CcpDirA = "NO";
                                break;
                            case 9:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE RECURSOS HUMANOS";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE RECURSOS HUMANOS";
                                }
                                break;
                            case 10:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE RECURSOS FINANCIEROS";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE RECURSOS FINANCIEROS";
                                }
                                break;

                            case 11:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE RECURSOS MATERIALES Y SERVICIOS";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE RECURSOS MATERIALES Y SERVICIOS";
                                }
                                break;
                            case 12:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DE LA SUBDIRECCIÓN DE PROGRAMACIÓN Y PRESUPUESTO";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DE LA SUBDIRECCIÓN DE PROGRAMACIÓN Y PRESUPUESTO";
                                }
                                break;
                            case 13:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE PLANEACIÓN DE INFRAESTRUCTURA EDUCATIVA";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE PLANEACIÓN DE INFRAESTRUCTURA EDUCATIVA";
                                }
                                break;
                            case 15:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE SISTEMAS";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE SISTEMAS";
                                }
                                break;
                            case 17:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE OPERACIÓN Y COORDINACIÓN";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE OPERACIÓN Y COORDINACIÓN";
                                }
                                break;
                            case 18:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE LA SUPERVISIÓN DE LA GESTIÓN EDUCATIVA";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE LA SUPERVISIÓN DE LA GESTIÓN EDUCATIVA";
                                }
                                break;
                            case 19:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE PROGRAMAS Y MATERIAL DIDÁCTICO";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE PROGRAMAS Y MATERIAL DIDÁCTICO";
                                }
                                break;
                            case 21:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE ORIENTACIÓN,CAPACITACIÓN Y EXT";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE ORIENTACIÓN,CAPACITACIÓN Y EXT";
                                }
                                break;
                            case 22:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE ESTADÍSTICA Y CONTROL ESCOLAR";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE ESTADÍSTICA Y CONTROL ESCOLAR";
                                }

                                break;
                            case 23:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE PLANES Y PROGRAMAS";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE PLANES Y PROGRAMAS";
                                }

                                break;
                            case 24:
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                ViewBag.Cargo = "JEFE DEL DEPARTAMENTO DE SERVICIOS DOCENTES";
                                if (dc.Sexo.Trim() == "M")
                                {
                                    ViewBag.Cargo = "JEFA DEL DEPARTAMENTO DE SERVICIOS DOCENTES";
                                }
                                break;
                            case 144:
                                vista = "OficioSindicatoAdm";
                                var secregral = db.ComiteSindicato.Where(z => z.IdEstructuraOrganica == 144 && z.CargoSindicato.CargoSindicato1 == "SECRETARIO GENERAL DEL STSCECyTEO").FirstOrDefault();
                                ViewBag.Cargo = secregral.CargoSindicato.CargoSindicato1;
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == 144 && (z.IdTrabajador == secregral.Idtrabajador)).FirstOrDefault();

                                var secrerec = db.ComiteSindicato.Where(z => z.IdEstructuraOrganica == 144 && z.CargoSindicato.CargoSindicato1 == "SECRETARIO DE RECURSOS DEL STSCECyTEO").FirstOrDefault();
                                var secrerecursos = db.vwDatosAspirantesTrabajadores.Where(x => x.IdEstructuraOrganicaFisica == 144 && x.IdTrabajador == secrerec.Idtrabajador).FirstOrDefault();
                                ViewBag.NombreAtencion = secrerecursos.Nombre + " " + secrerecursos.ApellidoPaterno + " " + secrerecursos.ApellidoMaterno;
                                ViewBag.Atencion = secrerec.CargoSindicato.CargoSindicato1;
                                ViewBag.CcpDirA = "SI";
                                var AbreviaturaAtencion = db.Kardex_GradoAcademico.Where(z => z.IdKardex == secrerecursos.IdKardex).FirstOrDefault();
                                ViewBag.AbreAtencion = "C. ";

                                if (AbreviaturaAtencion != null)
                                {
                                    if (AbreviaturaAtencion.AbreviaturaProfesion != null)
                                    {
                                        ViewBag.AbreAtencion = AbreviaturaAtencion.AbreviaturaProfesion;
                                    }
                                }

                                break;

                            default:
                                ViewBag.Cargo = "";
                                dc = db.vwDatosAspirantesTrabajadores.Where(z => z.IdEstructuraOrganicaFisica == trabajador.IdEstructuraOrganicaFisica && (z.Categoria == "JEFE DE DEPARTAMENTO")).FirstOrDefault();
                                break;

                        }

                    }
                }

            }
            if (dc == null)
            {
                MessageBox.Show(ViewData, TipoMensaje.Warning, "No existe Director, Responsable o encargado para el centro  " + trabajador.UbicacionFisica, "Aviso", myUri.ToString());
                return View("VError");

            }
            ViewBag.Oficio = solicitud.FolioOficio;
            ViewBag.Obs = solicitud.ObservacionFinal;

            FormatoFechaMesTexto ff = new FormatoFechaMesTexto();
            ViewBag.FechaOficio = ff.FormatoFechaTextoMes(solicitud.FechaInicio);
            ViewBag.FechaInicio = ff.FormatoFechaTextoMes(solicitud.FechaInicio);
            ViewBag.FechaVigencia = null;
            if (solicitud.FechaTermino.HasValue)
            {
                ViewBag.FechaVigencia = ff.FormatoFechaTextoMes(solicitud.FechaTermino.Value);

            }
            ViewBag.NombreDirectorCentro = dc.Nombre + " " + dc.ApellidoPaterno + " " + dc.ApellidoMaterno;
            var AbreviaturaDirCentro = db.Kardex_GradoAcademico.Where(z => z.IdKardex == dc.IdKardex).FirstOrDefault();
            ViewBag.AbreDirCentro = "C. ";

            if (AbreviaturaDirCentro != null)
            {
                if (AbreviaturaDirCentro.AbreviaturaProfesion != null)
                {
                    ViewBag.AbreDirCentro = AbreviaturaDirCentro.AbreviaturaProfesion;
                }
            }
            ViewBag.NombreCentro = dc.UbicacionFisica;
            ViewBag.Convenio = trabajador.ConvenioLaboral;
            if (trabajador.ConvenioLaboral == "CONTRATO")
            {
                ViewBag.Convenio = "interino";
            }

            ViewBag.Trabajador = trabajador.Nombre.ToLower() + " " + trabajador.ApellidoPaterno.ToLower() + " " + trabajador.ApellidoMaterno.ToLower();
            ViewBag.Trabajador = CultureInfo.InvariantCulture.TextInfo.ToTitleCase(ViewBag.Trabajador);
            ViewBag.SexoTrabajador = trabajador.Sexo.Trim();
            ViewBag.OrigenPlaza = ultimasolicitud.Catalogos_ctEstructuraOrganica.EstructuraOrganica;
            ViewBag.CampoDisciplinar = ur.CampoDisciplinar;
            ViewBag.Horas = t.Sum(z => z.HorasTotal).ToString();
            var DirectorAcademico = db.vwDatosAspirantesTrabajadores.Where(F => F.IdEstructuraOrganica == trabajador.IdEstructuraOrganica && F.Categoria == "DIRECTOR DE ÁREA" && F.EstatusTrabajador == "ALTA").FirstOrDefault();

            if (ultimasolicitud.Catalogos_ctEstructuraOrganica.IdEstructuraOrganicaPadre == 4 || ultimasolicitud.Catalogos_ctEstructuraOrganica.IdEstructuraOrganicaPadre == 5 || ultimasolicitud.Catalogos_ctEstructuraOrganica.IdEstructuraOrganicaPadre == 7 || ultimasolicitud.Catalogos_ctEstructuraOrganica.IdEstructuraOrganicaPadre == 8)
            {
                DirectorAcademico = db.vwDatosAspirantesTrabajadores.Where(F => F.IdEstructuraOrganica == trabajador.IdEstructuraOrganicaPadre && F.Categoria == "DIRECTOR DE ÁREA" && F.EstatusTrabajador == "ALTA").FirstOrDefault();

            }
            else
            {
                var estructurapadre = db.Catalogos_ctEstructuraOrganica.Where(z => z.IdEstructuraOrganica == trabajador.IdEstructuraOrganicaFisica).FirstOrDefault();
                DirectorAcademico = db.vwDatosAspirantesTrabajadores.Where(F => F.IdEstructuraOrganica == estructurapadre.IdEstructuraOrganicaPadre && F.Categoria == "DIRECTOR DE ÁREA" && F.EstatusTrabajador == "ALTA").FirstOrDefault();

            }


            //if (trabajador.IdModalidadEstudio == 2)
            //{
            //     DirectorAcademico = db.vwDatosAspirantesTrabajadores.Where(F => F.UbicacionFisica == "DIRECCIÓN DE EDUCACIÓN A DISTANCIA" && F.Categoria == "DIRECTOR DE ÁREA" && F.EstatusTrabajador == "ALTA").FirstOrDefault();

            //}
            var DirectorGral = db.vwDatosAspirantesTrabajadores.Where(F => F.Categoria == "DIRECTOR GENERAL" && F.EstatusTrabajador == "ALTA").FirstOrDefault();
            ViewBag.DirectorGral = DirectorGral.Nombre + " " + DirectorGral.ApellidoPaterno + " " + DirectorGral.ApellidoMaterno;
            ViewBag.SexoDirGral = DirectorGral.Sexo.Trim();

            var AbreDirGral = db.Kardex_GradoAcademico.Where(z => z.IdKardex == DirectorGral.IdKardex).FirstOrDefault();
            ViewBag.AbreDirectorGral = "LIC. ";
            if (AbreDirGral != null)
            {
                if (AbreDirGral.AbreviaturaProfesion != null)
                {
                    ViewBag.AbreDirectorGral = AbreDirGral.AbreviaturaProfesion;
                }
            }

            ViewBag.SexoDirAcademico = DirectorAcademico.Sexo.Trim();
            ViewBag.TelDirAca = db.Catalogos_ctEstructuraOrganica.Where(z => z.IdEstructuraOrganica == DirectorAcademico.IdEstructuraOrganicaFisica).FirstOrDefault().Telefono;
            ViewBag.DireccionDirAcade = db.Catalogos_ctEstructuraOrganica.Where(z => z.IdEstructuraOrganica == DirectorAcademico.IdEstructuraOrganicaFisica).FirstOrDefault().Direccion;
            ViewBag.CorreoDirAcade = db.Catalogos_ctEstructuraOrganica.Where(z => z.IdEstructuraOrganica == DirectorAcademico.IdEstructuraOrganicaFisica).FirstOrDefault().CorreoElectronico;
            ViewBag.DirectorAcademico = DirectorAcademico.Nombre + " " + DirectorAcademico.ApellidoPaterno + " " + DirectorAcademico.ApellidoMaterno;
            ViewBag.CargoDirAca = DirectorAcademico.UbicacionFisica;
            if (DirectorAcademico.UbicacionFisica.Contains("ACADÉMI"))
            {
                ViewBag.CargoDirAca = "Académica";
            }
            if (DirectorAcademico.UbicacionFisica.Contains("DISTANCIA"))
            {
                ViewBag.CargoDirAca = "de Educación a Distancia";
            }

            ViewBag.SexoDirAca = DirectorAcademico.Sexo.Trim();

            var AbreDirAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == DirectorAcademico.IdKardex).FirstOrDefault();
            ViewBag.AbreDirAcademico = "LIC. ";
            ViewBag.Origen = DirectorAcademico.UbicacionFisica;
            if (AbreDirAcademico != null)
            {
                if (AbreDirAcademico.AbreviaturaProfesion != null)
                {
                    ViewBag.AbreDirAcademico = AbreDirAcademico.AbreviaturaProfesion;
                }
            }

            // Dir de Planeación

            var DirectorPlaneacion = db.vwDatosAspirantesTrabajadores.Where(F => F.UbicacionFisica == "DIRECCIÓN DE PLANEACIÓN" && F.Categoria == "DIRECTOR DE ÁREA" && F.EstatusTrabajador == "ALTA").FirstOrDefault();
            var AbreDirPlaneacion = db.Kardex_GradoAcademico.Where(z => z.IdKardex == DirectorPlaneacion.IdKardex).FirstOrDefault();
            ViewBag.AbreDirPlaneacion = "LIC. ";
            if (AbreDirPlaneacion != null)
            {
                if (AbreDirPlaneacion.AbreviaturaProfesion != null)
                {
                    ViewBag.AbreDirPlaneacion = AbreDirPlaneacion.AbreviaturaProfesion;
                }
            }

            var JefeDesAca = db.vwDatosAspirantesTrabajadores.Where(F => F.UbicacionFisica == "DEPARTAMENTO DE DESARROLLO ACADÉMICO" && F.Categoria == "JEFE DE DEPARTAMENTO" && F.EstatusTrabajador == "ALTA").FirstOrDefault();
            var AbreJefeDesAca = db.Kardex_GradoAcademico.Where(z => z.IdKardex == JefeDesAca.IdKardex).FirstOrDefault();
            ViewBag.AbreJefeDesAca = "LIC. ";
            if (AbreJefeDesAca != null)
            {
                if (AbreJefeDesAca.AbreviaturaProfesion != null)
                {
                    ViewBag.AbreJefeDesAca = AbreJefeDesAca.AbreviaturaProfesion;
                }
            }

            ViewBag.SexoJefeDesAca = JefeDesAca.Sexo.Trim();
            ViewBag.JefeDesAca = JefeDesAca.Nombre + " " + JefeDesAca.ApellidoPaterno + " " + JefeDesAca.ApellidoMaterno;


            var DirectorAdministrativo = db.vwDatosAspirantesTrabajadores.Where(F => F.UbicacionFisica == "DIRECCIÓN ADMINISTRATIVA" && F.Categoria == "DIRECTOR DE ÁREA" && F.EstatusTrabajador == "ALTA").FirstOrDefault();
            var AbreDirAdministrativo = db.Kardex_GradoAcademico.Where(z => z.IdKardex == DirectorAdministrativo.IdKardex).FirstOrDefault();
            ViewBag.AbreDirAdministrativo = "LIC. ";
            if (AbreDirAdministrativo != null)
            {
                if (AbreDirAdministrativo.AbreviaturaProfesion != null)
                {
                    ViewBag.AbreDirAdministrativo = AbreDirAdministrativo.AbreviaturaProfesion;
                }
            }

            ViewBag.SexoDirAdministrativo = DirectorAdministrativo.Sexo.Trim();
            ViewBag.DirectorAdministrativo = DirectorAdministrativo.Nombre + " " + DirectorAdministrativo.ApellidoPaterno + " " + DirectorAdministrativo.ApellidoMaterno;
            var JefeHumanos = db.vwDatosAspirantesTrabajadores.Where(F => F.UbicacionFisica == "DEPARTAMENTO DE RECURSOS HUMANOS" && F.Categoria == "JEFE DE DEPARTAMENTO" && F.EstatusTrabajador == "ALTA").FirstOrDefault();
            var AbreJefeHumanos = db.Kardex_GradoAcademico.Where(z => z.IdKardex == JefeHumanos.IdKardex).FirstOrDefault();
            ViewBag.AbreJefeHumanos = "LIC. ";
            if (AbreJefeHumanos != null)
            {
                if (AbreJefeHumanos.AbreviaturaProfesion != null)
                {
                    ViewBag.AbreJefeHumanos = AbreJefeHumanos.AbreviaturaProfesion;
                }
            }

            ViewBag.SexoJefeHumanos = JefeHumanos.Sexo.Trim();
            ViewBag.JefeHumanos = JefeHumanos.Nombre + " " + JefeHumanos.ApellidoPaterno + " " + JefeHumanos.ApellidoMaterno;
            var JefeServiciosDocentes = db.vwDatosAspirantesTrabajadores.Where(F => F.UbicacionFisica == "DEPARTAMENTO DE SERVICIOS DOCENTES" && F.Categoria == "JEFE DE DEPARTAMENTO" && F.EstatusTrabajador == "ALTA").FirstOrDefault();
            if (JefeServiciosDocentes == null)
            {
                MessageBox.Show(ViewData, TipoMensaje.Warning, "No existen datos para el Jefe del Departamento de Servicios Docentes, Verifíquelo con el administrador del sistema " + trabajador.UbicacionFisica, "Aviso", myUri.ToString());
                return View("VError");

            }
            ViewBag.SexoJefeDocentes = JefeServiciosDocentes.Sexo.Trim();
            ViewBag.JefeDocentes = JefeServiciosDocentes.Nombre + " " + JefeServiciosDocentes.ApellidoPaterno + " " + JefeServiciosDocentes.ApellidoMaterno;
            var AbreJefeServiciosDocentes = db.Kardex_GradoAcademico.Where(z => z.IdKardex == JefeServiciosDocentes.IdKardex).FirstOrDefault();
            ViewBag.AbreJefeServiciosDocentes = "LIC. ";
            ViewBag.CategoriaSolicitud = db.Plazas_ctCategoria.Where(z => z.IdCategoria == solicitud.IdCategoria).FirstOrDefault().Categoria;

            //ViewBag.IdtipoSuplencia = solicitud.IdTipoSuplencia;
            switch (solicitud.Nomina_SuplenciaTipo.TipoSuplencia)
            {
                case "POR NECESIDADES DEL CENTRO":
                    if (solicitud.ObservacionFinal == "" || solicitud.ObservacionFinal == null)
                    {
                        ViewBag.IdtipoSuplencia = "derivado de las necesidades del centro educativo. ";
                    }
                    else
                    {
                        ViewBag.IdtipoSuplencia = solicitud.ObservacionFinal;

                    }
                    break;
                case "POR BAJAS":
                    ViewBag.IdtipoSuplencia = solicitud.IncidenciaPermiso_stIncidenciaTrabajador.Catalogos_ctTipoIncidencia.Incidencia;
                    break;
                case "POR LICENCIAS Y/O PERMISOS":
                    ViewBag.IdtipoSuplencia = solicitud.IncidenciaPermiso_stIncidenciaTrabajador.Catalogos_ctTipoIncidencia.Incidencia;
                    break;

                default:
                    ViewBag.IdtipoSuplencia = solicitud.Nomina_SuplenciaTipo.TipoSuplencia;

                    break;
            }
            ViewBag.Suplido = "";
            var suplido = db.vwDatosAspirantesTrabajadores.Where(x => x.IdKardex == solicitud.IdKardexSuplido).FirstOrDefault();
            if (suplido != null)
            {
                ViewBag.Suplido = PrimeraMayus(suplido.Nombre) + " " + PrimeraMayus(suplido.ApellidoPaterno) + " " + PrimeraMayus(suplido.ApellidoMaterno);

            }
            if (AbreJefeServiciosDocentes != null)
            {
                if (AbreJefeServiciosDocentes.AbreviaturaProfesion != null)
                {
                    ViewBag.AbreJefeServiciosDocentes = AbreJefeServiciosDocentes.AbreviaturaProfesion;
                }
            }
            if (ViewBag.IdtipoSuplencia == "COMISIÓN PARA OCUPAR PLAZA VACANTE" || ViewBag.IdtipoSuplencia == "COMISIÓN POR CAMBIO DE NÓMINA")
            {
                ViewBag.Suplido = "";
            }
            SendPushNotification("Imprimió" + "Oficio de Presentación" + " : " + trabajador.Nombre + " " + trabajador.ApellidoPaterno + " " + trabajador.ApellidoMaterno + " con categoría " + trabajador.Categoria);
            return new ViewAsPdf(vista, t)
            {
                CustomSwitches = null,
                PageSize = Rotativa.Options.Size.Letter,
                PageOrientation = Orientation.Portrait,
                PageMargins = m,

                FileName = "OficioPresentacion-" + trabajador.IdTrabajador + "-" + trabajador.Nombre + "-" + trabajador.ApellidoPaterno + "-" + trabajador.ApellidoMaterno + ".pdf"
            };
            //return View(t);
        }
    }
}