﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.Transactions;
using System.Data.Entity;

namespace Nova.Controllers
{
    public class AsignarPlazaDocenteController : BaseController
    {
        // GET: AsignarPlazaDocente
        private bdNovaEntities db = new bdNovaEntities();
        public ActionResult Index()
        {
            //ViewBag.Tree = ObtenArbolEstructuraOrganica();
            string[] EstatusTrabajadores = { "ASPIRANTE", "BAJA" };
            var model = db.vwDatosAspirantesTrabajadores.Where(t => EstatusTrabajadores.Contains(t.EstatusTrabajador)).ToList();
            return View(model);
        }

        // GET: AsignarPlazaDocente/Details/5
        public ActionResult Details(int id)
        {
            return View();
        }

        // GET: AsignarPlazaDocente/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: AsignarPlazaDocente/Create
        [HttpPost]
        public ActionResult Create(FormCollection collection)
        {
            try
            {
                // TODO: Add insert logic here

                return RedirectToAction("Index");
            }
            catch
            {
                return View();
            }
        }

        // GET: AsignarPlazaDocente/Edit/5
        public ActionResult Edit(int id)
        {
            return View();
        }

        // POST: AsignarPlazaDocente/Edit/5
        [HttpPost]
        public ActionResult Edit(int id, FormCollection collection)
        {
            try
            {
                // TODO: Add update logic here

                return RedirectToAction("Index");
            }
            catch
            {
                return View();
            }
        }

        // GET: AsignarPlazaDocente/Delete/5
        public ActionResult Delete(int id)
        {
            return View();
        }

        // POST: AsignarPlazaDocente/Delete/5
        [HttpPost]
        public ActionResult Delete(int id, FormCollection collection)
        {
            try
            {
                // TODO: Add delete logic here

                return RedirectToAction("Index");
            }
            catch
            {
                return View();
            }
        }


        [HttpPost]
        public JsonResult GetPlazasDistribucionPlazaCategoria(int IdEstructuraOrganica = 0)
        {

            var model = db.Plazas_stDistribucionPlazaCategoria.Where(c => c.IdEstructuraOrganica == IdEstructuraOrganica &&
                    c.EsVigente == true && c.EsAutorizada == true && c.EsVacante == true && c.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral != "CONFIANZA")
                .Select(s => new { s.IdDistribucionPlazaCategoria, s.Plazas_ctCategoria.Categoria })
                .OrderBy(o => o.Categoria).ToList();

            return Json(model, JsonRequestBehavior.AllowGet);
        }


        public JsonResult GetEstructuraOrganica()
        {
            bool EsPlantel = true;
            string TipoBusqueda = (EsPlantel ? "PLANTEL NÚM." : "EMSAD NÚM.");
            var model = db.Catalogos_ctEstructuraOrganica.Where(c => c.EsVigente == true && c.EstructuraOrganica.Contains(TipoBusqueda)).
                  Select(s => new { s.IdEstructuraOrganica, s.IdEstructuraOrganicaPadre, s.EstructuraOrganica }).
                  OrderBy(o => o.IdEstructuraOrganicaPadre).ThenBy(o => o.EstructuraOrganica).ToList();

            return Json(model, JsonRequestBehavior.AllowGet);
        }

        public ActionResult HistorialPlazas(int id)
        {
            //id recibido es el IdKardex
            ViewBag.IdKardex = id;
            var model = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(c => c.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex == id).OrderByDescending(o => o.FechaTermino).ToList();
            return View(model);
        }

        public ActionResult AsignarPlazaDocente(int Idkdx, int IdDPC, string FechaInicio, string FechaTermino, string Observacion)
        {
            string[] _ValidaContratos = { "CONTRATO", "HONORARIOS" };
            int IdEOC = 0;
            bool IsValid = false;
            string msg = "";
            Plazas_stDistribucionPlazaCategoria _plazaAsiganda = new Plazas_stDistribucionPlazaCategoria();

            if (Idkdx == 0)
                return Json(new { IsValid, Message = "Error. El usuario no ha seleccionado al trabajador para la plaza." });
            if (FechaInicio == "")
                return Json(new { IsValid, Message = "Error. El usuario no ha seleccionado la fecha de inicio para la asignación de la plaza." });
            if (IdDPC == 0)
                return Json(new { IsValid, Message = "Error. El usuario no ha seleccionado la categoría para el trabajdor." });
            else
            {
                _plazaAsiganda = db.Plazas_stDistribucionPlazaCategoria.Find(IdDPC);
            }

            var _trabajador = db.vwDatosAspirantesTrabajadores.Where(t => t.IdKardex == Idkdx).FirstOrDefault();
            string estatustrabajador = _trabajador.EstatusTrabajador;





            if (_ValidaContratos.Contains(_plazaAsiganda.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral) && FechaTermino == "")
                return Json(new { IsValid, Message = "Error. La Fecha de Termino es obligatoria para la categoría y tipo de Convenio Laboral" });

            if (FechaTermino != "")

            {
                DateTime _fechaInicial = Convert.ToDateTime(FechaInicio);
                DateTime _fechaTermino = Convert.ToDateTime(FechaTermino);
                int ComparaFecha = DateTime.Compare(_fechaInicial, _fechaTermino);

                if (ComparaFecha > 0 || ComparaFecha == 0)
                    return Json(new { IsValid, Message = "Error. La Fecha de Inicio NO debe ser IGUAL o MAYOR a la Fecha Término del convenio laboral." });
            }
            bool valor = false;
            TransactionOptions transactionoptions = new TransactionOptions();
            transactionoptions.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;

            switch (estatustrabajador)
            {
                case "ALTA":
                case "BAJA":

                    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions))
                    {
                        try
                        {
                            Kardex_ctTrabajador _nuevoTrabajador = new Kardex_ctTrabajador();
                            Convenios_stConvenioLaboralTrabajador _nuevoConvenioLaboral = new Convenios_stConvenioLaboralTrabajador();
                            Convenios_stConvenioLaboralTrabajadorCategoria _nuevoConvenioLaboralTrabajadorCategoria = new Convenios_stConvenioLaboralTrabajadorCategoria();

                            _nuevoTrabajador = db.Kardex_ctTrabajador.Find(_trabajador.IdTrabajador);

                            _nuevoConvenioLaboral.IdTrabajador = _nuevoTrabajador.IdTrabajador;
                            _nuevoConvenioLaboral.FechaInicio = System.Convert.ToDateTime(FechaInicio);
                            if (FechaTermino != "")
                                _nuevoConvenioLaboral.FechaTermino = System.Convert.ToDateTime(FechaTermino);
                            db.Convenios_stConvenioLaboralTrabajador.Add(_nuevoConvenioLaboral);
                            db.SaveChanges();

                            _nuevoConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajador = _nuevoConvenioLaboral.IdConvenioLaboralTrabajador;
                            _nuevoConvenioLaboralTrabajadorCategoria.IdDistribucionPlazaCategoria = IdDPC;
                            _nuevoConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica = (IdEOC > 0 ? (short)IdEOC : _plazaAsiganda.IdEstructuraOrganica);
                            _nuevoConvenioLaboralTrabajadorCategoria.EsComisionado = (IdEOC > 0 ? true : false);
                            _nuevoConvenioLaboralTrabajadorCategoria.FechaInicio = _nuevoConvenioLaboral.FechaInicio;
                            _nuevoConvenioLaboralTrabajadorCategoria.FechaTermino = _nuevoConvenioLaboral.FechaTermino;
                            _nuevoConvenioLaboralTrabajadorCategoria.EsCancelado = false;
                            _nuevoConvenioLaboralTrabajadorCategoria.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                            _nuevoConvenioLaboralTrabajadorCategoria.FechaCreacion = DateTime.Now;
                            _nuevoConvenioLaboralTrabajadorCategoria.Observacion = Observacion;
                            _nuevoConvenioLaboralTrabajadorCategoria.EsCuotaSindical = false;
                            db.Convenios_stConvenioLaboralTrabajadorCategoria.Add(_nuevoConvenioLaboralTrabajadorCategoria);
                            db.SaveChanges();
                            var _distribucionPlazaCategoria = db.Plazas_stDistribucionPlazaCategoria.Find(IdDPC);
                            _distribucionPlazaCategoria.EsVacante = false;
                            //db.Entry(_distribucionPlazaCategoria).State = EntityState.Modified;
                            //db.SaveChanges();
                            valor = TryUpdateModel(_distribucionPlazaCategoria);
                            if (valor)
                                db.SaveChanges();
                            else
                                throw new Exception("Error al actualizar la Distribución Plaza Categoría, no se pudo ocupar la plaza.");

                        }
                        catch (Exception e)
                        {


                            return Json(new { IsValid, Message = ExceptionExtensions.GetOriginalException(e).Message });
                        }
                        scope.Complete();

                        msg = "Plaza asignada con éxito.";
                        IsValid = true;


                    }
                    break;
                case "ASPIRANTE":
                    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions))
                    {
                        try
                        {
                            Kardex_ctTrabajador _nuevoTrabajador = new Kardex_ctTrabajador();
                            Convenios_stConvenioLaboralTrabajador _nuevoConvenioLaboral = new Convenios_stConvenioLaboralTrabajador();
                            Convenios_stConvenioLaboralTrabajadorCategoria _nuevoConvenioLaboralTrabajadorCategoria = new Convenios_stConvenioLaboralTrabajadorCategoria();
                            _nuevoTrabajador.IdKardex = Idkdx;
                            _nuevoTrabajador.FechaAsignacion = System.Convert.ToDateTime(FechaInicio);
                            db.Kardex_ctTrabajador.Add(_nuevoTrabajador);
                            db.SaveChanges();

                            _nuevoConvenioLaboral.IdTrabajador = _nuevoTrabajador.IdTrabajador;
                            _nuevoConvenioLaboral.FechaInicio = _nuevoTrabajador.FechaAsignacion;
                            if (FechaTermino != "")
                                _nuevoConvenioLaboral.FechaTermino = System.Convert.ToDateTime(FechaTermino);
                            db.Convenios_stConvenioLaboralTrabajador.Add(_nuevoConvenioLaboral);
                            db.SaveChanges();

                            _nuevoConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajador = _nuevoConvenioLaboral.IdConvenioLaboralTrabajador;
                            _nuevoConvenioLaboralTrabajadorCategoria.IdDistribucionPlazaCategoria = IdDPC;
                            _nuevoConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica = (IdEOC > 0 ? (short)IdEOC : _plazaAsiganda.IdEstructuraOrganica);
                            _nuevoConvenioLaboralTrabajadorCategoria.EsComisionado = (IdEOC > 0 ? true : false);
                            _nuevoConvenioLaboralTrabajadorCategoria.FechaInicio = _nuevoConvenioLaboral.FechaInicio;
                            _nuevoConvenioLaboralTrabajadorCategoria.FechaTermino = _nuevoConvenioLaboral.FechaTermino;
                            _nuevoConvenioLaboralTrabajadorCategoria.EsCancelado = false;
                            _nuevoConvenioLaboralTrabajadorCategoria.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                            _nuevoConvenioLaboralTrabajadorCategoria.FechaCreacion = DateTime.Now;
                            _nuevoConvenioLaboralTrabajadorCategoria.Observacion = Observacion;
                            _nuevoConvenioLaboralTrabajadorCategoria.EsCuotaSindical = false;
                            db.Convenios_stConvenioLaboralTrabajadorCategoria.Add(_nuevoConvenioLaboralTrabajadorCategoria);
                            db.SaveChanges();
                            var _distribucionPlazaCategoria = db.Plazas_stDistribucionPlazaCategoria.Find(IdDPC);
                            _distribucionPlazaCategoria.EsVacante = false;
                            //db.Entry(_distribucionPlazaCategoria).State = EntityState.Modified;
                            //db.SaveChanges();
                            valor = TryUpdateModel(_distribucionPlazaCategoria);
                            if (valor)
                                db.SaveChanges();
                            else
                            {
                                foreach (var modelState in ModelState.Values)
                                {
                                    foreach (var error in modelState.Errors)
                                    {
                                        throw new Exception("Ocurrió un error al intentar guradar en la tabla Distribución Plaza Categoría. Error: " + error.ErrorMessage + " acción cancelada.");

                                    }
                                }
                            }

                        }
                        catch (Exception e)
                        {


                            return Json(new { IsValid, Message = ExceptionExtensions.GetOriginalException(e).Message });
                        }
                        scope.Complete();

                        msg = "Plaza asignada con éxito.";
                        IsValid = true;


                    }
                    break;






            }

            if (IsValid)
                Seguridad.Identidad.ResetSingleton();

            return Json(new { IsValid, Message = msg });
        }
    }
}

