﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Dapper;
using Nova.Models;
using Nova.Libraries;
using System.Transactions;



namespace Nova.Controllers.AsignarPlaza
{
    public class AsignarPlazaController : BaseController
    {

        private bdNovaEntities db = new bdNovaEntities();

        [ActionName("AsignarPlazaTrabajador")]

        public ActionResult CrearPlaza(int idkardex)
        {
            Tuple<vwDatosAspirantesTrabajadores, List<Convenios_stConvenioLaboralTrabajadorCategoria>> model = null;

            ViewBag.IdKardex = idkardex;

            var HistorialAspirante = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(c => c.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex == idkardex).OrderBy(o => o.FechaTermino).ToList();
            var _trabajadorActual = db.vwDatosAspirantesTrabajadores.Where(t => t.IdKardex == idkardex).FirstOrDefault();
            string _nombretrabajadorActual = _trabajadorActual.ApellidoPaterno + " " + _trabajadorActual.ApellidoMaterno + " " + _trabajadorActual.Nombre; 
            DateTime Hoy = DateTime.Now;
            int _diaActual = Hoy.Day;
            int _diasMes = DateTime.DaysInMonth(Hoy.Year, Hoy.Month);
            string _fechaMaxima = "";


            if (_trabajadorActual == null)
                throw new Exception("El trabajador con el IdKardex [" + idkardex.ToString() + "] NO EXISTE !.");

            if (_trabajadorActual.EstatusTrabajador == "ALTA" && _trabajadorActual.FechaTermino!=null)
            {

                if (Hoy.Day > 15)
                    _fechaMaxima = _diasMes.ToString() + "-" + Hoy.Month.ToString() + "-" + Hoy.Year.ToString();
                else
                    _fechaMaxima = "15-" + Hoy.Month.ToString() + "-" + Hoy.Year.ToString();

                DateTime _FechaFinal = System.Convert.ToDateTime(_fechaMaxima);

                var _plazasPorLiberarseTrabajadorActual = db.vwDatosAspirantesTrabajadores.Where(t => t.FechaTermino != null && (t.FechaTermino >= Hoy && t.FechaTermino <= _FechaFinal && t.IdDistribucionPlazaCategoria == _trabajadorActual.IdDistribucionPlazaCategoria)).ToList();

                if (_plazasPorLiberarseTrabajadorActual.Count() == 0)
                    throw new Exception("Error. No existen CONVENIOS por terminar para la liberación de plazas!");
                if (_plazasPorLiberarseTrabajadorActual.Count() > 1)
                    throw new Exception("Error. La plaza ha sido asignada más de una vez, valide la información !!");


            }


            model = Tuple.Create(_trabajadorActual, HistorialAspirante);


            return View("CrearPlaza", model);
        }

        [HttpPost]
        public JsonResult GetPlazasDistribucionPlazaCategoria(int IdEstructuraOrganica = 0, int IdKardex = 0)
        {
            DateTime Hoy = DateTime.Now;
            int _diaActual = Hoy.Day;
            int _diasMes = DateTime.DaysInMonth(Hoy.Year, Hoy.Month);
            string _fechaMaxima = "";
            vwDatosAspirantesTrabajadores _trabajadorActual = new vwDatosAspirantesTrabajadores();
            _trabajadorActual = db.vwDatosAspirantesTrabajadores.Where(t => t.IdKardex == IdKardex).FirstOrDefault();
            List<vwDatosAspirantesTrabajadores> _plazasPorLiberarseQuincenaActual = new List<vwDatosAspirantesTrabajadores>();

            switch (_trabajadorActual.EstatusTrabajador)
            {
                case "ALTA":
                case "BAJA":
                    if (Hoy.Day > 15)
                        _fechaMaxima = _diasMes.ToString() + "-" + Hoy.Month.ToString() + "-" + Hoy.Year.ToString();
                    else
                        _fechaMaxima = "15-" + Hoy.Month.ToString() + "-" + Hoy.Year.ToString();

                    DateTime _FechaFinal = System.Convert.ToDateTime(_fechaMaxima);

                    _plazasPorLiberarseQuincenaActual = db.vwDatosAspirantesTrabajadores.Where(t => t.IdEstructuraOrganica == IdEstructuraOrganica && t.FechaTermino != null && (t.FechaTermino >= Hoy && t.FechaTermino <= _FechaFinal && t.IdDistribucionPlazaCategoria != _trabajadorActual.IdDistribucionPlazaCategoria)).ToList();

                    break;
            }

            var model = db.Plazas_stDistribucionPlazaCategoria.Where(c => c.IdEstructuraOrganica == IdEstructuraOrganica &&
                    c.EsVigente == true && c.EsAutorizada == true && c.EsVacante == true)
                .Select(s => new { s.IdDistribucionPlazaCategoria, s.Plazas_ctCategoria.Categoria });


            if (_plazasPorLiberarseQuincenaActual.Count > 0)
            {
                var Ids = _plazasPorLiberarseQuincenaActual.Select(s => s.IdDistribucionPlazaCategoria);
                var _plazasPorLiberarse = db.Plazas_stDistribucionPlazaCategoria.Where(p => Ids.Contains(p.IdDistribucionPlazaCategoria))
                                         .Select(s => new { s.IdDistribucionPlazaCategoria, Categoria = s.Plazas_ctCategoria.Categoria + " [Próxima vacante]" });
                model = model.Union(_plazasPorLiberarse);
            }

            return Json(model.OrderBy(o => o.Categoria), JsonRequestBehavior.AllowGet);
        }


        public JsonResult GetEstructuraOrganica()
        {
            var model = db.Catalogos_ctEstructuraOrganica.Where(c => c.EsVigente == true).
                  Select(s => new { s.IdEstructuraOrganica, s.IdEstructuraOrganicaPadre, s.EstructuraOrganica }).
                  OrderBy(o => o.IdEstructuraOrganicaPadre).ThenBy(o => o.EstructuraOrganica).ToList();

            return Json(model, JsonRequestBehavior.AllowGet);
        }



        public ActionResult AsignaPlazaTrabajador(int Idkdx, int IdDPC, int IdEOC, string FechaInicio, string FechaTermino, string Observacion)
        {
            string[] _ValidaContratos = { "CONTRATO", "HONORARIOS" };
            bool IsValid = false;
            string msg = "";
            Plazas_stDistribucionPlazaCategoria _plazaAsiganda = new Plazas_stDistribucionPlazaCategoria();

            if (Idkdx == 0)
                return Json(new { IsValid, Message = "Error. El usuario no ha seleccionado al trabajador para la plaza." });

            var _trabajador = db.vwDatosAspirantesTrabajadores.Where(t => t.IdKardex == Idkdx).FirstOrDefault();
             string estatustrabajador= _trabajador.EstatusTrabajador;

            if(estatustrabajador=="ALTA" && _trabajador.FechaTermino == null)
                 return Json(new { IsValid, Message = "Error. Trabajador sin Fecha de Término en su actual convenio laboral, favor de validar!" });


            if (FechaInicio == "")
                return Json(new { IsValid, Message = "Error. El usuario no ha seleccionado la fecha de inicio para la asignación de la plaza." });

            if (IdDPC == 0)
                return Json(new { IsValid, Message = "Error. El usuario no ha seleccionado la categoría para el trabajador." });
            else
                _plazaAsiganda = db.Plazas_stDistribucionPlazaCategoria.Find(IdDPC);




            if (_ValidaContratos.Contains(_plazaAsiganda.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral) && FechaTermino == "")
                return Json(new { IsValid, Message = "Error. La Fecha de Termino es obligatoria para el tipo de Convenio Laboral y categoría." });

            if (!_plazaAsiganda.EsVacante)
            {
                var _TrabajadorPorLiberar = db.vwDatosAspirantesTrabajadores.Where(t => t.IdDistribucionPlazaCategoria == _plazaAsiganda.IdDistribucionPlazaCategoria);
                if (_TrabajadorPorLiberar.Count() > 1)
                    return Json(new { IsValid, Message = "Error. La plaza ha sido asignada más de una vez, valide la información !!" });
                else
                {
                    DateTime _fechaTerminoTrabajadorPorLiberar = (DateTime)_TrabajadorPorLiberar.FirstOrDefault().FechaTermino;
                    if (System.Convert.ToDateTime(FechaInicio) != _fechaTerminoTrabajadorPorLiberar.AddDays(1))
                        return Json(new { IsValid, Message = "Error. La plaza por asignar debe tener una [Fecha de Inicio] posterior a la fecha de término de la plaza [Próxima vacante]" });
                }
            }

            DateTime _fechaInicial = Convert.ToDateTime(FechaInicio);
            DateTime _fechaTermino;

            if (FechaTermino != "")

            {
                _fechaTermino = Convert.ToDateTime(FechaTermino);
                int ComparaFecha = DateTime.Compare(_fechaInicial, _fechaTermino);

                if (ComparaFecha > 0 || ComparaFecha == 0)
                    return Json(new { IsValid, Message = "Error. La Fecha de Inicio NO debe ser IGUAL o MAYOR a la Fecha Término del convenio laboral." });
            }

            //if (!ExisteNominaAbierta(_fechaInicial, IdDPC))
            //    return Json(new { IsValid, Message = "Error. No existe una nómina abierta para el período del contrato y asignación de plaza." });
            bool valor = false;
            TransactionOptions transactionoptions = new TransactionOptions();
            transactionoptions.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
            switch (estatustrabajador)
            {
                case "ALTA":
                case "BAJA":
                    
                    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions))
                    {
                        try
                        {
                            Kardex_ctTrabajador _nuevoTrabajador = new Kardex_ctTrabajador();
                            Convenios_stConvenioLaboralTrabajador _nuevoConvenioLaboral = new Convenios_stConvenioLaboralTrabajador();
                            Convenios_stConvenioLaboralTrabajadorCategoria _nuevoConvenioLaboralTrabajadorCategoria = new Convenios_stConvenioLaboralTrabajadorCategoria();

                            _nuevoTrabajador = db.Kardex_ctTrabajador.Find(_trabajador.IdTrabajador);

                            _nuevoConvenioLaboral.IdTrabajador = _nuevoTrabajador.IdTrabajador;
                            _nuevoConvenioLaboral.FechaInicio = System.Convert.ToDateTime(FechaInicio);
                            if (FechaTermino != "")
                                _nuevoConvenioLaboral.FechaTermino = System.Convert.ToDateTime(FechaTermino);
                            db.Convenios_stConvenioLaboralTrabajador.Add(_nuevoConvenioLaboral);
                            db.SaveChanges();

                            _nuevoConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajador = _nuevoConvenioLaboral.IdConvenioLaboralTrabajador;
                            _nuevoConvenioLaboralTrabajadorCategoria.IdDistribucionPlazaCategoria = IdDPC;
                            _nuevoConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica = (IdEOC > 0 ? (short)IdEOC : _plazaAsiganda.IdEstructuraOrganica);
                            _nuevoConvenioLaboralTrabajadorCategoria.EsComisionado = (IdEOC > 0 ? true : false);
                            _nuevoConvenioLaboralTrabajadorCategoria.FechaInicio = _nuevoConvenioLaboral.FechaInicio;
                            _nuevoConvenioLaboralTrabajadorCategoria.FechaTermino = _nuevoConvenioLaboral.FechaTermino;
                            _nuevoConvenioLaboralTrabajadorCategoria.EsCancelado = false;
                            _nuevoConvenioLaboralTrabajadorCategoria.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                            _nuevoConvenioLaboralTrabajadorCategoria.FechaCreacion = DateTime.Now;
                            _nuevoConvenioLaboralTrabajadorCategoria.Observacion = Observacion;
                            _nuevoConvenioLaboralTrabajadorCategoria.EsCuotaSindical = false;
                            db.Convenios_stConvenioLaboralTrabajadorCategoria.Add(_nuevoConvenioLaboralTrabajadorCategoria);
                            db.SaveChanges();
                            var _distribucionPlazaCategoria = db.Plazas_stDistribucionPlazaCategoria.Find(IdDPC);
                            _distribucionPlazaCategoria.EsVacante = false;
                            if (_distribucionPlazaCategoria.Codigo == "")
                                _distribucionPlazaCategoria.Codigo = "_";
                            //db.Entry(_distribucionPlazaCategoria).State = EntityState.Modified;
                            //db.SaveChanges();

                            valor = TryUpdateModel(_distribucionPlazaCategoria);
                            if (valor)
                                db.SaveChanges();
                            else
                            {
                                foreach (var modelState in ModelState.Values)
                                {
                                    foreach (var error in modelState.Errors)
                                    {
                                        throw new Exception("Ocurrió un error al intentar guradar en la tabla Distribución Plaza Categoría. Error: " + error.ErrorMessage + " acción cancelada.");

                                    }
                                }
                            }

                        }
                        catch (Exception e)
                        {


                            return Json(new { IsValid, Message = ExceptionExtensions.GetOriginalException(e).Message });
                        }
                        scope.Complete();
                        
                        msg = "Plaza asignada con éxito.";
                        IsValid = true;


                    }
                    break;
                case "ASPIRANTE":
                    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions))
                    {
                        try
                        {
                            Kardex_ctTrabajador _nuevoTrabajador = new Kardex_ctTrabajador();
                            Convenios_stConvenioLaboralTrabajador _nuevoConvenioLaboral = new Convenios_stConvenioLaboralTrabajador();
                            Convenios_stConvenioLaboralTrabajadorCategoria _nuevoConvenioLaboralTrabajadorCategoria = new Convenios_stConvenioLaboralTrabajadorCategoria();
                            _nuevoTrabajador.IdKardex = Idkdx;
                            _nuevoTrabajador.FechaAsignacion = System.Convert.ToDateTime(FechaInicio);
                            db.Kardex_ctTrabajador.Add(_nuevoTrabajador);
                            db.SaveChanges();

                            _nuevoConvenioLaboral.IdTrabajador = _nuevoTrabajador.IdTrabajador;
                            _nuevoConvenioLaboral.FechaInicio = _nuevoTrabajador.FechaAsignacion;
                            if (FechaTermino != "")
                                _nuevoConvenioLaboral.FechaTermino = System.Convert.ToDateTime(FechaTermino);
                            db.Convenios_stConvenioLaboralTrabajador.Add(_nuevoConvenioLaboral);
                            db.SaveChanges();

                            _nuevoConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajador = _nuevoConvenioLaboral.IdConvenioLaboralTrabajador;
                            _nuevoConvenioLaboralTrabajadorCategoria.IdDistribucionPlazaCategoria = IdDPC;
                            _nuevoConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica = (IdEOC > 0 ? (short)IdEOC : _plazaAsiganda.IdEstructuraOrganica);
                            _nuevoConvenioLaboralTrabajadorCategoria.EsComisionado = (IdEOC > 0 ? true : false);
                            _nuevoConvenioLaboralTrabajadorCategoria.FechaInicio = _nuevoConvenioLaboral.FechaInicio;
                            _nuevoConvenioLaboralTrabajadorCategoria.FechaTermino = _nuevoConvenioLaboral.FechaTermino;
                            _nuevoConvenioLaboralTrabajadorCategoria.EsCancelado = false;
                            _nuevoConvenioLaboralTrabajadorCategoria.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                            _nuevoConvenioLaboralTrabajadorCategoria.FechaCreacion = DateTime.Now;
                            _nuevoConvenioLaboralTrabajadorCategoria.Observacion = Observacion;
                            _nuevoConvenioLaboralTrabajadorCategoria.EsCuotaSindical = false;
                            db.Convenios_stConvenioLaboralTrabajadorCategoria.Add(_nuevoConvenioLaboralTrabajadorCategoria);
                            db.SaveChanges();
                            var _distribucionPlazaCategoria = db.Plazas_stDistribucionPlazaCategoria.Find(IdDPC);
                            _distribucionPlazaCategoria.EsVacante = false;
                            //db.Entry(_distribucionPlazaCategoria).State = EntityState.Modified;
                            //db.SaveChanges();
                            if (_distribucionPlazaCategoria.Codigo == "")
                                _distribucionPlazaCategoria.Codigo = "_";

                            valor = TryUpdateModel(_distribucionPlazaCategoria);
                            if (valor)
                                db.SaveChanges();
                            else
                            {
                                foreach (var modelState in ModelState.Values)
                                {
                                    foreach (var error in modelState.Errors)
                                    {
                                        throw new Exception("Ocurrió un error al intentar guradar en la tabla Distribución Plaza Categoría. Error: " + error.ErrorMessage+" acción cancelada.");
                                        
                                    }
                                }
                            } 

                        }
                        catch (Exception e)
                        {


                            return Json(new { IsValid, Message = ExceptionExtensions.GetOriginalException(e).Message });
                        }
                        scope.Complete();
                      
                        msg = "Plaza asignada con éxito.";
                        IsValid = true;


                    }
                    break;






            }
            
            if (IsValid)
                Seguridad.Identidad.ResetSingleton();

            return Json(new { IsValid, Message = msg });
        }

        //public ActionResult Comisionar(int idcltc,int IdEOC)
        //{
        //    return Json(new { IsValid, Message = "Error. Trabajador sin Fecha de Término en su actual convenio laboral, favor de validar!" });

        //}
        private bool ExisteNominaAbierta(DateTime _fechaInicial, int IdDPC)
        {
            bool _existe = false;
            int _IdRelacionConvenioLaboral = db.Plazas_stDistribucionPlazaCategoria.Find(IdDPC).Plazas_ctCategoria.IdRelacionConvenioLaboral;

            int _nominasAbiertas = db.Nomina_stNomina.Where(n => n.EsCerrada == false && n.Nomina_ctPlantillaNomina.Catalogos_ctParametrosRelacionLaboral.IdRelacionConvenioLaboral == _IdRelacionConvenioLaboral && n.FechaTermino.Year == _fechaInicial.Year && (n.FechaTermino.Month <= _fechaInicial.Month && n.FechaInicio.Month >= _fechaInicial.Month)).Count();

            if (_nominasAbiertas > 0)
                _existe = true;

            return _existe;

        }

        public ActionResult UbicacionFisica(int IdConvenioLaboralTrabajadorCategoria = 0)
        {
            

            Tuple<vwDatosAspirantesTrabajadores, Convenios_stConvenioLaboralTrabajadorCategoria> model = null;
            Convenios_stConvenioLaboralTrabajadorCategoria _trabajadorActual = new Convenios_stConvenioLaboralTrabajadorCategoria();
            vwDatosAspirantesTrabajadores _datosTrabajador = new vwDatosAspirantesTrabajadores();

            _trabajadorActual = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(IdConvenioLaboralTrabajadorCategoria);
            _datosTrabajador = db.vwDatosAspirantesTrabajadores.FirstOrDefault(t => t.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria);

            ViewBag.IdEstructuraOrganicaFisica = new SelectList(db.Catalogos_ctEstructuraOrganica.Where(o=>o.EsVigente==true).OrderBy(e=>e.IdModalidadEstudio).ThenBy(e=>e.IdEstructuraOrganicaPadre).ThenBy(d=>d.EstructuraOrganica), "IdEstructuraOrganica", "EstructuraOrganica", _trabajadorActual.IdEstructuraOrganica);

            model = Tuple.Create(_datosTrabajador, _trabajadorActual);


            return View(model);


        }

        public ActionResult ActualizarUbicacionFisica(int Id, short ideof, string obs, bool esc)
        {

            bool IsValid = false;
            string msg = "";

            Convenios_stConvenioLaboralTrabajadorCategoria _trabajadorActual = new Convenios_stConvenioLaboralTrabajadorCategoria();

            _trabajadorActual = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(Id);

            _trabajadorActual.IdEstructuraOrganica = ideof;

            _trabajadorActual.Observacion = obs;

            _trabajadorActual.EsComisionado = esc;

            bool valor = TryUpdateModel(_trabajadorActual);

            if (valor)
            {
                try
                {
                    db.SaveChanges();
                    IsValid = true;
                }
                catch (Exception e)
                {
                    msg = ExceptionExtensions.GetOriginalException(e).Message;
                    IsValid = false;
                    return JsonView(IsValid, msg );
                }
               
               
            }
            else
            {
                foreach (var modelState in ModelState.Values)
                {
                    foreach (var error in modelState.Errors)
                    {

                        return JsonView(IsValid, "Error. No se pudo cambiar la ubicación física del trabajador, favor de validar la acción!" + error.ErrorMessage);

                    }
                }
            }

           // return Json(new { IsValid = true, Message = "Registro actualizado con éxito." },);
            return JsonView(IsValid, "Registro actualizado con éxito.", null, null, Url.Action("UbicacionFisica", "AsignarPlaza", new { IdConvenioLaboralTrabajadorCategoria= Id }));
        }
        public ActionResult MostrarGridConveniolaboralTrabajadorCategoria()
        {
            int idtrabajador = Convert.ToInt32(Session["idtrabajador"]);
            Convenios_stConvenioLaboralTrabajadorCategoria Valida = new Convenios_stConvenioLaboralTrabajadorCategoria();
            var model = from a in db.Convenios_stConvenioLaboralTrabajadorCategoria
                        join b in db.Convenios_stConvenioLaboralTrabajador on a.IdConvenioLaboralTrabajador equals b.IdConvenioLaboralTrabajador
                        join c in db.Plazas_stDistribucionPlazaCategoria on a.IdDistribucionPlazaCategoria equals c.IdDistribucionPlazaCategoria
                        join j in db.Catalogos_ctEstructuraOrganica on c.IdEstructuraOrganica equals j.IdEstructuraOrganica
                        join d in db.Plazas_ctCategoria on c.IdCategoria equals d.IdCategoria
                        join e in db.Convenios_stRelacionConvenioLaboral on d.IdRelacionConvenioLaboral equals e.IdRelacionConvenioLaboral
                        join f in db.Catalogos_ctConvenioLaboral on e.IdConvenioLaboral equals f.IdConvenioLaboral
                        join g in db.Catalogos_ctRelacionLaboral on e.IdRelacionLaboral equals g.IdRelacionLaboral
                        join h in db.Kardex_ctTrabajador on b.IdTrabajador equals h.IdTrabajador
                        join i in db.Kardex_ctDatosPersonales on h.IdKardex equals i.IdKardex
                        join k in db.Catalogos_ctEstructuraOrganica on a.IdEstructuraOrganica equals k.IdEstructuraOrganica
                        where b.IdTrabajador == idtrabajador && a.EsCancelado == false
                        orderby a.IdConvenioLaboralTrabajadorCategoria descending
                        select new
                        {
                            IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria,
                            Nombre = i.Nombre,
                            ApellidoPaterno = i.ApellidoPaterno,
                            ApellidoMaterno = i.ApellidoMaterno,
                            IdTrabajador = b.IdTrabajador,
                            ConvenioLaboral = f.ConvenioLaboral,
                            RelacionLaboral = g.RelacionLaboral,
                            Categoria = d.Categoria,
                            EstructuraOrganica = j.EstructuraOrganica,
                            FechaInicioConvenioTrabajadorCategoria = a.FechaInicio,
                            FechaTerminoConvenioTrabajadorCategoria = a.FechaTermino,
                            IdConvenioLaboral = f.IdConvenioLaboral,
                            IdDistribucionPlazaCategoria = a.IdDistribucionPlazaCategoria,
                            IdRelacionConvenioLaboral = d.IdRelacionConvenioLaboral,
                            IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador,
                            Observacion = a.Observacion,
                            LaboraFisicamente = k.EstructuraOrganica
                        };
            //var model = db.vwIdConvenioLaboralTrabajadorCategoria.Where(s => s.IdTrabajador == idtrabajador && s.EsCancelado==false ).OrderByDescending(s => s.FechaInicioConvenioTrabajadorCategoria);
            //Nova.Models.ValidacionModelos.ResultadoValidacion resultado = new ValidacionModelos.ResultadoValidacion();
            //resultado = Valida.ValidaModelo(idtrabajador);
            if (model.Count() > 0)
            {
                Session["idCLTCAnterior"] = model.First().IdConvenioLaboralTrabajadorCategoria;
                Session["idCLTAnterior"] = model.First().IdConvenioLaboralTrabajador;
                Session["idDPCAnterior"] = model.First().IdDistribucionPlazaCategoria;
                Session["IdRCLAnterior"] = model.First().IdRelacionConvenioLaboral;
                Session["FechaInicioAnterior"] = model.First().FechaInicioConvenioTrabajadorCategoria;
                Session["EsCambioPlaza"] = "SI";

                if (!Valida.ValidaModelo(idtrabajador).IsValid)
                {
                    Session["EsCambioPlaza"] = "NO";
                    //MessageBox.Show(ViewData, TipoMensaje.Warning, "El convenio laboral del trabajador tiene fecha de término, no procede el cambio de plaza");
                    throw new ApplicationException("El convenio laboral del trabajador tiene fecha de término, no procede el cambio de plaza");
                }
                else
                {
                    int idclt = Convert.ToInt32(Valida.parenresult.Mensaje);
                    Session["idclt"] = idclt;
                    //var RelacionConvenios = from a in db.vwIdConvenioLaboralTrabajadorCategoria
                    //                        where a.IdConvenioLaboralTrabajador == idclt && a.EsCancelado == false
                    //                        orderby a.FechaInicioConvenio descending

                    //                        select new { IdRelacionConvenioLaboral = a.IdRelacionConvenioLaboral };
                    //foreach (var item in RelacionConvenios)
                    //{
                    //    Session["IdRelacionConvenioLaboral"] = item.IdRelacionConvenioLaboral;
                    //    break;

                    //}
                }
            }
            else
            {
                Session["EsCambioPlaza"] = "NO";
                MessageBox.Show(ViewData, TipoMensaje.Warning, "El trabajador no tiene una plaza asignada, no procede el cambio de plaza, verifíquelo");

            }
            return PartialView("MostrarGridConveniolaboralTrabajadorCategoria", model.ToList());
        }

    }
}


