﻿using Nova.Libraries;
using Nova.Models;
using Rotativa;
using System;
using System.Collections.Generic;
using System.Data.Linq.SqlClient;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Script.Serialization;
using System.Data.SqlClient;
using System.Data;
using Dapper;

namespace Nova.Controllers.Alumnos
{
    public class TutorController : Controller
    {
        //
       
            //
            // GET: /Alumnos/
            [TutoresAuthorize]
            [HasPermission("Tutores")]
            public ActionResult Index()
            {
                return View();
            }

            // GET: /Alumnos/
            [TutoresAuthorize]
            [HasPermission("Tutores")]
            public ActionResult Aprovechamiento()
            {


                return View();
            }


            // GET: /Alumnos/
            [TutoresAuthorize]
            [HasPermission("Tutores")]
            public ActionResult TopRanking()
            {
                var x = Usuario.Tutor();
                ViewBag.RankingCampus = Nova.Models.Alumnos.getRankingCampus(x.Curp, x.Matricula);
                ViewBag.RankingCarrera = Nova.Models.Alumnos.getRankingCarrera(x.Curp, x.Matricula);

                return View();
            }




            [AllowAnonymous]

            public JsonResult getAprovechamiento()
            {

                var x = Usuario.Tutor();


                //var t = Json(Nova.Models.Alumnos.getAprovechamiento(x.Curp, x.Matricula), JsonRequestBehavior.AllowGet);
                var t = Nova.Models.Alumnos.getAprovechamiento(x.Curp, x.Matricula);

                JavaScriptSerializer js = new JavaScriptSerializer();
                var y = js.Serialize(t);

                return Json(y, JsonRequestBehavior.AllowGet);

            }

            [AllowAnonymous]
            public JsonResult getAprovechamientoArea()
            {

                var x = Usuario.Tutor();


                //var t = Json(Nova.Models.Alumnos.getAprovechamiento(x.Curp, x.Matricula), JsonRequestBehavior.AllowGet);
                var t = Nova.Models.Alumnos.getAprovechamientoArea(x.Curp, x.Matricula);

                JavaScriptSerializer js = new JavaScriptSerializer();
                var y = js.Serialize(t);

                return Json(y, JsonRequestBehavior.AllowGet);

            }

            [TutoresAuthorize]
            [HasPermission("Tutores")]
            public ActionResult HorarioVigente()
            {
                var x = Usuario.Tutor();
                return View("_HorarioVigente", Nova.Models.Alumnos.getHorarioVigente(x.Curp, x.Matricula));

            }


            [TutoresAuthorize]
            [HasPermission("Tutores")]
            public ActionResult HorarioAsignatura(long Id)
            {

                return PartialView("_HorarioAsignatura", Nova.Models.Alumnos.getHorarioAsignatura(Id));

            }

            [HttpPost]
            [AllowAnonymous]
            public JsonResult getCalificacionesHorarios(long Id)
            {
                var t = Json(Nova.Models.Alumnos.getCalificaciones(Id), JsonRequestBehavior.AllowGet);
                return t;

            }

            [TutoresAuthorize]
            [HasPermission("Tutores")]
            public ActionResult Kardex()
            {

                var x = Usuario.Tutor();
                return View(Nova.Models.Alumnos.getKardex(x.Curp, x.Matricula));


            }



            [AllowAnonymous]
            public ActionResult Boletas(short idgruponombre, short idcicloescolar, short idcampus, string periodo)
            {
                ViewBag.Layout = null;
                string namefile = "Boleta_" + DateTime.Now.ToShortDateString() + ".pdf";

                // return View(model);

                var listaalumnos = Nova.Models.Alumnos.getAlumnosPorGrupo(idgruponombre, idcampus, idcicloescolar);
                List<List<KardexAlumno>> alumnos = new List<List<KardexAlumno>>();

                foreach (var item in listaalumnos)
                {
                    alumnos.Add(Nova.Models.Alumnos.getBoleta(item.Curp, item.Matricula, item.IdCicloEscolar, periodo));
                }

                ViewBag.Periodo = periodo;
                Rotativa.Options.Margins m = new Rotativa.Options.Margins();
                m.Bottom = 0;
                m.Left = 15;
                m.Right = 15;
                m.Top = 5;
                return new ViewAsPdf("ImprimirBoleta", alumnos) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Portrait, PageMargins = m, FileName = namefile };

                //return View("Boleta",alumnos);


            }



            [TutoresAuthorize]
            [HasPermission("Tutores")]
            public ActionResult Boleta()
            {

                ViewBag.Layout = " ~/Views/Shared/_Alumnos2017.cshtml";
                //return new ViewAsPdf(Nova.Models.Alumnos.getBoleta(curp, matricula, cicloescolar, "Extraordinario")) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Portrait, PageMargins = m, FileName = modalidad };

                var listaalumnos = Nova.Models.Alumnos.getAlumnosCiclos(Usuario.Tutor().Curp, Usuario.Tutor().Matricula);
                List<List<KardexAlumno>> alumnos = new List<List<KardexAlumno>>();

                foreach (var item in listaalumnos)
                {
                    alumnos.Add(Nova.Models.Alumnos.getBoleta(item.Curp, item.Matricula, item.IdCicloEscolar, item.Periodo));
                }




                return View(alumnos);


            }
            [TutoresAuthorize]
            [HasPermission("Tutores")]
            public ActionResult TestBoleta(string curp, string matricula)
            {

                ViewBag.Layout = " ~/Views/Shared/_Alumnos2017.cshtml";
                //return new ViewAsPdf(Nova.Models.Alumnos.getBoleta(curp, matricula, cicloescolar, "Extraordinario")) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Portrait, PageMargins = m, FileName = modalidad };

                var listaalumnos = Nova.Models.Alumnos.getAlumnosCiclos(curp, matricula);
                List<List<KardexAlumno>> alumnos = new List<List<KardexAlumno>>();

                foreach (var item in listaalumnos)
                {
                    alumnos.Add(Nova.Models.Alumnos.getBoleta(item.Curp, item.Matricula, item.IdCicloEscolar, item.Periodo));
                }




                return View("Boleta", alumnos);


            }

            [TutoresAuthorize]
            [HasPermission("Tutores")]
            public ActionResult ImprimirBoleta(string curp, string matricula, short cicloescolar, string periodo)
            {

                string modalidad = "Boleta_" + curp + DateTime.Now.ToShortDateString() + ".pdf";

                // return View(model);
                Rotativa.Options.Margins m = new Rotativa.Options.Margins();
                m.Bottom = 0;
                m.Left = 15;
                m.Right = 15;
                m.Top = 5;



                List<List<KardexAlumno>> alumnos = new List<List<KardexAlumno>>();
                alumnos.Add(Nova.Models.Alumnos.getBoleta(curp, matricula, cicloescolar, periodo));

                return new ViewAsPdf(alumnos) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Portrait, PageMargins = m, FileName = modalidad };

            }


            [TutoresAuthorize]
            [HasPermission("Tutores")]
            public ActionResult Perfil()
            {
                return View();
            }


            //[AllowAnonymous]
            //public ActionResult getFotografiaDocenteasdsd(string id)
            //{

            //    bdNovaEntities bd = new bdNovaEntities();
            //    List<Kardex_ctDatosPersonales> foto = bd.Kardex_ctDatosPersonales.Where(e => e.CURP == id).ToList();
            //    string tipo = "jpg";
            //    byte[] image = Nova.Models.Alumnos.getFotografiaDocente(id, ref tipo, foto);
            //    //string tipo = PortalNovaAries.getTipoFotografia(id);
            //    if (image != null)
            //        return File(image, tipo);
            //    else
            //        return null;
            //}

            [HttpPost]
            [AllowAnonymous]
            public virtual JsonResult getFotografiaDocente(string id)
            {
                //var filePath = "~/Images/PngExampleImag.png";
                //var ImageBytes = System.IO.File.ReadAllBytes(Server.MapPath(filePath));

                //var data = Convert.ToBase64String(ImageBytes);
                //return Json(data);

                bdNovaEntities bd = new bdNovaEntities();
                var c = id.Substring(0, 10);
            Kardex_ctDatosPersonalesFotografias foto = bd.Kardex_ctDatosPersonalesFotografias.Where(e => e.IdKardex == ConvertToInt.ConvertToInt32(id)).FirstOrDefault();
            string tipo = "jpg";
                byte[] image = Nova.Models.Alumnos.getFotografiaDocente(id, ref tipo, foto);
                //string tipo = PortalNovaAries.getTipoFotografia(id);
                var data = "";
                if (image != null)
                    data = Convert.ToBase64String(image);

                return Json(new { Image = data, JsonRequestBehavior.AllowGet });
                // return Json(data);
            }

            [AllowAnonymous]
            public ActionResult getFotografia(string id)
            {



                DapperQuery dp = new DapperQuery("bdAriesEntities");
                string query;

                query = @"select Curp
      ,Foto
      ,TipoImagen
      ,QrCodigo
from stAlumnosFotos
where Curp='" + id + "' ";




                var foto = (List<stAlumnosFotos>)dp.connection.Query<stAlumnosFotos>(query);
                dp.Close();

                string tipo = "jpg";
                byte[] image = Nova.Models.Alumnos.getFotografia(id, ref tipo, foto);
                //string tipo = PortalNovaAries.getTipoFotografia(id);
                if (image != null)
                    return File(image, tipo);
                else
                    return null;
            }


        }


    }

