﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class UsuarioKardexController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: /UsuarioKardex/
        public ActionResult Index()
        {
            var usuariokardex = db.UsuarioKardex.Include(u => u.AspNetUsers).Include(u => u.Kardex_ctDatosPersonales);
            return View(usuariokardex.ToList());
        }

        // GET: /UsuarioKardex/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            UsuarioKardex usuariokardex = db.UsuarioKardex.Find(id);
            if (usuariokardex == null)
            {
                return HttpNotFound();
            }
            return View(usuariokardex);
        }

        // GET: /UsuarioKardex/Create
        public ActionResult Create()
        {
            ViewBag.Id = new SelectList(db.AspNetUsers, "Id", "Email");
            //ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP");
            //ViewBag.IdKardex = new SelectList((from s in db.Kardex_ctDatosPersonales.ToList() select new { IdKardex = s.IdKardex, Nombre = s.Nombre + "|" + s.ApellidoPaterno + "|" + s.ApellidoMaterno }), "IdKardex", "Nombre");
            ViewBag.IdKardex = new SelectList((from s in db.Kardex_ctDatosPersonales.OrderBy(s => s.Id).ToList() select new { IdKardex = s.IdKardex, Nombre = s.Id + "|" + s.Nombre + "|" + s.ApellidoPaterno + "|" + s.ApellidoMaterno }), "IdKardex", "Nombre");


            return View();
        }

        // POST: /UsuarioKardex/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include="IdUsuarioKardex,Id,IdKardex")] UsuarioKardex usuariokardex)
        {
            if (ModelState.IsValid)
            {
                db.UsuarioKardex.Add(usuariokardex);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.Id = new SelectList(db.AspNetUsers, "Id", "Email", usuariokardex.Id);
            ViewBag.IdKardex = new SelectList((from s in db.Kardex_ctDatosPersonales.OrderBy(s => s.Id).ToList() select new { IdKardex = s.IdKardex, Nombre = s.Id +"|"+s.Nombre + "|" + s.ApellidoPaterno + "|" + s.ApellidoMaterno }), "IdKardex", "Nombre", usuariokardex.IdKardex);
            return View(usuariokardex);
        }

        // GET: /UsuarioKardex/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            UsuarioKardex usuariokardex = db.UsuarioKardex.Find(id);
            if (usuariokardex == null)
            {
                return HttpNotFound();
            }
            ViewBag.Id = new SelectList(db.AspNetUsers, "Id", "Email", usuariokardex.Id);
            ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", usuariokardex.IdKardex);
            return View(usuariokardex);
        }

        // POST: /UsuarioKardex/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include="IdUsuarioKardex,Id,IdKardex")] UsuarioKardex usuariokardex)
        {
            if (ModelState.IsValid)
            {
                db.Entry(usuariokardex).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.Id = new SelectList(db.AspNetUsers, "Id", "Email", usuariokardex.Id);
            ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", usuariokardex.IdKardex);
            return View(usuariokardex);
        }

        // GET: /UsuarioKardex/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            UsuarioKardex usuariokardex = db.UsuarioKardex.Find(id);
            if (usuariokardex == null)
            {
                return HttpNotFound();
            }
            return View(usuariokardex);
        }

        // POST: /UsuarioKardex/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            UsuarioKardex usuariokardex = db.UsuarioKardex.Find(id);
            db.UsuarioKardex.Remove(usuariokardex);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
