﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class GrupoRolAplicacionUsuarioKardexController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: /GrupoRolAplicacionUsuarioKardex/
        public ActionResult Index()
        {
            var gruporolaplicacionusuariokardex = db.GrupoRolAplicacionUsuarioKardex.Include(g => g.Grupo).Include(g => g.UsuarioKardex);
            return View(gruporolaplicacionusuariokardex.ToList());
        }

        // GET: /GrupoRolAplicacionUsuarioKardex/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            GrupoRolAplicacionUsuarioKardex gruporolaplicacionusuariokardex = db.GrupoRolAplicacionUsuarioKardex.Find(id);
            if (gruporolaplicacionusuariokardex == null)
            {
                return HttpNotFound();
            }
            return View(gruporolaplicacionusuariokardex);
        }

        // GET: /GrupoRolAplicacionUsuarioKardex/Create
        public ActionResult Create()
        {
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1");
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion");
            //ViewBag.IdUsuarioKardex = new SelectList(db.UsuarioKardex, "IdUsuarioKardex", "Id");
            ViewBag.IdUsuarioKardex = new SelectList((from s in db.UsuarioKardex.ToList() select new { IdUsuarioKardex = s.IdUsuarioKardex, Id=s.Kardex_ctDatosPersonales.Nombre + " | " + s.Kardex_ctDatosPersonales.ApellidoPaterno + " | " + s.Kardex_ctDatosPersonales.ApellidoMaterno }), "IdUsuarioKardex", "Id").OrderBy(x=>x.Text);

            return View();
        }

        // POST: /GrupoRolAplicacionUsuarioKardex/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include="IdGrupoRolAplicacionUsuarioKardex,IdGrupo,IdUsuarioKardex")] GrupoRolAplicacionUsuarioKardex gruporolaplicacionusuariokardex)
        {
            if (ModelState.IsValid)
            {
                db.GrupoRolAplicacionUsuarioKardex.Add(gruporolaplicacionusuariokardex);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1", gruporolaplicacionusuariokardex.IdGrupo);
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion", gruporolaplicacionusuariokardex.IdGrupo);
            ViewBag.IdUsuarioKardex = new SelectList((from s in db.UsuarioKardex.ToList() select new { IdUsuarioKardex = s.IdUsuarioKardex, Id = s.IdKardex + "|" + s.Kardex_ctDatosPersonales.Nombre + "|" + s.Kardex_ctDatosPersonales.ApellidoPaterno + "|" + s.Kardex_ctDatosPersonales.ApellidoMaterno }), "IdUsuarioKardex", "Id");
            return View(gruporolaplicacionusuariokardex);
        }

        // GET: /GrupoRolAplicacionUsuarioKardex/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            GrupoRolAplicacionUsuarioKardex gruporolaplicacionusuariokardex = db.GrupoRolAplicacionUsuarioKardex.Find(id);
            if (gruporolaplicacionusuariokardex == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1", gruporolaplicacionusuariokardex.IdGrupo);
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion", gruporolaplicacionusuariokardex.IdGrupo);
            ViewBag.IdUsuarioKardex = new SelectList((from s in db.UsuarioKardex.ToList() select new { IdUsuarioKardex = s.IdUsuarioKardex, Id = s.IdKardex + "|" + s.Kardex_ctDatosPersonales.Nombre + "|" + s.Kardex_ctDatosPersonales.ApellidoPaterno + "|" + s.Kardex_ctDatosPersonales.ApellidoMaterno }), "IdUsuarioKardex", "Id");
            return View(gruporolaplicacionusuariokardex);
        }

        // POST: /GrupoRolAplicacionUsuarioKardex/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include="IdGrupoRolAplicacionUsuarioKardex,IdGrupo,IdUsuarioKardex")] GrupoRolAplicacionUsuarioKardex gruporolaplicacionusuariokardex)
        {
            if (ModelState.IsValid)
            {
                db.Entry(gruporolaplicacionusuariokardex).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1", gruporolaplicacionusuariokardex.IdGrupo);
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion", gruporolaplicacionusuariokardex.IdGrupo);
            ViewBag.IdUsuarioKardex = new SelectList((from s in db.UsuarioKardex.ToList() select new { IdUsuarioKardex = s.IdUsuarioKardex, Id = s.IdKardex + "|" + s.Kardex_ctDatosPersonales.Nombre + "|" + s.Kardex_ctDatosPersonales.ApellidoPaterno + "|" + s.Kardex_ctDatosPersonales.ApellidoMaterno }), "IdUsuarioKardex", "Id");
            return View(gruporolaplicacionusuariokardex);
        }

        // GET: /GrupoRolAplicacionUsuarioKardex/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            GrupoRolAplicacionUsuarioKardex gruporolaplicacionusuariokardex = db.GrupoRolAplicacionUsuarioKardex.Find(id);
            if (gruporolaplicacionusuariokardex == null)
            {
                return HttpNotFound();
            }
            return View(gruporolaplicacionusuariokardex);
        }

        // POST: /GrupoRolAplicacionUsuarioKardex/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            GrupoRolAplicacionUsuarioKardex gruporolaplicacionusuariokardex = db.GrupoRolAplicacionUsuarioKardex.Find(id);
            db.GrupoRolAplicacionUsuarioKardex.Remove(gruporolaplicacionusuariokardex);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
