﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class GrupoRolAplicacionEstructuraController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: /GrupoRolAplicacionEstructura/
        public ActionResult Index()
        {
            var gruporolaplicacionestructura = db.GrupoRolAplicacionEstructura.Include(g => g.Catalogos_ctEstructuraOrganica).Include(g => g.Grupo).Include(g => g.GrupoRolAplicacion);
            return View(gruporolaplicacionestructura.ToList());
        }

        // GET: /GrupoRolAplicacionEstructura/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            GrupoRolAplicacionEstructura gruporolaplicacionestructura = db.GrupoRolAplicacionEstructura.Find(id);
            if (gruporolaplicacionestructura == null)
            {
                return HttpNotFound();
            }
            return View(gruporolaplicacionestructura);
        }

        // GET: /GrupoRolAplicacionEstructura/Create
        public ActionResult Create()
        {
            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica");
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1");
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion");
            return View();
        }

        // POST: /GrupoRolAplicacionEstructura/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include="IdGrupoRolAplicacionEstructura,IdGrupo,IdEstructuraOrganica")] GrupoRolAplicacionEstructura gruporolaplicacionestructura)
        {
            if (ModelState.IsValid)
            {
                db.GrupoRolAplicacionEstructura.Add(gruporolaplicacionestructura);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica", gruporolaplicacionestructura.IdEstructuraOrganica);
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1", gruporolaplicacionestructura.IdGrupo);
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion", gruporolaplicacionestructura.IdGrupo);
            return View(gruporolaplicacionestructura);
        }

        // GET: /GrupoRolAplicacionEstructura/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            GrupoRolAplicacionEstructura gruporolaplicacionestructura = db.GrupoRolAplicacionEstructura.Find(id);
            if (gruporolaplicacionestructura == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica", gruporolaplicacionestructura.IdEstructuraOrganica);
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1", gruporolaplicacionestructura.IdGrupo);
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion", gruporolaplicacionestructura.IdGrupo);
            return View(gruporolaplicacionestructura);
        }

        // POST: /GrupoRolAplicacionEstructura/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include="IdGrupoRolAplicacionEstructura,IdGrupo,IdEstructuraOrganica")] GrupoRolAplicacionEstructura gruporolaplicacionestructura)
        {
            if (ModelState.IsValid)
            {
                db.Entry(gruporolaplicacionestructura).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica", gruporolaplicacionestructura.IdEstructuraOrganica);
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1", gruporolaplicacionestructura.IdGrupo);
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion", gruporolaplicacionestructura.IdGrupo);
            return View(gruporolaplicacionestructura);
        }

        // GET: /GrupoRolAplicacionEstructura/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            GrupoRolAplicacionEstructura gruporolaplicacionestructura = db.GrupoRolAplicacionEstructura.Find(id);
            if (gruporolaplicacionestructura == null)
            {
                return HttpNotFound();
            }
            return View(gruporolaplicacionestructura);
        }

        // POST: /GrupoRolAplicacionEstructura/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            GrupoRolAplicacionEstructura gruporolaplicacionestructura = db.GrupoRolAplicacionEstructura.Find(id);
            db.GrupoRolAplicacionEstructura.Remove(gruporolaplicacionestructura);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
