﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class GrupoRolAplicacionCategoriaController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: /GrupoRolAplicacionCategoria/
        public ActionResult Index()
        {
            var gruporolaplicacioncategoria = db.GrupoRolAplicacionCategoria.Include(g => g.Grupo).Include(g => g.Grupo.GrupoRolAplicacion).Include(g => g.Plazas_ctCategoria);
            return View(gruporolaplicacioncategoria.ToList());
        }

        // GET: /GrupoRolAplicacionCategoria/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            GrupoRolAplicacionCategoria gruporolaplicacioncategoria = db.GrupoRolAplicacionCategoria.Find(id);
            if (gruporolaplicacioncategoria == null)
            {
                return HttpNotFound();
            }
            return View(gruporolaplicacioncategoria);
        }

        // GET: /GrupoRolAplicacionCategoria/Create
        public ActionResult Create()
        {
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1");
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion");
            ViewBag.IdCategoria = new SelectList(db.Plazas_ctCategoria, "IdCategoria", "Categoria");
            return View();
        }

        // POST: /GrupoRolAplicacionCategoria/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include="IdGrupoRolAplicacionCategoria,IdGrupo,IdCategoria")] GrupoRolAplicacionCategoria gruporolaplicacioncategoria)
        {
            if (ModelState.IsValid)
            {
                db.GrupoRolAplicacionCategoria.Add(gruporolaplicacioncategoria);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1", gruporolaplicacioncategoria.IdGrupo);
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion", gruporolaplicacioncategoria.IdGrupo);
            ViewBag.IdCategoria = new SelectList(db.Plazas_ctCategoria, "IdCategoria", "Categoria", gruporolaplicacioncategoria.IdCategoria);
            return View(gruporolaplicacioncategoria);
        }

        // GET: /GrupoRolAplicacionCategoria/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            GrupoRolAplicacionCategoria gruporolaplicacioncategoria = db.GrupoRolAplicacionCategoria.Find(id);
            if (gruporolaplicacioncategoria == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1", gruporolaplicacioncategoria.IdGrupo);
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion", gruporolaplicacioncategoria.IdGrupo);
            ViewBag.IdCategoria = new SelectList(db.Plazas_ctCategoria, "IdCategoria", "Categoria", gruporolaplicacioncategoria.IdCategoria);
            return View(gruporolaplicacioncategoria);
        }

        // POST: /GrupoRolAplicacionCategoria/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include="IdGrupoRolAplicacionCategoria,IdGrupo,IdCategoria")] GrupoRolAplicacionCategoria gruporolaplicacioncategoria)
        {
            if (ModelState.IsValid)
            {
                db.Entry(gruporolaplicacioncategoria).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1", gruporolaplicacioncategoria.IdGrupo);
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion", gruporolaplicacioncategoria.IdGrupo);
            ViewBag.IdCategoria = new SelectList(db.Plazas_ctCategoria, "IdCategoria", "Categoria", gruporolaplicacioncategoria.IdCategoria);
            return View(gruporolaplicacioncategoria);
        }

        // GET: /GrupoRolAplicacionCategoria/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            GrupoRolAplicacionCategoria gruporolaplicacioncategoria = db.GrupoRolAplicacionCategoria.Find(id);
            if (gruporolaplicacioncategoria == null)
            {
                return HttpNotFound();
            }
            return View(gruporolaplicacioncategoria);
        }

        // POST: /GrupoRolAplicacionCategoria/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            GrupoRolAplicacionCategoria gruporolaplicacioncategoria = db.GrupoRolAplicacionCategoria.Find(id);
            db.GrupoRolAplicacionCategoria.Remove(gruporolaplicacioncategoria);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
