﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class ControladorAccionsController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: ControladorAccions
        public ActionResult Index()
        {
            var controladorAccion = db.ControladorAccion.Include(c => c.Accion).Include(c => c.Controlador);
            return View(controladorAccion.ToList());
        }

        // GET: ControladorAccions/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ControladorAccion controladorAccion = db.ControladorAccion.Find(id);
            if (controladorAccion == null)
            {
                return HttpNotFound();
            }
            return View(controladorAccion);
        }

        // GET: ControladorAccions/Create
        public ActionResult Create()
        {
            ViewBag.IdAccion = new SelectList(db.Accion.OrderBy(o=>o.Accion1), "IdAccion", "Accion1");
            ViewBag.IdControlador = new SelectList(db.Controlador.OrderBy(o => o.Controlador1), "IdControlador", "Controlador1");
            return View();
        }

        // POST: ControladorAccions/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdControladorAccion,IdControlador,IdAccion,EsMenu,EsVigente,IdPadre,TextoMenu,CssClass,Etiquetas,AyudaTema,AyudaTexto")] ControladorAccion controladorAccion)
        {
            if (ModelState.IsValid)
            {
                db.ControladorAccion.Add(controladorAccion);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdAccion = new SelectList(db.Accion, "IdAccion", "Accion1", controladorAccion.IdAccion);
            ViewBag.IdControlador = new SelectList(db.Controlador, "IdControlador", "Controlador1", controladorAccion.IdControlador);
            return View(controladorAccion);
        }

        // GET: ControladorAccions/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ControladorAccion controladorAccion = db.ControladorAccion.Find(id);
            if (controladorAccion == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdAccion = new SelectList(db.Accion, "IdAccion", "Accion1", controladorAccion.IdAccion);
            ViewBag.IdControlador = new SelectList(db.Controlador, "IdControlador", "Controlador1", controladorAccion.IdControlador);
            return View(controladorAccion);
        }

        // POST: ControladorAccions/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdControladorAccion,IdControlador,IdAccion,EsMenu,EsVigente,IdPadre,TextoMenu,CssClass,Etiquetas,AyudaTema,AyudaTexto")] ControladorAccion controladorAccion)
        {
            if (ModelState.IsValid)
            {
                db.Entry(controladorAccion).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdAccion = new SelectList(db.Accion, "IdAccion", "Accion1", controladorAccion.IdAccion);
            ViewBag.IdControlador = new SelectList(db.Controlador, "IdControlador", "Controlador1", controladorAccion.IdControlador);
            return View(controladorAccion);
        }

        // GET: ControladorAccions/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ControladorAccion controladorAccion = db.ControladorAccion.Find(id);
            if (controladorAccion == null)
            {
                return HttpNotFound();
            }
            return View(controladorAccion);
        }

        // POST: ControladorAccions/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            ControladorAccion controladorAccion = db.ControladorAccion.Find(id);
            db.ControladorAccion.Remove(controladorAccion);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
