﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Script.Serialization;

namespace Nova.Controllers.Acreditacion
{
   
    public class DocentesController : Controller
    {
        //
        // GET: /Docentes/
        public ActionResult Index()
        {
            var resultuado = Docentes.Horarios(889);
            ViewBag.ciclos = resultuado.GroupBy(f => f.CicloEscolar).Select(g => g.Key).ToArray();

            return View(resultuado);
        }

         public ActionResult Asistencia(int id)
        {
            var resultuado = Docentes.AlumnosPorHorario(id);

            ViewBag.id = id;
            return View(resultuado);
        }

         public ActionResult Semana(int id ,string date)
         {
             var resultuado = Docentes.AlumnosPorHorario(id);

             ViewBag.AsistenciasAlumnos = Docentes.AsistenciasAlumnosPorHorario(id);

            // string date = "25/03/2017";
             DateTime dt = Convert.ToDateTime(date);
             int week = (int)dt.DayOfWeek;

             int inicia = -1 * (week - 1);


             //var startDate = DateTime.Today;
             var startDate = dt.AddDays(inicia);
             var endDate = startDate.AddDays(6);
             //Console.WriteLine(inicia);
             //Console.WriteLine(startDate.ToShortDateString());
             //Console.WriteLine(endDate.ToShortDateString());

             List<DateTime> allDates = new List<DateTime>();

             ViewBag.id = id;
             ViewBag.date = date;

             for (DateTime i = startDate; i <= endDate; i = i.AddDays(1))
             {
                 allDates.Add(i);
             }
             ViewBag.Fechas= allDates;


             return PartialView(resultuado);
         }

        [HttpPost]
         public JsonResult GrabaAsistencia(long id, string data)
         {
             //JavaScriptSerializer js = new JavaScriptSerializer();
             //var y = js.Serialize(t);
             var datos = data.Split('|');

             List<HorarioAlumnosSeleccionados> RegistrosAsistencia = new List<HorarioAlumnosSeleccionados>();

             foreach (var item in datos)
             {
                 
                     HorarioAlumnosSeleccionados alumno = new HorarioAlumnosSeleccionados();
                     var ele = item.Split('_');
                     if (ele[0] != "")
                     {
                     alumno.IdHorarioAlumno = Libraries.ConvertToInt.ConvertToInt64(ele[0]);
                     alumno.Fecha = Convert.ToDateTime(ele[1].Substring(0,4)+"/"+ele[1].Substring(4,2)+"/"+ele[1].Substring(6,2));
                     alumno.Seleccionado = ele[3];
                     RegistrosAsistencia.Add(alumno);
                        }
             }

            var r= Docentes.GrabarAsistencia(id,RegistrosAsistencia); 
                
             var t = new { error = false, msg = "Se han grabado las asistencias de los alumnos exitosamente" };
             return Json(t, JsonRequestBehavior.AllowGet);
         }
	}
}