﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Rotativa;
using Nova.Libraries;

using EntityFramework.BulkInsert.Extensions;
using TSHAK;


namespace Aries.Controllers
{

      
    public class AcreditacionController : Controller
    {

        [AllowAnonymous]
          public ActionResult ResetHorarios()
          {
              HorariosAlumnos horarios1 = HorariosAlumnos.Instance;
              horarios1.Reset();
              return View();
          }
        [AllowAnonymous]
        public ActionResult Index(string data, string ms = null)
        {

            try
            {
                TSHAK.Components.SecureQueryString querystringSeguro = new TSHAK.Components.SecureQueryString(new byte[] { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 8 }, data);
                long IdHorario = Convert.ToInt64(querystringSeguro["IdHorario"].ToString());
                ViewBag.SuperUsuario = querystringSeguro["SuperUsuario"].ToString();

                ViewBag.IdHorario = querystringSeguro["IdHorario"].ToString();

                HorariosAlumnos horarios1 = HorariosAlumnos.Instance;

                List<stHorarioAlumno> stHoAl = horarios1.getHorariosAlumnos(IdHorario);
                ViewBag.horarios = stHoAl;

                EvaluacionesdelReglamento reglamento1 = EvaluacionesdelReglamento.Instance;

                ViewBag.reglamento = reglamento1.getReglamento((short)stHoAl.ElementAt(0).stHorario.IdReglamento);


                List<Acreditacion_stMomentoEvaluacionCalificacion> calificacioneshorario = horarios1.getEvaluacionesPorHorario(IdHorario);


                ViewBag.msj = ms;


                ViewBag.calificacioneshorario = calificacioneshorario;
                ViewBag.calificacionesfinales = horarios1.getCalificacionesFinales(calificacioneshorario);


                Evaluar context = new Evaluar((short)stHoAl.ElementAt(0).stHorario.IdReglamento);
                //context.IdHorarioAlumno = 545827;

                //ViewBag.calificacionminima = context.CalificacionMinima;
                //ViewBag.calificacionmaxima = context.CalificacionMaxima;
                ViewBag.CalificacionesPermitidasEvaluacion = context.CalificacionesPermitidasEvaluacion;
            }
            catch (Exception e)
            {

                throw new HttpException((int)System.Net.HttpStatusCode.Forbidden, "No estas autorizado para realizar esta acción");
            }


            return View();

        }

        [AllowAnonymous]
        [HttpPost]
        public ActionResult GrabarCalificaciones([ModelBinder(typeof(ListaCalificaciones))] List<Acreditacion_stMomentoEvaluacionCalificacion> calificaciones)
        {
            short reglamento = System.Convert.ToInt16(Request.Form["reglamento"]);

            Evaluar evaluacion = new Evaluar(reglamento,  calificaciones);
            string msj = "";
            bdAriesEntities basedatos = new bdAriesEntities();
            string SuperUsuario = "";
            string IdHorario = "";

            if (Request.Form["hfstate"] != null)
            {
                SuperUsuario = Request.Form["hfstate"];
                IdHorario = Request.Form["hfhor"];
            }


            MessageBox.Show(ViewData, TipoMensaje.Success, " se actualizaron los siguientes alumnos : " + msj);

            TSHAK.Components.SecureQueryString querystringSeguro = new TSHAK.Components.SecureQueryString(new byte[] { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 8 });


            querystringSeguro["IdHorario"] = IdHorario;
            querystringSeguro["SuperUsuario"] = SuperUsuario;





            return RedirectToAction("Index", "Acreditacion", new { data = querystringSeguro, ms = "1" });
        }



        [AllowAnonymous]

        public ActionResult UpdateCalificacionAlumno(short reglamento, string Curp,Int16 idvalorciclo)
        {
            bdAriesEntities basedatos = new bdAriesEntities();
            List<stHorarioAlumno> horarios = basedatos.stHorarioAlumno.Where(e => e.stHorario.IdReglamento == reglamento && e.IdValorCiclo==idvalorciclo && e.stHorario.Autorizado == true && e.stHorario.IdCicloEscolar == 27 && e.Curp == Curp).ToList();

            foreach (var item in horarios)
            {
                
            
            List<Acreditacion_stMomentoEvaluacionCalificacion> calificaciones = basedatos.Acreditacion_stMomentoEvaluacionCalificacion.Where(e => e.stHorarioAlumno.IdHorarioAlumno == item.IdHorarioAlumno).ToList();

            Evaluar evaluacion = new Evaluar(reglamento, calificaciones);

            }

            MessageBox.Show(ViewData, TipoMensaje.Success, " se actualizaron los siguientes alumnos : ");





            return View();
        }

        [AllowAnonymous]

        public ActionResult UpdateCalificacion(short reglamento, long idHorarioAlumno)
        {
            bdAriesEntities basedatos = new bdAriesEntities();
            List<Acreditacion_stMomentoEvaluacionCalificacion> calificaciones = basedatos.Acreditacion_stMomentoEvaluacionCalificacion.Where(e => e.stHorarioAlumno.IdHorarioAlumno== idHorarioAlumno).ToList();

            Evaluar evaluacion = new Evaluar(reglamento, calificaciones);



            MessageBox.Show(ViewData, TipoMensaje.Success, " se actualizaron los siguientes alumnos : ");





            return View();
        }


        [AllowAnonymous]
        public ActionResult UpdateCalificaciones(short reglamento)
        {
            bdAriesEntities basedatos = new bdAriesEntities();
            basedatos.Database.CommandTimeout = 0;

            List<stHorario> horarios = basedatos.stHorario.Where(e => e.IdReglamento == reglamento && e.Autorizado == true && e.IdCicloEscolar == 27 && e.IdHorario >= 54472).ToList();
            int c = 0;
            int i = 0;
            foreach (var hor in horarios)
            {
                i++;
                List<stHorarioAlumno> hafor = basedatos.stHorarioAlumno.Where(e =>e.IdHorario==hor.IdHorario).ToList();

                foreach (var alu in hafor)
                {
                    List<Acreditacion_stMomentoEvaluacionCalificacion> calificaciones = basedatos.Acreditacion_stMomentoEvaluacionCalificacion.Where(e => e.IdHorarioAlumno==alu.IdHorarioAlumno).ToList();

                    Evaluar evaluacion = new Evaluar(reglamento, calificaciones);
                    c++;
                }
                
            }

            


            MessageBox.Show(ViewData, TipoMensaje.Success, " se actualizaron un total de alumnos : "+c.ToString());





            return View();
        }


        [AllowAnonymous]
        public ActionResult UpdateCalificacionesHorario(short reglamento,long IdHorario)
        {
            bdAriesEntities basedatos = new bdAriesEntities();
            basedatos.Database.CommandTimeout = 0;

            List<stHorario> horarios = basedatos.stHorario.Where(e => e.IdReglamento == reglamento && e.Autorizado == true && e.IdCicloEscolar == 27 && e.IdHorario == IdHorario).ToList();
            int c = 0;
            int i = 0;
            foreach (var hor in horarios)
            {
                i++;
                List<stHorarioAlumno> hafor = basedatos.stHorarioAlumno.Where(e => e.IdHorario == hor.IdHorario).ToList();

                foreach (var alu in hafor)
                {
                    List<Acreditacion_stMomentoEvaluacionCalificacion> calificaciones = basedatos.Acreditacion_stMomentoEvaluacionCalificacion.Where(e => e.IdHorarioAlumno == alu.IdHorarioAlumno).ToList();

                    Evaluar evaluacion = new Evaluar(reglamento, calificaciones);
                    c++;
                }

            }




            MessageBox.Show(ViewData, TipoMensaje.Success, " se actualizaron un total de alumnos : " + c.ToString());





            return View();
        }


        public ActionResult ImprimirCredenciales(Int16 idcampus, Int16 idvalorciclo, Int16 idplanestudio, Int16 idmodalidad, Int16 idcicloescolar, bool todociclos, string campus)
        {

            bdAriesEntities bd = new bdAriesEntities();
            List<spObtenAlumnosCredencialesImpresion2012_Result> model = bd.spObtenAlumnosCredencialesImpresion2012(idcampus, idvalorciclo, idplanestudio, idmodalidad, idcicloescolar, todociclos).ToList();

            var hasta = bd.stCicloEscolar.Where(e => e.IdCicloEscolar == idcicloescolar && e.IdModalidadEstudio == idmodalidad).Select(r => r.Inicio).SingleOrDefault();

            DateTime vigencia = (DateTime)hasta;
            int anio = vigencia.Year;

            int anioactual = DateTime.Now.Year;
            int mes = DateTime.Now.Month;

            if (anio < anioactual)
                anioactual = anio;

            int aniofin = anioactual + 3;

            //if (mes>7)
            //    aniofin = aniofin - 1;

            if (idvalorciclo > 2)
                aniofin = aniofin - 1;

            //if (idvalorciclo >= 4 )
            //    aniofin = aniofin - 1;

            if (idvalorciclo == 6)
                aniofin = DateTime.Now.Year;

            string fechavigencia = "SEP." + anioactual.ToString() + " - " + " AGO. " + aniofin.ToString();
            ViewBag.fechavigencia = fechavigencia;

            string plan = bd.ctPlanEstudio.Where(r => r.IdPlanEstudio == idplanestudio).Select(w => w.Nombre).SingleOrDefault();
            string modalidad = "";
            if (idmodalidad == 1)
            {
                modalidad = "Plantel";
            }
            else
                modalidad = "Emsad";

            modalidad = modalidad + "_" + campus + "_PlanEstudio_" + plan + "_Sem_" + idvalorciclo + "_Fecha_" + DateTime.Now.ToShortDateString();

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 0;
            m.Right = 0;
            m.Top = 85;
            return new ViewAsPdf(model) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
            // return new ViewAsPdf(model) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m};
            //  return View(model);
        }

        [AllowAnonymous]
        public ActionResult getFotografia(string curp)
        {
            byte[] image = getFoto(curp);
            if (image == null)
                return File(StreamHelpers.FromFile("~/App_Themes/Nova/img/user.png"), "image/jpg");
            else

                return File(image, "image/jpg");
        }

        [AllowAnonymous]
        public ActionResult getFotografiaTrabajador(int id)
        {
            byte[] image = getFotoTrabajador(id);
            if (image == null)
                return File(StreamHelpers.FromFile("~/App_Themes/Nova/img/user.png"), "image/jpg");
            else

                return File(image, "image/jpg");
        }

          [AllowAnonymous]
        public static byte[] getFotoTrabajador(int id)
        {
            HorariosAlumnos personal = HorariosAlumnos.Instance;

            byte[] w = null;
            Kardex_ctDatosPersonales v = personal.Kardex_ctDatosPersonales.Where(j => j.IdKardex == id).FirstOrDefault();

                var t= v.Kardex_ctDatosPersonalesFotografias.Where(c=> c.IdKardex==id).FirstOrDefault();
            if (t != null)
                w = t.Fotografia;

            return w;

        }

        public static byte[] getFoto(string curp)
        {
            bdAriesEntities d = new bdAriesEntities();

            byte[] w = d.stAlumnosFotos.Where(a => a.Curp == curp).Select(s => s.Foto).SingleOrDefault();

            return w;

        }

    }
}