﻿using System;
using System.Globalization;
using System.Linq;
using System.Security.Claims;
using System.Threading.Tasks;
using System.Web;
using System.Web.Mvc;
using Microsoft.AspNet.Identity;
using Microsoft.AspNet.Identity.Owin;
using Microsoft.Owin.Security;
using Nova.Models;
using Nova.Libraries;
using System.Web.Security;
using System.Net.Mail;
using System.Net;
using Seguridad;

namespace Nova.Controllers
{
    public class LoginStatus
    {
        public bool Success { get; set; }
        public string Message { get; set; }
        public string TargetURL { get; set; }
       
    }

    [Authorize]
    public class AccountController : Controller
    {
        private ApplicationUserManager _userManager;

        public AccountController()
        {
        }

        public AccountController(ApplicationUserManager userManager, ApplicationSignInManager signInManager )
        {
            UserManager = userManager;
            SignInManager = signInManager;
        }

        public ApplicationUserManager UserManager
        {
            get
            {
                return _userManager ?? HttpContext.GetOwinContext().GetUserManager<ApplicationUserManager>();
            }
            private set
            {
                _userManager = value;
            }
        }

        //
        // GET: /Account/Login
        [AllowAnonymous]
        public ActionResult Login(string returnUrl)
        {
            ViewBag.ReturnUrl = returnUrl;
            return View();
        }

        private ApplicationSignInManager _signInManager;

        public ApplicationSignInManager SignInManager
        {
            get
            {
                return _signInManager ?? HttpContext.GetOwinContext().Get<ApplicationSignInManager>();
            }
            private set { _signInManager = value; }
        }

        //
        // POST: /Account/Login
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> Login(LoginViewModel model, string returnUrl)
        {
            Session["Aplicacion"] = null;
            Session["AplicacionAnterior"] = null;
            Session["IdKardex"] = null;
            Session["MyMenu"] = null;
            Session["ListaSesion"] = null;
            Session["Aut"] = "NOok";
            Session["ControladorAnterior"] = null;
            Session["Roles"] = null;
            Session["Usuario"] = null;

            model.Email=model.Email.Trim();

            //if (!ModelState.IsValid)
            //{
            //    return View(model);
            //}

            // No cuenta los errores de inicio de sesión para el bloqueo de la cuenta
            // Para permitir que los errores de contraseña desencadenen el bloqueo de la cuenta, cambie a shouldLockout: true
            var result = await SignInManager.PasswordSignInAsync(model.Email.Trim(), model.Password, model.RememberMe, shouldLockout: false);
            switch (result)
            {
                case SignInStatus.Success:
                    Session["UserName"] = model.Email;
                    return RedirectToLocal(returnUrl);
                case SignInStatus.LockedOut:
                    return View("Lockout");
                case SignInStatus.RequiresVerification:
                    return RedirectToAction("SendCode", new { ReturnUrl = returnUrl, RememberMe = model.RememberMe });
                case SignInStatus.Failure:
                default:
                    ModelState.AddModelError("", "Intento de inicio de sesión no válido.");
                    return View(model);
            }
        }

        //
        // GET: /Account/VerifyCode
        [AllowAnonymous]
        public async Task<ActionResult> VerifyCode(string provider, string returnUrl, bool rememberMe)
        {
            // Requerir que el usuario haya iniciado sesión con nombre de usuario y contraseña o inicio de sesión externo
            if (!await SignInManager.HasBeenVerifiedAsync())
            {
                return View("Error");
            }
            var user = await UserManager.FindByIdAsync(await SignInManager.GetVerifiedUserIdAsync());
            if (user != null)
            {
                var code = await UserManager.GenerateTwoFactorTokenAsync(user.Id, provider);
            }
            return View(new VerifyCodeViewModel { Provider = provider, ReturnUrl = returnUrl, RememberMe = rememberMe });
        }

        //
        // POST: /Account/VerifyCode
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> VerifyCode(VerifyCodeViewModel model)
        {
            if (!ModelState.IsValid)
            {
                return View(model);
            }

            // El código siguiente protege de los ataques por fuerza bruta a los códigos de dos factores. 
            // Si un usuario introduce códigos incorrectos durante un intervalo especificado de tiempo, la cuenta del usuario 
            // se bloqueará durante un período de tiempo especificado. 
            // Puede configurar el bloqueo de la cuenta en IdentityConfig
            var result = await SignInManager.TwoFactorSignInAsync(model.Provider, model.Code, isPersistent:  model.RememberMe, rememberBrowser: model.RememberBrowser);
            switch (result)
            {
                case SignInStatus.Success:

                    return RedirectToLocal(model.ReturnUrl);
                case SignInStatus.LockedOut:
                    return View("Lockout");
                case SignInStatus.Failure:
                default:
                    ModelState.AddModelError("", "Código no válido.");
                    return View(model);
            }
        }

        //
        // GET: /Account/Register
        [AllowAnonymous]
        public ActionResult Register(string email,int id,string check)
        {
               string codificado = Cifrado.Encrypt(email + id.ToString());
               RegisterViewModel model = new RegisterViewModel();
               if (HttpUtility.UrlDecode(check) == codificado)
               //  if (check == codificado)
               {
                 
                   model.Email = email;
               }
            else
                   throw new  ApplicationException ("La página no es valida");

            return View(model);

        }

        //
        // POST: /Account/Register
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> Register(RegisterViewModel model)
        {
            if (ModelState.IsValid)
            {
                string em = model.Email.ToString();
                var user = new ApplicationUser { UserName = model.Email, Email = model.Email };
                var result = await UserManager.CreateAsync(user, model.Password);
                if (result.Succeeded)
                {
                    await SignInManager.SignInAsync(user, isPersistent:false, rememberBrowser:false);
                    //try
                    //{
                        bdNovaEntities db = new bdNovaEntities();
                        var IdUsuario = from a in db.AspNetUsers
                                        where a.Email == em
                                        select new { a.Id };
                        var IdKardex = from a in db.Kardex_ctDatosPersonales
                                       where a.CorreoElectronico == em
                                       select new { a.IdKardex };
                        Nova.Models.UsuarioKardex us = new Nova.Models.UsuarioKardex();
                        us.Id = IdUsuario.First().Id;
                        us.IdKardex = IdKardex.First().IdKardex;
                        db.UsuarioKardex.Add(us);
                        db.SaveChanges();

                        Identidad.ResetSingleton();
                        
                    //}
                    //catch (Exception e)
                    //{

                    //    throw new Exception(e.InnerException.Message);
                    //}
                    
                    // Para obtener más información sobre cómo habilitar la confirmación de cuenta y el restablecimiento de contraseña, visite http://go.microsoft.com/fwlink/?LinkID=320771
                    // Enviar correo electrónico con este vínculo
                    // string code = await UserManager.GenerateEmailConfirmationTokenAsync(user.Id);
                    // var callbackUrl = Url.Action("ConfirmEmail", "Account", new { userId = user.Id, code = code }, protocol: Request.Url.Scheme);
                    // await UserManager.SendEmailAsync(user.Id, "Confirmar cuenta", "Para confirmar la cuenta, haga clic <a href=\"" + callbackUrl + "\">aquí</a>");

                    return RedirectToAction("Index", "Home");
                }
                AddErrors(result);
            }

            // Si llegamos a este punto, es que se ha producido un error y volvemos a mostrar el formulario
            return View(model);
        }

        //
        // GET: /Account/ConfirmEmail
        [AllowAnonymous]
        public async Task<ActionResult> ConfirmEmail(string userId, string code)
        {
            if (userId == null || code == null)
            {
                return View("Error");
            }
            var result = await UserManager.ConfirmEmailAsync(userId, code);
            return View(result.Succeeded ? "ConfirmEmail" : "Error");
        }

        //
        // GET: /Account/ForgotPassword
        [AllowAnonymous]
        public ActionResult ForgotPassword()
        {
            return View();
        }

        //
        // POST: /Account/ForgotPassword
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> ForgotPassword(ForgotPasswordViewModel model)
        {
            if (ModelState.IsValid)
            {
                var user = await UserManager.FindByNameAsync(model.Email);
                if (user == null )
                    //if (user == null || !(await UserManager.IsEmailConfirmedAsync(user.Id)))
                {
                    // No revelar que el usuario no existe o que no está confirmado
                    return View("NoExisteMail");
                }

                // Para obtener más información sobre cómo habilitar la confirmación de cuenta y el restablecimiento de contraseña, visite http://go.microsoft.com/fwlink/?LinkID=320771
                // Enviar correo electrónico con este vínculo
                string code = await UserManager.GeneratePasswordResetTokenAsync(user.Id);
                var callbackUrl = Url.Action("ResetPassword", "Account", new { userId = user.Id, code = code,email=user.Email }, protocol: Request.Url.Scheme);
                //await UserManager.SendEmailAsync(user.Id, "Restablecer contraseña", "Estimado usuario: Para poder restablecer su  contraseña, haga clic <a href=\"" + callbackUrl + "\">aquí</a>");

                   MailMessage msg = new  MailMessage();

                msg.From = new  MailAddress("sistemas@cecyteo.edu.mx");
                msg.To.Add(user.Email);
                msg.Subject = "Restablecer clave";
                msg.IsBodyHtml = true;
                

                UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);

                

                msg.Body =  "Estimado usuario: Para poder restablecer su  contraseña, haga clic <a href=\"" + callbackUrl + "\">aquí</a>";
                SmtpClient client = new SmtpClient();


                client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
                client.Host = "smtp.gmail.com";
                client.Port = 587;
                client.DeliveryMethod = SmtpDeliveryMethod.Network;
                client.EnableSsl = true;
                // client.UseDefaultCredentials = false;

                try
                {
                    client.Send(msg);
                  
                }
                catch (Exception)
                {
                
                    throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
                }
                

                return RedirectToAction("ForgotPasswordConfirmation", "Account");
            }

            // Si llegamos a este punto, es que se ha producido un error y volvemos a mostrar el formulario
            return View(model);
        }

       

        //
        // GET: /Account/ForgotPasswordConfirmation
        [AllowAnonymous]
        public ActionResult ForgotPasswordConfirmation()
        {
            return View();
        }

        //
        // GET: /Account/ResetPassword
        [AllowAnonymous]
        public ActionResult ResetPassword(string code,string email)
        {
            ViewBag.email = email;
            return code == null ? View("Error") : View();
        }

        //
        // POST: /Account/ResetPassword
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> ResetPassword(ResetPasswordViewModel model)
        {
            if (!ModelState.IsValid)
            {
                return View(model);
            }
            var user = await UserManager.FindByNameAsync(model.Email);
            if (user == null)
            {
                // No revelar que el usuario no existe
                return RedirectToAction("ResetPasswordConfirmation", "Account");
            }
            var code = await UserManager.GeneratePasswordResetTokenAsync(user.Id);
            var result = await UserManager.ResetPasswordAsync(user.Id, code, model.Password);
            if (result.Succeeded)
            {
                return RedirectToAction("ResetPasswordConfirmation", "Account");
            }
            AddErrors(result);
            return View();
        }

        //
        // GET: /Account/ResetPasswordConfirmation
        [AllowAnonymous]
        public ActionResult ResetPasswordConfirmation()
        {
            return View();
        }

        //
        // POST: /Account/ExternalLogin
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public ActionResult ExternalLogin(string provider, string returnUrl)
        {
            // Solicitar redireccionamiento al proveedor de inicio de sesión externo
            return new ChallengeResult(provider, Url.Action("ExternalLoginCallback", "Account", new { ReturnUrl = returnUrl }));
        }

        //
        // GET: /Account/SendCode
        [AllowAnonymous]
        public async Task<ActionResult> SendCode(string returnUrl, bool rememberMe)
        {
            var userId = await SignInManager.GetVerifiedUserIdAsync();
            if (userId == null)
            {
                return View("Error");
            }
            var userFactors = await UserManager.GetValidTwoFactorProvidersAsync(userId);
            var factorOptions = userFactors.Select(purpose => new SelectListItem { Text = purpose, Value = purpose }).ToList();
            return View(new SendCodeViewModel { Providers = factorOptions, ReturnUrl = returnUrl, RememberMe = rememberMe });
        }

        //
        // POST: /Account/SendCode
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> SendCode(SendCodeViewModel model)
        {
            if (!ModelState.IsValid)
            {
                return View();
            }

            // Generar el token y enviarlo
            if (!await SignInManager.SendTwoFactorCodeAsync(model.SelectedProvider))
            {
                return View("Error");
            }
            return RedirectToAction("VerifyCode", new { Provider = model.SelectedProvider, ReturnUrl = model.ReturnUrl, RememberMe = model.RememberMe });
        }

        //
        // GET: /Account/ExternalLoginCallback
        [AllowAnonymous]
        public async Task<ActionResult> ExternalLoginCallback(string returnUrl)
        {
            var loginInfo = await AuthenticationManager.GetExternalLoginInfoAsync();
            if (loginInfo == null)
            {
                return RedirectToAction("Login");
            }

            // Si el usuario ya tiene un inicio de sesión, iniciar sesión del usuario con este proveedor de inicio de sesión externo
            var result = await SignInManager.ExternalSignInAsync(loginInfo, isPersistent: false);
            switch (result)
            {
                case SignInStatus.Success:
                    return RedirectToLocal(returnUrl);
                case SignInStatus.LockedOut:
                    return View("Lockout");
                case SignInStatus.RequiresVerification:
                    return RedirectToAction("SendCode", new { ReturnUrl = returnUrl, RememberMe = false });
                case SignInStatus.Failure:
                default:
                    // Si el usuario no tiene ninguna cuenta, solicitar que cree una
                    ViewBag.ReturnUrl = returnUrl;
                    ViewBag.LoginProvider = loginInfo.Login.LoginProvider;
                    return View("ExternalLoginConfirmation", new ExternalLoginConfirmationViewModel { Email = loginInfo.Email });
            }
        }

        //
        // POST: /Account/ExternalLoginConfirmation
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> ExternalLoginConfirmation(ExternalLoginConfirmationViewModel model, string returnUrl)
        {
            if (User.Identity.IsAuthenticated)
            {
                return RedirectToAction("Index", "Manage");
            }

            if (ModelState.IsValid)
            {
                // Obtener datos del usuario del proveedor de inicio de sesión externo
                var info = await AuthenticationManager.GetExternalLoginInfoAsync();
                if (info == null)
                {
                    return View("ExternalLoginFailure");
                }
                var user = new ApplicationUser { UserName = model.Email, Email = model.Email };
                var result = await UserManager.CreateAsync(user);
                if (result.Succeeded)
                {
                    result = await UserManager.AddLoginAsync(user.Id, info.Login);
                    if (result.Succeeded)
                    {
                        await SignInManager.SignInAsync(user, isPersistent: false, rememberBrowser: false);
                        return RedirectToLocal(returnUrl);
                    }
                }
                AddErrors(result);
            }

            ViewBag.ReturnUrl = returnUrl;
            return View(model);
        }

        //
        // POST: /Account/LogOff
         [AllowAnonymous]
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult LogOff()
        {
            AuthenticationManager.SignOut();
            return RedirectToAction("Login", "Account");
        }

        //
        // GET: /Account/ExternalLoginFailure
        [AllowAnonymous]
        public ActionResult ExternalLoginFailure()
        {
            return View();
        }

 

        [HttpPost]
        [AllowAnonymous]
        public JsonResult ValidateUser(string email)
        {
            email = email.Trim();
            LoginStatus status = new LoginStatus();
            bdNovaEntities bd = new bdNovaEntities();
            Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria trabajador = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(b => (b.Convenios_stConvenioLaboralTrabajador.FechaTermino >= System.DateTime.Now || b.Convenios_stConvenioLaboralTrabajador.FechaTermino == null) &&  b.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.CorreoElectronico.ToLower() == email).FirstOrDefault();

            bdNovaEntities db = new bdNovaEntities();
            var IdUsuario = from a in db.AspNetUsers
                            where a.Email == email
                            select new { a.Id };
            
            
            

            if (trabajador == null)
            {
                  status.Message= "No existe este correo electrónico en nuestra base de datos ";
                  status.Success = false;
            }
            else
                //if (trabajador.EsCancelado == true  || (trabajador.FechaTermino != null &&  DateTime.Now > trabajador.FechaTermino ))
                //{
                //    status.Message = "Esta cuenta ya no esta vigente, no podemos reactivarla";
                //    status.Success = false;
                //}
                //else
                    if (IdUsuario.Count()>0)
                    {
                        status.Message = "Esta cuenta ya esta activada,  puede restablecer su contraseña si tiene problemas para entrar al sistema";
                        status.Success = false;
                    }
else
                if (EnviarEmailActivacion(email,trabajador.Convenios_stConvenioLaboralTrabajador.IdTrabajador))
                {
                    status.Message = "Se ha enviado un mail a la siguiente direccíon: " + email + " , revise su bandeja de entrada en unos minutos y siga las instrucciones para poder activar su cuenta (IMPORTANTE: revise también su bandeja de spam o correo no deseado)";
                    status.Success = true;
                    status.TargetURL = FormsAuthentication.LoginUrl;
                }
                else
                {
                    status.Message = "No se ha podido enviar el email a su cuenta por favor intente más tarde";
                    status.Success = false;
                }
                
            
                
            
           
            return Json(status);
        }

        private bool EnviarEmailActivacion(string email,int id)
        {
            bool regresa = true;
               MailMessage msg = new  MailMessage();

                msg.From = new  MailAddress("sistemas@cecyteo.edu.mx");
                msg.To.Add(email);
                msg.Subject = "Activación de cuenta CECYTEO";
                msg.IsBodyHtml = true;
                string codificado = Cifrado.Encrypt(email + id.ToString());

                UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);

                string url = HttpContext.Request.Url.Scheme + "://" + HttpContext.Request.Url.Authority + u.Action("Register", "Account", new { email = email, id = id, check = HttpUtility.UrlEncode(codificado) });

                msg.Body = @"<html xmlns='http://www.w3.org/1999/xhtml'>
<head>

    <!-- Define Charset -->
    <meta http-equiv='Content-Type' content='text/html; charset=utf-8'>
    <!-- Responsive Meta Tag -->
    <meta name='viewport' content='width=device-width; initial-scale=1.0; maximum-scale=1.0;'>
    <!-- Facebook sharing information tags -->
    
    <title>Activacion de cuenta</title>

    <link href='http://fonts.googleapis.com/css?family=Source+Sans+Pro:200,300,400' rel='stylesheet' type='text/css'>


    <style type='text/css' data-premailer='ignore'>
        /* iPad Text Smoother */
        div, p, a, li, td {
            -webkit-text-size-adjust: none;
        }

        .ReadMsgBody {
            width: 100%;
            background-color: #ffffff;
        }

        .ExternalClass {
            width: 100%;
            background-color: #ffffff;
        }

        body {
            width: 100%;
            background-color: #ffffff;
            margin: 0;
            padding: 0;
            -webkit-font-smoothing: antialiased;
            text-align: left;
        }

        html {
            width: 100%;
        }

        img {
            border: 0px;
            outline: none;
            text-decoration: none;
            display: block;
        }

        a img {
            border: none;
        }

        a {
            color: inherit;
            text-decoration: none;
            text-align: inherit;
        }

        .Rounded_Bottom {
            border-bottom-left-radius: 3px;
            -webkit-border-bottom-left-radius: 3px;
            -moz-border-radius-bottomleft: 3px;
            border-bottom-right-radius: 3px;
            -webkit-border-bottom-right-radius: 3px;
            -moz-border-radius-bottomright: 3px;
        }

        .Rounded_Top {
            border-top-left-radius: 3px;
            -webkit-border-top-left-radius: 3px;
            -moz-border-radius-topleft: 3px;
            border-top-right-radius: 3px;
            -webkit-border-top-right-radius: 3px;
            -moz-border-radius-topright: 3px;
        }

        .Text_H1 {
            font-family: 'Source Sans Pro', sans-serif;
            font-size: 36px;
            letter-spacing: -1px;
            font-weight: 400;
            font-style: normal;
          
            color: #222427;
            line-height: 120%;
            text-align: left;
        }

        .Text_H2 {
            font-family: 'Source Sans Pro', sans-serif;
            font-size: 24px;
            letter-spacing: -1px;
            font-weight: 400;
            font-style: normal;
          
            color: #222427;
            line-height: 150%;
            text-align: left;
        }

        .Text_H3 {
            font-family: 'Source Sans Pro', sans-serif;
            font-size: 14px;
            letter-spacing: 0px;
            font-weight: 400;
            font-style: normal;
            text-decoration: none;
          
            color: #656d78;
            line-height: 175%;
            text-align: left;
        }

        .Text_H4 {
            font-family: sans-serif;
            
            font-weight: normal;
            font-style: normal;
            text-decoration: none;
            text-transform: uppercase;
            color: #DBDBDB;
            line-height: 200%;
            text-align: left;
        }

        .btn-style {
          border-color: #B3B1B1;
             border-width: 1px;
            border-style: solid;
            border-radius: 4px;
            moz-border-radius: 4px;
        }

        .plan-style {
            border-color: #ffffff;
            border-width: 1px;
            border-style: solid;
        }

        .border-style {
            border-color: #ffffff;
            border-width: 7px;
            border-style: solid;
        }
        /*-------------------------------------- Responsive 600px PC Attributes --------------------------------------*/
        @media only screen and (max-width: 900px) {
            body {
                width: auto !important;
            }
            /* Responsive Wrappers  */
            .BoxWrap {
                width: 600px !important;
            }

            .BookLeft {
                width: 300px !important;
            }

            .BookRight {
                width: 280px !important;
            }

            .Respo1Column {
                width: 560px !important;
            }

            .Respo2Column {
                width: 270px !important;
            }

            .Respo3Column {
                width: 560px !important;
            }
            /* Responsive Images  */
            .RespoImage1Col {
                width: 600px !important;
                height: auto !important;
            }

            .RespoImage1ColW Img {
                width: 600px !important;
                height: auto !important;
            }

            .RespoImage2Col {
                width: 270px !important;
                height: auto !important;
            }

            .RespoImage2ColW Img {
                width: 270px !important;
                height: auto !important;
            }

            .RespoImage3Col {
                width: 560px !important;
                height: auto !important;
            }

            .RespoImage3ColW Img {
                width: 560px !important;
                height: auto !important;
            }
            /* Responsive Images with Padding */
            .RespoImage1ColPadding {
                width: 560px !important;
                height: auto !important;
            }

            .RespoImage1ColPaddingW Img {
                width: 560px !important;
                height: auto !important;
            }
            /* Responsive Framed Images */
            .RespoImage2ColFramed {
                width: 264px !important;
                height: auto !important;
            }

            .RespoImage2ColFramedW Img {
                width: 264px !important;
                height: auto !important;
            }

            .RespoImage3ColFramed {
                width: 554px !important;
                height: auto !important;
            }

            .RespoImage3ColFramedW Img {
                width: 554px !important;
                height: auto !important;
            }
            /* Show/Hide  */
            .respo-margin {
                width: 20px !important;
            }

            .respo-hide-pc {
                display: none !important;
            }

            .respo-show-pc {
                display: block !important;
            }
            /* General  */
            .respo-text-left {
                text-align: left !important;
            }

            .respo-center-pc {
                text-align: center !important;
            }
        }

        /*-------------------------------------- Responsive 440px Tablet Attributes --------------------------------------*/
        @media only screen and (max-width: 640px) {
            body {
                width: auto !important;
            }
            /* Responsive Wrappers  */
            .BoxWrap {
                width: 440px !important;
            }

            .BookLeft {
                width: 440px !important;
            }

            .BookRight {
                width: 440px !important;
            }

            .Respo1Column {
                width: 420px !important;
            }

            .Respo2Column {
                width: 400px !important;
            }

            .Respo3Column {
                width: 400px !important;
            }

            .RespoTabletWidth {
                width: 400px !important;
            }

            .Respo2ColumnTablet {
                width: 400px !important;
            }
            /* Responsive Images  */
            .RespoImage1Col {
                width: 440px !important;
                height: auto !important;
            }

            .RespoImage1ColW Img {
                width: 440px !important;
                height: auto !important;
            }

            .RespoImage2Col {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage2ColW Img {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage3Col {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage3ColW Img {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage3ColTablet {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage3ColWTablet Img {
                width: 400px !important;
                height: auto !important;
            }
            /* Responsive Images with Padding */
            .RespoImage1ColPadding {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage1ColPaddingW Img {
                width: 400px !important;
                height: auto !important;
            }
            /* Responsive Framed Images */
            .RespoImage2ColFramed {
                width: 394px !important;
                height: auto !important;
            }

            .RespoImage2ColFramedW Img {
                width: 394px !important;
                height: auto !important;
            }

            .RespoImage3ColFramed {
                width: 394px !important;
                height: auto !important;
            }

            .RespoImage3ColFramedW Img {
                width: 394px !important;
                height: auto !important;
            }
            /* Responsive Tablet and Mobile Only */
            .RespoImage2ColTablet {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage2ColTabletW Img {
                width: 400px !important;
                height: auto !important;
            }
            /* Show/Hide  */
            .respo-hide-tablet {
                display: none !important;
            }

            .respo-show-tablet {
                display: block !important;
            }
            /* Responsive Text Align & Size */
            .Text_H1 {
                font-size: 36px !important;
                line-height: 125% !important;
            }

            .Text_H2 {
                font-size: 36px !important;
                line-height: 140% !important;
            }

            .Text_H3 {
                font-size: 14px !important;
                line-height: 150% !important;
                font-weight: normal !important;
            }

            .Text_H4 {
                font-size: 15px !important;
                line-height: 150% !important;
                font-weight: normal !important;
            }

            .respo-center-tablet {
                text-align: center !important;
            }

            .respo-spacer {
                height: 200px !important;
            }
        }

        /*-------------------------------------- Responsive 280px Mobile Attributes --------------------------------------*/
        @media only screen and (max-width: 480px) {
            body {
                width: auto !important;
            }
            /* Responsive Wrappers  */
            .BoxWrap {
                width: 280px !important;
            }

            .BookLeft {
                width: 280px !important;
            }

            .BookRight {
                width: 280px !important;
            }

            .Respo1Column {
                width: 260px !important;
            }

            .Respo2Column {
                width: 240px !important;
            }

            .Respo3Column {
                width: 240px !important;
            }

            .RespoTabletWidth {
                width: 240px !important;
            }

            .Respo2ColumnTablet {
                width: 240px !important;
            }
            /* Responsive Images  */
            .RespoImage1Col {
                width: 280px !important;
                height: auto !important;
            }

            .RespoImage1ColW Img {
                width: 280px !important;
                height: auto !important;
            }

            .RespoImage2Col {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage2ColW Img {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage3Col {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage3ColW Img {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage3ColTablet {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage3ColWTablet Img {
                width: 240px !important;
                height: auto !important;
            }
            /* Responsive Images with Padding */
            .RespoImage1ColPadding {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage1ColPaddingW Img {
                width: 240px !important;
                height: auto !important;
            }
            /* Responsive Framed Images */
            .RespoImage2ColFramed {
                width: 234px !important;
                height: auto !important;
            }

            .RespoImage2ColFramedW Img {
                width: 234px !important;
                height: auto !important;
            }

            .RespoImage3ColFramed {
                width: 234px !important;
                height: auto !important;
            }

            .RespoImage3ColFramedW Img {
                width: 234px !important;
                height: auto !important;
            }
            /* Responsive Tablet and Mobile Only */
            .RespoImage2ColTablet {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage2ColTabletW Img {
                width: 240px !important;
                height: auto !important;
            }
            /* Show/Hide  */
            .respo-hide-mobile {
                display: none !important;
            }
            /* Responsive Text Align & Size */
            .Text_H1 {
                font-size: 24px !important;
                line-height: 125% !important;
            }

            .Text_H2 {
                font-size: 24px !important;
                line-height: 140% !important;
            }

            .Text_H3 {
                font-size: 18px !important;
                line-height: 150% !important;
                font-weight: normal !important;
            }

            .Text_H4 {
                font-size: 11px !important;
                line-height: 150% !important;
                font-weight: normal !important;
            }

            .respo-center-mobile {
                text-align: center !important;
            }

            .respo-spacer {
                height: 100px !important;
            }
        }
    </style>


</head>
<body>

    <!-- ********************************************************************************************************* -->
    <!-- Begin Module: 1 Column | NoPadding | NoBreak -->
    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        <tbody>
            <tr>
                <td align='center'>
                    <table class='BoxWrap' width='800' align='center' cellpadding='0' cellspacing='0'>
                        <tbody>
                            <tr>
                                <td height='20'></td>
                            </tr>
                            <tr>
                                <td>
                                    <table width='100%' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td class='Text_H3' style='text-align:center; color:#ffffff!important;' mc:edit='Text_H31'>
                                                    <span><i> </i></span>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                            </tr>
                            <tr>
                                <td height='20'></td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
            <!-- End Module: 1 Column | NoPadding | NoBreak -->
        </tbody>
    </table>

    <!-- ********************************************************************************************************* -->
    <!-- Begin Module: 2 Column | Padding | BreakOnPC -->
    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        <tbody>
            <tr>
                <td align='center'>
                    <table class='BoxWrap BackgroundColor05 Rounded_Top' bgcolor='#DBDBDB' width='800' align='center' cellpadding='0' cellspacing='0'>
                        <tbody>
                            <tr>
                                <td colspan='3' width='100%' height='20'></td>
                            </tr>
                            <tr>
                                <td width='120' class='respo-margin'></td>
                                <td width='560'>
                                    <!-- // Begin: First Column \\ -->
                                    <table class='Respo1Column' align='left' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td width='75' class='Respo1Column' align='center' valign='top'>
                                                    <img mc:edit='' src='http://www.cecyteo.edu.mx/Nova/img/logocecyte.png' alt=' ' border=' 0' style='width: 75px; display: block;'>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <!-- // End: First Column \\ -->
                                    <!-- ************************** -->
                                    <!-- // Begin: Second Column \\ -->
                                    <table class='Respo1Column' align='right' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <table align='center' cellpadding='0' cellspacing='0'>
                                                        <tbody>
                                                            <tr>
                                                                <td class='Text_H3' style='line-height:50px!important; color:#ffffff!important;' mc:edit='Text_H32'>
                                                                    
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <!-- // End: Second Column \\ -->
                                </td>
                                <td width='120' class='respo-margin'></td>
                            </tr>
                            <tr>
                                <td colspan='3' width='100%' height='20'></td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
            <!-- End Module: 2 Column | Padding | BreakOnPC -->
        </tbody>
    </table>

    <!-- ********************************************************************************************************* -->
    <!-- Begin Module: Caption - One Column Segment -->
    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        <tbody>
            <tr>
                <td align='center'>
                    <table class='BoxWrap fixed-bg-style BackgroundColor01' bgcolor='#ffffff' width='800' align='center' cellpadding='0' cellspacing='0'>
                        <tbody>
                            <tr>
                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
                            </tr>
                            <tr>
                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
                            </tr>
                            <tr>
                                <td width='120' class='respo-margin'></td>
                                <td class='RespoTabletWidth' width='560'>
                                    <table width='100%' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td class='Text_H1' style='text-align:center;' mc:edit='Text_H13'>
                                                    <span>Ha solicitado la activación de su cuenta para ingresar al sistema NOVA del CECyTEO</span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td width='100%' height='5'></td>
                                            </tr>
                                            <tr>
                                                <td class='Text_H3' style='text-align:center;' mc:edit='Text_H34'>
                                                    <span>Esta cuenta es de uso personal e intransferible</span>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                                <td width='120' class='respo-margin'></td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </tbody>
    </table>
 
    <!-- Begin Module: Paragraph - One Column Segment -->
    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        <tbody>
            <tr>
                <td align='center'>
                    <table class='BoxWrap fixed-bg-style BackgroundColor05' bgcolor='#DBDBDB' width='800' align='center' cellpadding='0' cellspacing='0'>
                        <tbody>
                            <tr>
                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
                            </tr>
                            <tr>
                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
                            </tr>
                            <tr>
                                <td width='120' class='respo-margin'></td>
                                <td class='RespoTabletWidth' width='560'>
                                    <table width='100%' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td class='Text_H1 respo-center-tablet' style='color:#ffffff!important; text-align:center;' mc:edit='Text_H117'>
                                                   
                                                </td>
                                            </tr>
                                            <tr>
                                                <td height='20'>&nbsp;</td>
                                            </tr>
                                            <!-- Button -->
                                            <tr>
                                                <td width='100%' align='center'>
                                                    <table class='BackgroundColor05 btn-style RespoTabletWidth' bgcolor='#DBDBDB' align='center' cellpadding='7' cellspacing='0' style='border-radius:4px;'>
                                                        <tbody style='background-color: #82BA00;'>
                                                            <tr>
                                                                <td>&nbsp; </td>
                                                                <td class='Text_H4' style='text-align: center; color:#ffffff; vertical-align: middle; text-transform:uppercase;' mc:edit='Text_H418'>
                                                                    <span style='color:#ffffff;'><a href='" + url + @"' style='text-align: center; color:#ffffff; vertical-align: middle; text-transform:uppercase;'>Activar</a></span>
                                                                </td>
                                                                <td>&nbsp; </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                                <td width='120' class='respo-margin'></td>
                            </tr>
                            <tr>
                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
                            </tr>
                            <tr>
                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </tbody>
    </table>
    <!-- End Module: Paragraph - One Column Segment -->
    <!-- ********************************************************************************************************* -->
    <!-- Begin Module: 2 Column | Padding | BreakOnPC -->
    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        <tbody>
            <tr>
                <td align='center'>
                    <table class='BoxWrap BackgroundColor01 Rounded_Bottom' bgcolor='#ffffff' width='800' align='center' cellpadding='0' cellspacing='0'>
                        <tbody>
                            <tr>
                                <td colspan='3' width='100%' height='20'></td>
                            </tr>
                            <tr>
                                <td width='120' class='respo-margin'></td>
                                <td width='560'>
                                    <!-- // Begin: First Column \\ -->
                                    <table class='Respo1Column' align='left' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <table align='center' cellpadding='0' cellspacing='0'>
                                                        <tbody>
                                                            <tr>
                                                                <td class='Text_H3' style='line-height:50px!important; text-align:center;' mc:edit='Text_H319'>
                                                                    <span>Departamento de Sistemas - " + DateTime.Now.Year + @" </span>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <!-- // End: First Column \\ -->
                                    <!-- ************************** -->
                                    <!-- // Begin: Second Column \\ -->
                                    <table class='Respo1Column' align='right' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <table align='center' cellpadding='0' cellspacing='0'>
                                                        <tbody>
                                                            <tr>
                                                                <td class='Text_H3' style='line-height:50px!important; text-align:center;' mc:edit='Text_H320'>
                                                                    <span><a href='http://www.cecyteo.edu.mx'>www.cecyteo.edu.mx</a></span>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <!-- // End: Second Column \\ -->
                                </td>
                                <td width='120' class='respo-margin'></td>
                            </tr>
                            <tr>
                                <td colspan='3' width='100%' height='20'></td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
            <!-- End Module: 2 Column | Padding | BreakOnPC -->
        </tbody>
    </table>

    <!-- ********************************************************************************************************* -->
    <!-- Begin Module: 1 Column | NoPadding | NoBreak -->
    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        <tbody>
            <tr>
                <td align='center'>
                    <table class='BoxWrap' width='800' align='center' cellpadding='0' cellspacing='0'>
                        <tbody>
                            <tr>
                                <td height='20'></td>
                            </tr>
                            <tr>
                                <td height='20'></td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
            <!-- End Module: 1 Column | NoPadding | NoBreak -->
        </tbody>
    </table>


</body>
</html>";
                //msg.Body = "<p>Estimado Trabajador</p><strong></strong><p>Para activar su cuenta para acceso al sistema NOVA del CECYTEO de clic en la siguiente liga <a href='" + url + "'>clic aquí</a> ";

                //msg.Body = msg.Body + " <p></p><p><strong>Cualquier duda o aclaración con este proceso favor de dirigirse con el Departamento de Sistemas a los teléfonos : (951) 666-666  ext. 666 de 08:00 a 16:00 horas de Lunes a Viernes.</strong></p> ";

                //msg.Body = msg.Body + " <p></p><p>Este correo fue generado automáticamente, favor de no responder.</p>";


                //  msg.Priority = MailPriority.High;

                SmtpClient client = new SmtpClient();


                client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
                client.Host = "smtp.gmail.com";
                client.Port = 587;
                client.DeliveryMethod = SmtpDeliveryMethod.Network;
                client.EnableSsl = true;
                // client.UseDefaultCredentials = false;

                try
                {
                    client.Send(msg);
                  
                }
                catch (Exception)
                {
                regresa = false;
                   // throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
                }
                return regresa;
        }

        #region Aplicaciones auxiliares
        // Se usa para la protección XSRF al agregar inicios de sesión externos
        private const string XsrfKey = "XsrfId";

        private IAuthenticationManager AuthenticationManager
        {
            get
            {
                return HttpContext.GetOwinContext().Authentication;
            }
        }

        private void AddErrors(IdentityResult result)
        {
            foreach (var error in result.Errors)
            {
                ModelState.AddModelError("", error);
            }
        }

        private ActionResult RedirectToLocal(string returnUrl)
        {
            if (Url.IsLocalUrl(returnUrl))
            {
                return Redirect(returnUrl);
            }
            return RedirectToAction("Index", "Home");
        }

        internal class ChallengeResult : HttpUnauthorizedResult
        {
            public ChallengeResult(string provider, string redirectUri)
                : this(provider, redirectUri, null)
            {
            }

            public ChallengeResult(string provider, string redirectUri, string userId)
            {
                LoginProvider = provider;
                RedirectUri = redirectUri;
                UserId = userId;
            }

            public string LoginProvider { get; set; }
            public string RedirectUri { get; set; }
            public string UserId { get; set; }

            public override void ExecuteResult(ControllerContext context)
            {
                var properties = new AuthenticationProperties { RedirectUri = RedirectUri };
                if (UserId != null)
                {
                    properties.Dictionary[XsrfKey] = UserId;
                }
                context.HttpContext.GetOwinContext().Authentication.Challenge(properties, LoginProvider);
            }
        }
        #endregion
    }
}