﻿using System;
using System.Globalization;
using System.Linq;
using System.Security.Claims;
using System.Threading.Tasks;
using System.Web;
using System.Web.Mvc;
using Microsoft.AspNet.Identity;
using Microsoft.AspNet.Identity.Owin;
using Microsoft.Owin.Security;
using Nova.Models;
using Nova.Libraries;
using System.Web.Security;
using System.Net.Mail;
using System.Net;
using Seguridad;
using Nova.Models.Estatus;
using Nova.Models.Correo;

namespace Nova.Controllers
{
    public class LoginStatus
    {
        public bool Success { get; set; }
        public string Message { get; set; }
        public string TargetURL { get; set; }
       
    }

    [Authorize]
    public class TrabajadoresController : Controller
    {
        private ApplicationUserManager _userManager;

        public TrabajadoresController()
        {
        }

        public TrabajadoresController(ApplicationUserManager userManager, ApplicationSignInManager signInManager )
        {
            UserManager = userManager;
            SignInManager = signInManager;
        }

        public ApplicationUserManager UserManager
        {
            get
            {
                return _userManager ?? HttpContext.GetOwinContext().GetUserManager<ApplicationUserManager>();
            }
            private set
            {
                _userManager = value;
            }
        }

        //
        // GET: /Account/Login
        [AllowAnonymous]
        public ActionResult Login(string returnUrl)
        {
            ViewBag.ReturnUrl = returnUrl;
            return View();
        }

        private ApplicationSignInManager _signInManager;

        public ApplicationSignInManager SignInManager
        {
            get
            {
                return _signInManager ?? HttpContext.GetOwinContext().Get<ApplicationSignInManager>();
            }
            private set { _signInManager = value; }
        }

        //
        // POST: /Account/Login
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> Login(LoginViewModel model, string returnUrl)
        {
            if (!ModelState.IsValid)
            {
                return View(model);
            }

            Session["Aplicacion"] = null;
            Session["AplicacionAnterior"] = null;
            Session["IdKardex"] = null;
            Session["MyMenu"] = null;
            Session["ListaSesion"] = null;
            Session["Aut"] = "NOok";
            Session["ControladorAnterior"] = null;
            Session["Roles"] = null;
            Session["Usuario"] = null;
             //if (!ModelState.IsValid)
            //{
            //    return View(model);
            //}
            model.Email=model.Email.Trim();


            bdNovaEntities bd = new bdNovaEntities();
            var usuarioactivo = bd.vwDatosAspirantesTrabajadores.Where(s => s.CorreoElectronico == model.Email && s.EstatusTrabajador =="ALTA").FirstOrDefault();
            bool conpermiso = true;
            
            if (usuarioactivo == null)
                conpermiso = false;
            else
            {
                if (usuarioactivo.EstatusTrabajador != "ALTA")
                    conpermiso = false;
            }

            if (!conpermiso)
            {
                
                ModelState.AddModelError("", "El acceso es solo para trabajadores activos.");
                return View(model);
            }


            // No cuenta los errores de inicio de sesión para el bloqueo de la cuenta
            // Para permitir que los errores de contraseña desencadenen el bloqueo de la cuenta, cambie a shouldLockout: true
            var result = await SignInManager.PasswordSignInAsync(model.Email.Trim(), model.Password, model.RememberMe, shouldLockout: false);
            switch (result)
            {
                case SignInStatus.Success:
                    Session["UserName"] = model.Email;
                    return RedirectToLocal(returnUrl);
                case SignInStatus.LockedOut:
                    return View("Lockout");
                case SignInStatus.RequiresVerification:
                    return RedirectToAction("SendCode", new { ReturnUrl = returnUrl, RememberMe = model.RememberMe });
                case SignInStatus.Failure:
                default:
                    ModelState.AddModelError("", "Intento de inicio de sesión no válido.");
                    return View(model);
            }
        }

        //
        // GET: /Account/VerifyCode
        [AllowAnonymous]
        public async Task<ActionResult> VerifyCode(string provider, string returnUrl, bool rememberMe)
        {
            // Requerir que el usuario haya iniciado sesión con nombre de usuario y contraseña o inicio de sesión externo
            if (!await SignInManager.HasBeenVerifiedAsync())
            {
                return View("Error");
            }
            var user = await UserManager.FindByIdAsync(await SignInManager.GetVerifiedUserIdAsync());
            if (user != null)
            {
                var code = await UserManager.GenerateTwoFactorTokenAsync(user.Id, provider);
            }
            return View(new VerifyCodeViewModel { Provider = provider, ReturnUrl = returnUrl, RememberMe = rememberMe });
        }

        //
        // POST: /Account/VerifyCode
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> VerifyCode(VerifyCodeViewModel model)
        {
            if (!ModelState.IsValid)
            {
                return View(model);
            }

            // El código siguiente protege de los ataques por fuerza bruta a los códigos de dos factores. 
            // Si un usuario introduce códigos incorrectos durante un intervalo especificado de tiempo, la cuenta del usuario 
            // se bloqueará durante un período de tiempo especificado. 
            // Puede configurar el bloqueo de la cuenta en IdentityConfig
            var result = await SignInManager.TwoFactorSignInAsync(model.Provider, model.Code, isPersistent:  model.RememberMe, rememberBrowser: model.RememberBrowser);
            switch (result)
            {
                case SignInStatus.Success:

                    return RedirectToLocal(model.ReturnUrl);
                case SignInStatus.LockedOut:
                    return View("Lockout");
                case SignInStatus.Failure:
                default:
                    ModelState.AddModelError("", "Código no válido.");
                    return View(model);
            }
        }

        //
        // GET: /Account/Register
        [AllowAnonymous]
        public ActionResult Register(string email,int id,string check)
        {
               string codificado = Cifrado.Encrypt(email + id.ToString());
               RegisterViewModel model = new RegisterViewModel();
               if (HttpUtility.UrlDecode(check) == codificado)
               //  if (check == codificado)
               {
                 
                   model.Email = email;
               }
            else
                   throw new  ApplicationException ("La página no es valida");

            return View(model);

        }

        //
        // POST: /Account/Register
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> Register(RegisterViewModel model)
        {
            if (ModelState.IsValid)
            {
                string em = model.Email.ToString();
                var user = new ApplicationUser { UserName = model.Email, Email = model.Email };
                var result = await UserManager.CreateAsync(user, model.Password);
                if (result.Succeeded)
                {
                    await SignInManager.SignInAsync(user, isPersistent:false, rememberBrowser:false);
                    //try
                    //{
                        bdNovaEntities db = new bdNovaEntities();
                        var IdUsuario = from a in db.AspNetUsers
                                        where a.Email == em
                                        select new { a.Id };
                        var IdKardex = from a in db.Kardex_ctDatosPersonales
                                       where a.CorreoElectronico == em
                                       select new { a.IdKardex };
                        Nova.Models.UsuarioKardex us = new Nova.Models.UsuarioKardex();
                        us.Id = IdUsuario.First().Id;
                        us.IdKardex = IdKardex.First().IdKardex;
                        db.UsuarioKardex.Add(us);
                        db.SaveChanges();

                        Identidad.ResetSingleton();
                        
                    //}
                    //catch (Exception e)
                    //{

                    //    throw new Exception(e.InnerException.Message);
                    //}
                    
                    // Para obtener más información sobre cómo habilitar la confirmación de cuenta y el restablecimiento de contraseña, visite http://go.microsoft.com/fwlink/?LinkID=320771
                    // Enviar correo electrónico con este vínculo
                    // string code = await UserManager.GenerateEmailConfirmationTokenAsync(user.Id);
                    // var callbackUrl = Url.Action("ConfirmEmail", "Account", new { userId = user.Id, code = code }, protocol: Request.Url.Scheme);
                    // await UserManager.SendEmailAsync(user.Id, "Confirmar cuenta", "Para confirmar la cuenta, haga clic <a href=\"" + callbackUrl + "\">aquí</a>");

                    return RedirectToAction("Index", "Home");
                }
                AddErrors(result);
            }

            // Si llegamos a este punto, es que se ha producido un error y volvemos a mostrar el formulario
            return View(model);
        }

        //
        // GET: /Account/ConfirmEmail
        [AllowAnonymous]
        public async Task<ActionResult> ConfirmEmail(string userId, string code)
        {
            if (userId == null || code == null)
            {
                return View("Error");
            }
            var result = await UserManager.ConfirmEmailAsync(userId, code);
            return View(result.Succeeded ? "ConfirmEmail" : "Error");
        }

        //
        // GET: /Account/ForgotPassword
        [AllowAnonymous]
        public ActionResult ForgotPassword()
        {
            return View();
        }


        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<JsonResult> ForgotPassword(ForgotPasswordViewModel model)
        {
            if (ModelState.IsValid)
            {
                var user = await UserManager.FindByNameAsync(model.Email);
                if (user == null)
                //if (user == null || !(await UserManager.IsEmailConfirmedAsync(user.Id)))
                {
                    // No revelar que el usuario no existe o que no está confirmado
                    //return View("NoExisteMail");
                    return Json(new { Success = false, Message = "La cuenta de correo electrónico no existe en nuestra base de datos" }, JsonRequestBehavior.AllowGet);
                }

                else
                {
                    // Para obtener más información sobre cómo habilitar la confirmación de cuenta y el restablecimiento de contraseña, visite http://go.microsoft.com/fwlink/?LinkID=320771
                    // Enviar correo electrónico con este vínculo
                    string code = await UserManager.GeneratePasswordResetTokenAsync(user.Id);
                    var callbackUrl = Url.Action("ResetPassword", "Trabajadores", new { Email = user.UserName, code = code }, protocol: Request.Url.Scheme);
                    //await UserManager.SendEmailAsync(user.Id, "Restablecer contraseña", "Estimado usuario: Para poder restablecer su  contraseña, haga clic <a href=\"" + callbackUrl + "\">aquí</a>");


                    //MailMessage msg = new MailMessage();

                    //msg.From = new MailAddress("sistemas@cecyteo.edu.mx");
                    //msg.To.Add(user.Email);
                    //msg.Subject = "Restablecer clave";
                    //msg.IsBodyHtml = true;


                    //UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);



                    //msg.Body = "Estimado usuario: Para poder restablecer su  contraseña, haga clic <a href=\"" + callbackUrl + "\">aquí</a>";
                    //SmtpClient client = new SmtpClient();


                    //client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
                    //client.Host = "smtp.gmail.com";
                    //client.Port = 587;
                    //client.DeliveryMethod = SmtpDeliveryMethod.Network;
                    //client.EnableSsl = true;



                    if (EnviarMailRestablecerContraseña(user.UserName, callbackUrl) == false)
                    {

                        //                    throw new Exception(" El mail no ha podido ser enviado , intente más tarde");

                        return Json(new { Success = false, Message = " El correo electrónico  no ha podido ser enviado , intenta más tarde" }, JsonRequestBehavior.AllowGet);
                    }
                    else


                        // return RedirectToAction("ForgotPasswordConfirmation", "Account");

                        return Json(new { Success = true, Message = " El correo electrónico  ha sido enviado exitosamente a la cuenta:"+user.UserName+", en unos minutos revisa su bandeja de entrada o correo no deseado para completar el proceso." }, JsonRequestBehavior.AllowGet);
                }
            }
            else
            {
                string validationErrors = string.Join(",",
                    ModelState.Values.Where(E => E.Errors.Count > 0)
                    .SelectMany(E => E.Errors)
                    .Select(E => E.ErrorMessage)
                    .ToArray());
                return Json(new { Success = false, Message = validationErrors }, JsonRequestBehavior.AllowGet);
            }

            // Si llegamos a este punto, es que se ha producido un error y volvemos a mostrar el formulario
            //return View(model);
            // return resultadofinal
        }

        //
        // POST: /Account/ForgotPassword
        //[HttpPost]
        //[AllowAnonymous]
        //[ValidateAntiForgeryToken]
        //public async Task<ActionResult> ForgotPassword(ForgotPasswordViewModel model)
        //{
        //    if (ModelState.IsValid)
        //    {
        //        var user = await UserManager.FindByNameAsync(model.Email);
        //        if (user == null )
        //            //if (user == null || !(await UserManager.IsEmailConfirmedAsync(user.Id)))
        //        {
        //            // No revelar que el usuario no existe o que no está confirmado
        //            return View("NoExisteMail");
        //        }

        //        // Para obtener más información sobre cómo habilitar la confirmación de cuenta y el restablecimiento de contraseña, visite http://go.microsoft.com/fwlink/?LinkID=320771
        //        // Enviar correo electrónico con este vínculo
        //        string code = await UserManager.GeneratePasswordResetTokenAsync(user.Id);
        //        var callbackUrl = Url.Action("ResetPassword", "Account", new { userId = user.Id, code = code,email=user.Email }, protocol: Request.Url.Scheme);
        //        //await UserManager.SendEmailAsync(user.Id, "Restablecer contraseña", "Estimado usuario: Para poder restablecer su  contraseña, haga clic <a href=\"" + callbackUrl + "\">aquí</a>");

        //           MailMessage msg = new  MailMessage();

        //        msg.From = new  MailAddress("sistemas@cecyteo.edu.mx");
        //        msg.To.Add(user.Email);
        //        msg.Subject = "Restablecer clave";
        //        msg.IsBodyHtml = true;
                

        //        UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);

                

        //        msg.Body =  "Estimado usuario: Para poder restablecer su  contraseña, haga clic <a href=\"" + callbackUrl + "\">aquí</a>";
        //        SmtpClient client = new SmtpClient();


        //        client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
        //        client.Host = "smtp.gmail.com";
        //        client.Port = 587;
        //        client.DeliveryMethod = SmtpDeliveryMethod.Network;
        //        client.EnableSsl = true;
        //        // client.UseDefaultCredentials = false;

        //        try
        //        {
        //            client.Send(msg);
                  
        //        }
        //        catch (Exception)
        //        {
                
        //            throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
        //        }
                

        //        return RedirectToAction("ForgotPasswordConfirmation", "Account");
        //    }

        //    // Si llegamos a este punto, es que se ha producido un error y volvemos a mostrar el formulario
        //    return View(model);
        //}

       

        //
        // GET: /Account/ForgotPasswordConfirmation
        [AllowAnonymous]
        public ActionResult ForgotPasswordConfirmation()
        {
            return View();
        }

        //
        // GET: /Account/ResetPassword
        [AllowAnonymous]
        public ActionResult ResetPassword(string code,string email)
        {
            ViewBag.email = email;
            return code == null ? View("Error") : View();
        }

        //
        // POST: /Account/ResetPassword
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> ResetPassword(ResetPasswordViewModel model)
        {
            if (!ModelState.IsValid)
            {
                return View(model);
            }
            var user = await UserManager.FindByNameAsync(model.Email);
            if (user == null)
            {
                // No revelar que el usuario no existe
                //return RedirectToAction("ResetPasswordConfirmation", "Account");
                View("Error");
            }
            var code = await UserManager.GeneratePasswordResetTokenAsync(user.Id);
            var result = await UserManager.ResetPasswordAsync(user.Id, code, model.Password);
            if (result.Succeeded)
            {
                ViewBag.Success = 1;
                return View();
            }
            AddErrors(result);
            return View();
        }

        //
        // GET: /Account/ResetPasswordConfirmation
        [AllowAnonymous]
        public ActionResult ResetPasswordConfirmation()
        {
            return View();
        }

        //
        // POST: /Account/ExternalLogin
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public ActionResult ExternalLogin(string provider, string returnUrl)
        {
            // Solicitar redireccionamiento al proveedor de inicio de sesión externo
            return new ChallengeResult(provider, Url.Action("ExternalLoginCallback", "Trabajadores", new { ReturnUrl = returnUrl }));
        }

        //
        // GET: /Account/SendCode
        [AllowAnonymous]
        public async Task<ActionResult> SendCode(string returnUrl, bool rememberMe)
        {
            var userId = await SignInManager.GetVerifiedUserIdAsync();
            if (userId == null)
            {
                return View("Error");
            }
            var userFactors = await UserManager.GetValidTwoFactorProvidersAsync(userId);
            var factorOptions = userFactors.Select(purpose => new SelectListItem { Text = purpose, Value = purpose }).ToList();
            return View(new SendCodeViewModel { Providers = factorOptions, ReturnUrl = returnUrl, RememberMe = rememberMe });
        }

        //
        // POST: /Account/SendCode
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> SendCode(SendCodeViewModel model)
        {
            if (!ModelState.IsValid)
            {
                return View();
            }

            // Generar el token y enviarlo
            if (!await SignInManager.SendTwoFactorCodeAsync(model.SelectedProvider))
            {
                return View("Error");
            }
            return RedirectToAction("VerifyCode", new { Provider = model.SelectedProvider, ReturnUrl = model.ReturnUrl, RememberMe = model.RememberMe });
        }

        //
        // GET: /Account/ExternalLoginCallback
        [AllowAnonymous]
        public async Task<ActionResult> ExternalLoginCallback(string returnUrl)
        {
            var loginInfo = await AuthenticationManager.GetExternalLoginInfoAsync();
            if (loginInfo == null)
            {
                return RedirectToAction("Login");
            }

            // Si el usuario ya tiene un inicio de sesión, iniciar sesión del usuario con este proveedor de inicio de sesión externo
            var result = await SignInManager.ExternalSignInAsync(loginInfo, isPersistent: false);
            switch (result)
            {
                case SignInStatus.Success:
                    return RedirectToLocal(returnUrl);
                case SignInStatus.LockedOut:
                    return View("Lockout");
                case SignInStatus.RequiresVerification:
                    return RedirectToAction("SendCode", new { ReturnUrl = returnUrl, RememberMe = false });
                case SignInStatus.Failure:
                default:
                    // Si el usuario no tiene ninguna cuenta, solicitar que cree una
                    ViewBag.ReturnUrl = returnUrl;
                    ViewBag.LoginProvider = loginInfo.Login.LoginProvider;
                    return View("ExternalLoginConfirmation", new ExternalLoginConfirmationViewModel { Email = loginInfo.Email });
            }
        }

        //
        // POST: /Account/ExternalLoginConfirmation
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> ExternalLoginConfirmation(ExternalLoginConfirmationViewModel model, string returnUrl)
        {
            if (User.Identity.IsAuthenticated)
            {
                return RedirectToAction("Index", "Manage");
            }

            if (ModelState.IsValid)
            {
                // Obtener datos del usuario del proveedor de inicio de sesión externo
                var info = await AuthenticationManager.GetExternalLoginInfoAsync();
                if (info == null)
                {
                    return View("ExternalLoginFailure");
                }
                var user = new ApplicationUser { UserName = model.Email, Email = model.Email };
                var result = await UserManager.CreateAsync(user);
                if (result.Succeeded)
                {
                    result = await UserManager.AddLoginAsync(user.Id, info.Login);
                    if (result.Succeeded)
                    {
                        await SignInManager.SignInAsync(user, isPersistent: false, rememberBrowser: false);
                        return RedirectToLocal(returnUrl);
                    }
                }
                AddErrors(result);
            }

            ViewBag.ReturnUrl = returnUrl;
            return View(model);
        }

        //
        // POST: /Account/LogOff
         [AllowAnonymous]
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult LogOff()
        {
            AuthenticationManager.SignOut();
            return RedirectToAction("Login", "Trabajadores");
        }

        //
        // GET: /Account/ExternalLoginFailure
        [AllowAnonymous]
        public ActionResult ExternalLoginFailure()
        {
            return View();
        }

        [HttpPost]
        [AllowAnonymous]
        public async Task<string> ValidateUserType(LoginViewModel data)
        {
            var t= Usuario.ValidaTipoUsuario(data.Email);
            LoginViewModel login= new LoginViewModel();
            
            //login.Email=email;
            //login.Password=pass;

            if (t == "trabajador")
            {
                //AccountController ac = new AccountController();
                //ac.ControllerContext = ControllerContext;
                //await ac.Login(data, "");

                RedirectToAction("Login", "Trabajadores", new { model=data,returnUrl="" });
            }
            else
                if (t == "alumno")
                {
                    RedirectToAction("Login", "Alumnos", new { model = data, returnUrl = "" });
                }
                else
                    if (t == "tutor")
                    {
                        RedirectToAction("Login", "Tutores", new { model = data, returnUrl = "" });
                    }
                    else
                        RedirectToAction("Login", "Trabajadores");
            return "";
        }

        [HttpPost]
        [AllowAnonymous]
        public JsonResult ValidateUser(string email)
        {
            email = email.Trim();
            LoginStatus status = new LoginStatus();
            bdNovaEntities bd = new bdNovaEntities();
            Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria trabajador = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(b => (b.Convenios_stConvenioLaboralTrabajador.FechaTermino >= System.DateTime.Now || b.Convenios_stConvenioLaboralTrabajador.FechaTermino == null) && b.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.CorreoElectronico.ToLower() == email).FirstOrDefault();

            bdNovaEntities db = new bdNovaEntities();
            var IdUsuario = from a in db.AspNetUsers
                            where a.Email == email
                            select new { a.Id };




            if (trabajador == null)
            {
                status.Message = "No existe este correo electrónico en nuestra base de datos ";
                status.Success = false;
            }
            else
                //if (trabajador.EsCancelado == true  || (trabajador.FechaTermino != null &&  DateTime.Now > trabajador.FechaTermino ))
                //{
                //    status.Message = "Esta cuenta ya no esta vigente, no podemos reactivarla";
                //    status.Success = false;
                //}
                //else
                if (IdUsuario.Count() > 0)
                {
                    status.Message = "Esta cuenta ya esta activada,  puede restablecer su contraseña si tiene problemas para entrar al sistema";
                    status.Success = false;
                }
                else
                    if (EnviarEmailActivacion(email, trabajador.Convenios_stConvenioLaboralTrabajador.IdTrabajador))
                       
                    {
                        status.Message = "Se ha enviado un mail a la siguiente direccíon: " + email + " , revise su bandeja de entrada en unos minutos y siga las instrucciones para poder activar su cuenta (IMPORTANTE: revise también su bandeja de spam o correo no deseado)";
                        status.Success = true;
                        status.TargetURL = FormsAuthentication.LoginUrl;
                    }
                    else
                    {
                        status.Message = "No se ha podido enviar el email a su cuenta por favor intente más tarde";
                        status.Success = false;
                    }





            return Json(status);
        }


        private bool EnviarEmailActivacion(string email, int id)
        {
            string codificado = Cifrado.Encrypt(email + id.ToString());
            bool regresa = true;
            UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);
            string url = HttpContext.Request.Url.Scheme + "://" + HttpContext.Request.Url.Authority + u.Action("Register", "Trabajadores", new { email = email, id = id, check = HttpUtility.UrlEncode(codificado) });
            
            string cuerpoHtml = @"<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional //Es' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'><html xmlns='http://www.w3.org/1999/xhtml' xmlns:v='urn:schemas-microsoft-com:vml' xmlns:o='urn:schemas-microsoft-com:office:office'><head>
  <!--[if gte mso 9]><xml>
   <o:OfficeDocumentSettings>
    <o:AllowPNG/>
    <o:PixelsPerInch>96</o:PixelsPerInch>
   </o:OfficeDocumentSettings>
  </xml><![endif]-->
  <meta http-equiv='Content-Type' content='text/html; charset=utf-8'>
  <meta name='viewport' content='width=device-width'>
  <meta http-equiv='X-UA-Compatible' content='IE=9; IE=8; IE=7; IE=EDGE'>
  <title>Cecyteo</title>
  
  
  <style id='media-query'>
    /* Client-specific Styles & Reset */
    #outlook a {
        padding: 0;
    }

    /* .ExternalClass applies to Outlook.com (the artist formerly known as Hotmail) */
    .ExternalClass {
        width: 100%;
    }

    .ExternalClass,
    .ExternalClass p,
    .ExternalClass span,
    .ExternalClass font,
    .ExternalClass td,
    .ExternalClass div {
        line-height: 100%;
    }

    #backgroundTable {
        margin: 0;
        padding: 0;
        width: 100% !important;
        line-height: 100% !important;
    }

    /* Buttons */
    .button a {
        display: inline-block;
        text-decoration: none;
        -webkit-text-size-adjust: none;
        text-align: center;
    }

    .button a div {
        text-align: center !important;
    }

    /* Outlook First */
    body.outlook p {
        display: inline !important;
    }

    a[x-apple-data-detectors] {
  color: inherit !important;
  text-decoration: none !important;
  font-size: inherit !important;
  font-family: inherit !important;
  font-weight: inherit !important;
  line-height: inherit !important; }

.btn {
  background: #3498db;
  background-image: -webkit-linear-gradient(top, #3498db, #2980b9);
  background-image: -moz-linear-gradient(top, #3498db, #2980b9);
  background-image: -ms-linear-gradient(top, #3498db, #2980b9);
  background-image: -o-linear-gradient(top, #3498db, #2980b9);
  background-image: linear-gradient(to bottom, #3498db, #2980b9);
  -webkit-border-radius: 28;
  -moz-border-radius: 28;
  border-radius: 28px;
  font-family: Arial;
  color: #ffffff;
  font-size: 20px;
  padding: 10px 20px 10px 20px;
  text-decoration: none;
}

.btn:hover {
  background: #3cb0fd;
  background-image: -webkit-linear-gradient(top, #3cb0fd, #3498db);
  background-image: -moz-linear-gradient(top, #3cb0fd, #3498db);
  background-image: -ms-linear-gradient(top, #3cb0fd, #3498db);
  background-image: -o-linear-gradient(top, #3cb0fd, #3498db);
  background-image: linear-gradient(to bottom, #3cb0fd, #3498db);
  text-decoration: none;
}
/*  Media Queries */
@media only screen and (max-width: 500px) {
  table[class='body'] img {
    height: auto !important;
    width: 100% !important; }
  table[class='body'] img.fullwidth {
    max-width: 100% !important; }
  table[class='body'] center {
    min-width: 0 !important; }
  table[class='body'] .container {
    width: 95% !important; }
  table[class='body'] .row {
    width: 100% !important;
    display: block !important; }
  table[class='body'] .wrapper {
    display: block !important;
    padding-right: 0 !important; }
  table[class='body'] .columns, table[class='body'] .column {
    table-layout: fixed !important;
    float: none !important;
    width: 100% !important;
    padding-right: 0px !important;
    padding-left: 0px !important;
    display: block !important; }
  table[class='body'] .wrapper.first .columns, table[class='body'] .wrapper.first .column {
    display: table !important; }
  table[class='body'] table.columns td, table[class='body'] table.column td, .col {
    width: 100% !important; }
  table[class='body'] table.columns td.expander {
    width: 1px !important; }
  table[class='body'] .right-text-pad, table[class='body'] .text-pad-right {
    padding-left: 10px !important; }
  table[class='body'] .left-text-pad, table[class='body'] .text-pad-left {
    padding-right: 10px !important; }
  table[class='body'] .hide-for-small, table[class='body'] .show-for-desktop {
    display: none !important; }
  table[class='body'] .show-for-small, table[class='body'] .hide-for-desktop {
    display: inherit !important; }
  .mixed-two-up .col {
    width: 100% !important; } }
 @media screen and (max-width: 500px) {
      div[class='col'] {
          width: 100% !important;
      }
    }

    @media screen and (min-width: 501px) {
      table[class='container'] {
          width: 500px !important;
      }
    }
  </style>
</head>
<body style='width: 100% !important;min-width: 100%;-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100% !important;margin: 0;padding: 0;background-color: #FFFFFF'>
  <table cellpadding='0' cellspacing='0' width='100%' class='body' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;height: 100%;width: 100%;table-layout: fixed'>
      <tbody><tr style='vertical-align: top'>
          <td class='center' align='center' valign='top' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: center;background-color: #FFFFFF'>

              <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
                <tbody><tr style='vertical-align: top'>
                  <td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: #EDEDED'>
                    <!--[if gte mso 9]>
                    <table id='outlookholder' border='0' cellspacing='0' cellpadding='0' align='center'><tr><td>
                    <![endif]-->
                    <!--[if (IE)]>
                    <table width='500' align='center' cellpadding='0' cellspacing='0' border='0'>
                        <tr>
                            <td>
                    <![endif]-->
                    <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' class='container' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit'><tbody><tr style='vertical-align: top'><td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'><table cellpadding='0' cellspacing='0' width='100%' bgcolor='transparent' class='block-grid two-up' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;width: 100%;max-width: 500px;color: #333;background-color: transparent'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;text-align: center;font-size: 0'><!--[if (gte mso 9)|(IE)]><table width='100%' align='center' bgcolor='transparent' cellpadding='0' cellspacing='0' border='0'><tr><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='250' style='width:250px;'><![endif]--><div class='col num6' style='display: inline-block;vertical-align: top;text-align: center;width: 250px'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 20px;padding-right: 0px;padding-bottom: 5px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table cellpadding='0' cellspacing='0' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
    <tbody><tr style='vertical-align: top'>
        <td align='center' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;width: 100%;padding-top: 0px;padding-right: 0px;padding-bottom: 0px;padding-left: 0px'>
            <div align='center' style='font-size:12px'>
                <a href='https://www.cecyteo.edu.mx' target='_blank'>
                    <img class='center' align='center' border='0' src='https://www.cecyteo.edu.mx/Nova/App_Themes/Site2015/img/icons/logo.png' alt='Image' title='Image' style='outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block;border: none;height: auto;line-height: 100%;margin: 0 auto;float: none;width: 100% !important;max-width: 174px' width='174'>
                </a>

            </div>
        </td>
    </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='250' style='width:250px;'><![endif]--><div class='col num6' style='display: inline-block;vertical-align: top;text-align: center;width: 250px'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 20px;padding-right: 0px;padding-bottom: 20px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 20px;padding-right: 10px;padding-bottom: 20px;padding-left: 10px'>
      <div style='color:#6E6F7A;line-height:150%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
      	<div style='line-height:18px;font-size:12px;color:#6E6F7A;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;text-align:left;'><div style='text-align: right; line-height:18px; font-size:12px;'><strong><span style='font-size: 16px; line-height: 24px;'>Colegio de Estudios Científicos y Tecnológicos del Estado de Oaxaca</span></strong></div></div>
      </div>
    </td>
  </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]--></td></tr></tbody></table></td></tr></tbody></table>
                    <!--[if mso]>
                    </td></tr></table>
                    <![endif]-->
                    <!--[if (IE)]>
                    </td></tr></table>
                    <![endif]-->
                  </td>
                </tr>
              </tbody></table>
              <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
                <tbody><tr style='vertical-align: top'>
                  <td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: #BBBBBB'>
                    <!--[if gte mso 9]>
                    <table id='outlookholder' border='0' cellspacing='0' cellpadding='0' align='center'><tr><td>
                    <![endif]-->
                    <!--[if (IE)]>
                    <table width='500' align='center' cellpadding='0' cellspacing='0' border='0'>
                        <tr>
                            <td>
                    <![endif]-->
                    <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' class='container' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit'><tbody><tr style='vertical-align: top'><td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'><table cellpadding='0' cellspacing='0' width='100%' bgcolor='transparent' class='block-grid ' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;width: 100%;max-width: 500px;color: #333;background-color: transparent'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;text-align: center;font-size: 0'><!--[if (gte mso 9)|(IE)]><table width='100%' align='center' bgcolor='transparent' cellpadding='0' cellspacing='0' border='0'><tr><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='500' style='width:500px;'><![endif]--><div class='col num12' style='display: inline-block;vertical-align: top;width: 100%'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 30px;padding-right: 0px;padding-bottom: 30px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 25px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='color:#ffffff;line-height:120%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
      	<div style='line-height:14px;font-size:12px;color:#ffffff;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;text-align:left;'><p style='margin: 0;font-size: 18px;line-height: 22px;text-align: center'><span style='font-size: 24px; line-height: 28px;'><strong>Estimado trabajador ha solicitado la activación de su cuenta para poder ingresar al sistema del Colegio, para poder completar el proceso de click en el siguiente link</strong></span></p></div>
      </div>
    </td>
  </tr>
</tbody></table>
<table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 0px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='color:#000;line-height:150%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>

      	<div style='font-size:14px;line-height:21px;text-align:center;color:#000;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'><p style='margin-top: 60px;font-size: 14px;line-height: 21px;text-align: center'><a class='btn' href='" + url + @"' target='_blank'> Activar mi cuenta</a></p></div><div style='font-size:14px;line-height:21px;text-align:center;color:#000;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
<p></p>
<p style='margin: 0;font-size: 14px;line-height: 21px;text-align: center'><span style='font-size: 14px; line-height: 21px;'>Le recordamos que su cuenta es personal e intransferible.</span></p></div><div style='font-size:14px;line-height:21px;text-align:center;color:#000;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'><p style='margin: 0;font-size: 14px;line-height: 21px;text-align: center'><span style='font-size: 14px; line-height: 21px;'></span></p></div>
      </div>
    </td>
  </tr>
</tbody></table>
 
<table align='center' width='100%' border='0' cellpadding='0' cellspacing='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td align='center' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 10px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='height: 0px;'>
        <table align='center' border='0' cellspacing='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;border-top: 0px solid transparent;width: 100%'><tbody><tr style='vertical-align: top'><td align='center' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'></td></tr></tbody></table>
      </div>
    </td>
  </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]--></td></tr></tbody></table></td></tr></tbody></table>
                    <!--[if mso]>
                    </td></tr></table>
                    <![endif]-->
                    <!--[if (IE)]>
                    </td></tr></table>
                    <![endif]-->
                  </td>
                </tr>
              </tbody></table>
              <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
                <tbody><tr style='vertical-align: top'>
                  <td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: #ffffff'>
                    <!--[if gte mso 9]>
                    <table id='outlookholder' border='0' cellspacing='0' cellpadding='0' align='center'><tr><td>
                    <![endif]-->
                    <!--[if (IE)]>
                    <table width='500' align='center' cellpadding='0' cellspacing='0' border='0'>
                        <tr>
                            <td>
                    <![endif]-->
                    <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' class='container' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit'><tbody><tr style='vertical-align: top'><td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'><table cellpadding='0' cellspacing='0' width='100%' bgcolor='transparent' class='block-grid ' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;width: 100%;max-width: 500px;color: #333;background-color: transparent'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;text-align: center;font-size: 0'><!--[if (gte mso 9)|(IE)]><table width='100%' align='center' bgcolor='transparent' cellpadding='0' cellspacing='0' border='0'><tr><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='500' style='width:500px;'><![endif]--><div class='col num12' style='display: inline-block;vertical-align: top;width: 100%'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 30px;padding-right: 0px;padding-bottom: 30px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table width='100%' border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td align='center' valign='top' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>
      <table border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
        <tbody><tr style='vertical-align: top'>
          <td align='center' valign='top' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: center;padding-top: 10px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px;max-width: 114px'>

            <!--[if (gte mso 9)|(IE)]>
            <table width='94' align='left' border='0' cellspacing='0' cellpadding='0'>
              <tr>
                <td align='left'>
            <![endif]-->
            <table width='100%' align='left' cellpadding='0' cellspacing='0' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
              <tbody><tr style='vertical-align: top'>
                <td align='left' valign='middle' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>


                  <table align='left' border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;padding: 0 5px 5px 0' height='37'>
                    <tbody><tr style='vertical-align: top'>
                      <td width='37' align='left' valign='middle' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>
                        <a href='https://www.facebook.com/CECyTEOaxaca' title='Facebook' target='_blank'>
                          <img src='https://www.cecyteo.edu.mx/Nova/App_Themes/Site2015/img/facebook.png' alt='Facebook' title='Facebook' width='32' style='outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block;border: none;height: auto;line-height: 100%;max-width: 32px !important'>
                        </a>
                      </td>
                    </tr>
                  </tbody></table>
                  <table align='left' border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;padding: 0 5px 5px 0' height='37'>
                    <tbody><tr style='vertical-align: top'>
                      <td width='37' align='left' valign='middle' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>
                        <a href='http://twitter.com/cecyteoaxaca' title='Twitter' target='_blank'>
                          <img src='https://www.cecyteo.edu.mx/Nova/App_Themes/Site2015/img/twitter.png' alt='Twitter' title='Twitter' width='32' style='outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block;border: none;height: auto;line-height: 100%;max-width: 32px !important'>
                        </a>
                      </td>
                    </tr>
                  </tbody></table>

                </td>
              </tr>
            </tbody></table>
            <!--[if (gte mso 9)|(IE)]>
                </td>
              </tr>
            </table>
            <![endif]-->
          </td>
        </tr>
      </tbody></table>
    </td>
  </tr>
</tbody></table>
<table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 15px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='color:#959595;line-height:150%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
      	<div style='line-height:18px;font-size:12px;color:#959595;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;text-align:left;'>
          <p style='margin: 0;font-size: 12px;line-height: 21px;text-align: center'>Este correo ha sido generado de forma automática.</p>
              <p style='margin: 0;font-size: 14px;line-height: 21px;text-align: center'>Gobierno del Estado de Oaxaca.</p>
          </div>
      </div>
    </td>
  </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]--></td></tr></tbody></table></td></tr></tbody></table>
                    <!--[if mso]>
                    </td></tr></table>
                    <![endif]-->
                    <!--[if (IE)]>
                    </td></tr></table>
                    <![endif]-->
                  </td>
                </tr>
              </tbody></table>
          </td>
      </tr>
  </tbody></table>


</body></html>";
            try
            {
                // Crear objeto CorreoPersonalizado
                CorreoPersonalizado correo = new CorreoPersonalizado
            {
                Nombre = email,
                DestinatarioEmail = email,
                TituloCorreo = "Restablecer clave",
                LugarTrabajo = "",
                Firma = "",
                DirigidoA = "",
                DireccionFirma = "",
                Fecha = DateTime.Now.ToString("dd/MM/yyyy"),
                Hora = DateTime.Now.ToString("HH:mm"),
                LinkUrl = url
            };

            // Llamar a tu CorreoService para enviar
            CorreoService.EnviarCorreoPersonalizadoConCuerpoDirecto(correo, cuerpoHtml);
        }
            catch (Exception e)
            {
                regresa = false;
                // throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
            }
            return regresa;
        }
     

        private bool EnviarMailRestablecerContraseña(string mailusuario, string url)
        {
            bool regresa = true;

            string cuerpoHtml = @"<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional //Es' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'><html xmlns='http://www.w3.org/1999/xhtml' xmlns:v='urn:schemas-microsoft-com:vml' xmlns:o='urn:schemas-microsoft-com:office:office'><head>
  <!--[if gte mso 9]><xml>
   <o:OfficeDocumentSettings>
    <o:AllowPNG/>
    <o:PixelsPerInch>96</o:PixelsPerInch>
   </o:OfficeDocumentSettings>
  </xml><![endif]-->
  <meta http-equiv='Content-Type' content='text/html; charset=utf-8'>
  <meta name='viewport' content='width=device-width'>
  <meta http-equiv='X-UA-Compatible' content='IE=9; IE=8; IE=7; IE=EDGE'>
  <title>Cecyteo</title>
  
  
  <style id='media-query'>
    /* Client-specific Styles & Reset */
    #outlook a {
        padding: 0;
    }

    /* .ExternalClass applies to Outlook.com (the artist formerly known as Hotmail) */
    .ExternalClass {
        width: 100%;
    }

    .ExternalClass,
    .ExternalClass p,
    .ExternalClass span,
    .ExternalClass font,
    .ExternalClass td,
    .ExternalClass div {
        line-height: 100%;
    }

    #backgroundTable {
        margin: 0;
        padding: 0;
        width: 100% !important;
        line-height: 100% !important;
    }

    /* Buttons */
    .button a {
        display: inline-block;
        text-decoration: none;
        -webkit-text-size-adjust: none;
        text-align: center;
    }

    .button a div {
        text-align: center !important;
    }

    /* Outlook First */
    body.outlook p {
        display: inline !important;
    }

    a[x-apple-data-detectors] {
  color: inherit !important;
  text-decoration: none !important;
  font-size: inherit !important;
  font-family: inherit !important;
  font-weight: inherit !important;
  line-height: inherit !important; }

.btn {
	background-color:#12b317;
	-moz-border-radius:28px;
	-webkit-border-radius:28px;
	border-radius:28px;
	border:1px solid #18ab29;
	display:inline-block;
	cursor:pointer;
	color:#ffffff;
	font-family:Arial;
	font-size:17px;
	padding:16px 31px;
	text-decoration:none;
	text-shadow:0px 1px 0px #2f6627;
}
.btn:hover {
	background-color:#5cbf2a;
}
.btn:active {
	position:relative;
	top:1px;
}

/*  Media Queries */
@media only screen and (max-width: 500px) {
  table[class='body'] img {
    height: auto !important;
    width: 100% !important; }
  table[class='body'] img.fullwidth {
    max-width: 100% !important; }
  table[class='body'] center {
    min-width: 0 !important; }
  table[class='body'] .container {
    width: 95% !important; }
  table[class='body'] .row {
    width: 100% !important;
    display: block !important; }
  table[class='body'] .wrapper {
    display: block !important;
    padding-right: 0 !important; }
  table[class='body'] .columns, table[class='body'] .column {
    table-layout: fixed !important;
    float: none !important;
    width: 100% !important;
    padding-right: 0px !important;
    padding-left: 0px !important;
    display: block !important; }
  table[class='body'] .wrapper.first .columns, table[class='body'] .wrapper.first .column {
    display: table !important; }
  table[class='body'] table.columns td, table[class='body'] table.column td, .col {
    width: 100% !important; }
  table[class='body'] table.columns td.expander {
    width: 1px !important; }
  table[class='body'] .right-text-pad, table[class='body'] .text-pad-right {
    padding-left: 10px !important; }
  table[class='body'] .left-text-pad, table[class='body'] .text-pad-left {
    padding-right: 10px !important; }
  table[class='body'] .hide-for-small, table[class='body'] .show-for-desktop {
    display: none !important; }
  table[class='body'] .show-for-small, table[class='body'] .hide-for-desktop {
    display: inherit !important; }
  .mixed-two-up .col {
    width: 100% !important; } }
 @media screen and (max-width: 500px) {
      div[class='col'] {
          width: 100% !important;
      }
    }

    @media screen and (min-width: 501px) {
      table[class='container'] {
          width: 500px !important;
      }
    }
  </style>
</head>
<body style='width: 100% !important;min-width: 100%;-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100% !important;margin: 0;padding: 0;background-color: #FFFFFF'>
  <table cellpadding='0' cellspacing='0' width='100%' class='body' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;height: 100%;width: 100%;table-layout: fixed'>
      <tbody><tr style='vertical-align: top'>
          <td class='center' align='center' valign='top' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: center;background-color: #FFFFFF'>

              <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
                <tbody><tr style='vertical-align: top'>
                  <td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: #EDEDED'>
                    <!--[if gte mso 9]>
                    <table id='outlookholder' border='0' cellspacing='0' cellpadding='0' align='center'><tr><td>
                    <![endif]-->
                    <!--[if (IE)]>
                    <table width='500' align='center' cellpadding='0' cellspacing='0' border='0'>
                        <tr>
                            <td>
                    <![endif]-->
                    <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' class='container' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit'><tbody><tr style='vertical-align: top'><td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'><table cellpadding='0' cellspacing='0' width='100%' bgcolor='transparent' class='block-grid two-up' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;width: 100%;max-width: 500px;color: #333;background-color: transparent'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;text-align: center;font-size: 0'><!--[if (gte mso 9)|(IE)]><table width='100%' align='center' bgcolor='transparent' cellpadding='0' cellspacing='0' border='0'><tr><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='250' style='width:250px;'><![endif]--><div class='col num6' style='display: inline-block;vertical-align: top;text-align: center;width: 250px'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 20px;padding-right: 0px;padding-bottom: 5px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table cellpadding='0' cellspacing='0' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
    <tbody><tr style='vertical-align: top'>
        <td align='center' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;width: 100%;padding-top: 0px;padding-right: 0px;padding-bottom: 0px;padding-left: 0px'>
            <div align='center' style='font-size:12px'>
                <a href='https://www.cecyteo.edu.mx' target='_blank'>
                    <img class='center' align='center' border='0' src='https://www.cecyteo.edu.mx/Nova/App_Themes/Site2015/img/icons/logo.png' alt='Image' title='Image' style='outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block;border: none;height: auto;line-height: 100%;margin: 0 auto;float: none;width: 100% !important;max-width: 174px' width='174'>
                </a>

            </div>
        </td>
    </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='250' style='width:250px;'><![endif]--><div class='col num6' style='display: inline-block;vertical-align: top;text-align: center;width: 250px'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 20px;padding-right: 0px;padding-bottom: 20px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 20px;padding-right: 10px;padding-bottom: 20px;padding-left: 10px'>
      <div style='color:#6E6F7A;line-height:150%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
      	<div style='line-height:18px;font-size:12px;color:#6E6F7A;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;text-align:left;'><div style='text-align: right; line-height:18px; font-size:12px;'><strong><span style='font-size: 16px; line-height: 24px;'>Colegio de Estudios Científicos y Tecnológicos del Estado de Oaxaca</span></strong></div></div>
      </div>
    </td>
  </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]--></td></tr></tbody></table></td></tr></tbody></table>
                    <!--[if mso]>
                    </td></tr></table>
                    <![endif]-->
                    <!--[if (IE)]>
                    </td></tr></table>
                    <![endif]-->
                  </td>
                </tr>
              </tbody></table>
              <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
                <tbody><tr style='vertical-align: top'>
                  <td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: #BBBBBB'>
                    <!--[if gte mso 9]>
                    <table id='outlookholder' border='0' cellspacing='0' cellpadding='0' align='center'><tr><td>
                    <![endif]-->
                    <!--[if (IE)]>
                    <table width='500' align='center' cellpadding='0' cellspacing='0' border='0'>
                        <tr>
                            <td>
                    <![endif]-->
                    <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' class='container' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit'><tbody><tr style='vertical-align: top'><td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'><table cellpadding='0' cellspacing='0' width='100%' bgcolor='transparent' class='block-grid ' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;width: 100%;max-width: 500px;color: #333;background-color: transparent'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;text-align: center;font-size: 0'><!--[if (gte mso 9)|(IE)]><table width='100%' align='center' bgcolor='transparent' cellpadding='0' cellspacing='0' border='0'><tr><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='500' style='width:500px;'><![endif]--><div class='col num12' style='display: inline-block;vertical-align: top;width: 100%'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 30px;padding-right: 0px;padding-bottom: 30px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 25px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='color:#ffffff;line-height:120%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
      	<div style='line-height:14px;font-size:12px;color:#ffffff;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;text-align:left;'><p style='margin: 0;font-size: 18px;line-height: 22px;text-align: center'><span style='font-size: 24px; line-height: 28px;'><strong>Estimado usuario de click en el siguiente enlace para completar el proceso</strong></span></p></div>
      </div>
    </td>
  </tr>
</tbody></table>
<table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 0px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='color:#B8B8C0;line-height:150%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
      	<div style='font-size:14px;line-height:21px;text-align:center;color:#B8B8C0;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'><p style='margin-top: 60px;font-size: 14px;line-height: 21px;text-align: center'><a class='btn' href='" + url + @"' target='_blank'> Restaurar Contraseña </a></p></div><div style='font-size:14px;line-height:21px;text-align:center;color:#B8B8C0;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'><p style='margin: 0;font-size: 14px;line-height: 21px;text-align: center'><span style='font-size: 14px; line-height: 21px;'></span></p></div><div style='font-size:14px;line-height:21px;text-align:center;color:#B8B8C0;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'><p style='margin: 0;font-size: 14px;line-height: 21px;text-align: center'><span style='font-size: 14px; line-height: 21px;'></span></p></div>
      </div>
    </td>
  </tr>
</tbody></table>
 
<table align='center' width='100%' border='0' cellpadding='0' cellspacing='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td align='center' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 10px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='height: 0px;'>
        <table align='center' border='0' cellspacing='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;border-top: 0px solid transparent;width: 100%'><tbody><tr style='vertical-align: top'><td align='center' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'></td></tr></tbody></table>
      </div>
    </td>
  </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]--></td></tr></tbody></table></td></tr></tbody></table>
                    <!--[if mso]>
                    </td></tr></table>
                    <![endif]-->
                    <!--[if (IE)]>
                    </td></tr></table>
                    <![endif]-->
                  </td>
                </tr>
              </tbody></table>
              <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
                <tbody><tr style='vertical-align: top'>
                  <td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: #ffffff'>
                    <!--[if gte mso 9]>
                    <table id='outlookholder' border='0' cellspacing='0' cellpadding='0' align='center'><tr><td>
                    <![endif]-->
                    <!--[if (IE)]>
                    <table width='500' align='center' cellpadding='0' cellspacing='0' border='0'>
                        <tr>
                            <td>
                    <![endif]-->
                    <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' class='container' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit'><tbody><tr style='vertical-align: top'><td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'><table cellpadding='0' cellspacing='0' width='100%' bgcolor='transparent' class='block-grid ' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;width: 100%;max-width: 500px;color: #333;background-color: transparent'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;text-align: center;font-size: 0'><!--[if (gte mso 9)|(IE)]><table width='100%' align='center' bgcolor='transparent' cellpadding='0' cellspacing='0' border='0'><tr><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='500' style='width:500px;'><![endif]--><div class='col num12' style='display: inline-block;vertical-align: top;width: 100%'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 30px;padding-right: 0px;padding-bottom: 30px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table width='100%' border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td align='center' valign='top' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>
      <table border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
        <tbody><tr style='vertical-align: top'>
          <td align='center' valign='top' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: center;padding-top: 10px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px;max-width: 114px'>

            <!--[if (gte mso 9)|(IE)]>
            <table width='94' align='left' border='0' cellspacing='0' cellpadding='0'>
              <tr>
                <td align='left'>
            <![endif]-->
            <table width='100%' align='left' cellpadding='0' cellspacing='0' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
              <tbody><tr style='vertical-align: top'>
                <td align='left' valign='middle' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>


                  <table align='left' border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;padding: 0 5px 5px 0' height='37'>
                    <tbody><tr style='vertical-align: top'>
                      <td width='37' align='left' valign='middle' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>
                        <a href='https://www.facebook.com/CECyTEOaxaca' title='Facebook' target='_blank'>
                          <img src='https://www.cecyteo.edu.mx/Nova/App_Themes/Site2015/img/facebook.png' alt='Facebook' title='Facebook' width='32' style='outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block;border: none;height: auto;line-height: 100%;max-width: 32px !important'>
                        </a>
                      </td>
                    </tr>
                  </tbody></table>
                  <table align='left' border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;padding: 0 5px 5px 0' height='37'>
                    <tbody><tr style='vertical-align: top'>
                      <td width='37' align='left' valign='middle' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>
                        <a href='http://twitter.com/cecyteoaxaca' title='Twitter' target='_blank'>
                          <img src='https://www.cecyteo.edu.mx/Nova/App_Themes/Site2015/img/twitter.png' alt='Twitter' title='Twitter' width='32' style='outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block;border: none;height: auto;line-height: 100%;max-width: 32px !important'>
                        </a>
                      </td>
                    </tr>
                  </tbody></table>

                </td>
              </tr>
            </tbody></table>
            <!--[if (gte mso 9)|(IE)]>
                </td>
              </tr>
            </table>
            <![endif]-->
          </td>
        </tr>
      </tbody></table>
    </td>
  </tr>
</tbody></table>
<table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 15px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='color:#959595;line-height:150%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
      	<div style='line-height:18px;font-size:12px;color:#959595;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;text-align:left;'>
          <p style='margin: 0;font-size: 12px;line-height: 21px;text-align: center'>Este correo ha sido generado de forma automática.</p>
              <p style='margin: 0;font-size: 14px;line-height: 21px;text-align: center'>Gobierno del Estado de Oaxaca.</p>
          </div>
      </div>
    </td>
  </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]--></td></tr></tbody></table></td></tr></tbody></table>
                    <!--[if mso]>
                    </td></tr></table>
                    <![endif]-->
                    <!--[if (IE)]>
                    </td></tr></table>
                    <![endif]-->
                  </td>
                </tr>
              </tbody></table>
          </td>
      </tr>
  </tbody></table>


</body></html>";


          


            try
            {
                CorreoPersonalizado correo = new CorreoPersonalizado
                {
                    Nombre = mailusuario,
                    DestinatarioEmail = mailusuario,
                    TituloCorreo = "Restablecer clave",
                    LugarTrabajo = "",
                    Firma = "",
                    DirigidoA = "",
                    DireccionFirma = "",
                    Fecha = DateTime.Now.ToString("dd/MM/yyyy"),
                    Hora = DateTime.Now.ToString("HH:mm"),
                    LinkUrl = url
                };

                // Llamar a tu CorreoService para enviar
                CorreoService.EnviarCorreoPersonalizadoConCuerpoDirecto(correo, cuerpoHtml);

            }
            catch (Exception)
            {
                regresa = false;
                // throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
            }
            return regresa;


        }

        #region Aplicaciones auxiliares
        // Se usa para la protección XSRF al agregar inicios de sesión externos
        private const string XsrfKey = "XsrfId";

        private IAuthenticationManager AuthenticationManager
        {
            get
            {
                return HttpContext.GetOwinContext().Authentication;
            }
        }

        private void AddErrors(IdentityResult result)
        {
            int d = 0;

            foreach (var error in result.Errors)
            {
                d++;
                if (d < 2)
                {
                    if (error.StartsWith("Passwords must have at least one non letter or digit"))
                    {
                        //var NameToEmail = Regex.Replace(error, "Name", "Email");
                        ModelState.AddModelError("", "El password deberá de contener al menos un caracter especial");
                    }
                    else
                        if (error.StartsWith("Passwords must have at least one uppercase ('A'-'Z')"))
                        {
                            //var NameToEmail = Regex.Replace(error, "Name", "Email");
                            ModelState.AddModelError("", "El password deberá de contener al menos una letra MAYÚSCULA");
                        }
                        else
                            if (error.StartsWith("Passwords must have at least one lowercase"))
                            {
                                //var NameToEmail = Regex.Replace(error, "Name", "Email");
                                ModelState.AddModelError("", "El password deberá de contener al menos una letra minúscula");
                            }

                            else
                                if (error.StartsWith("Name"))
                                {
                                    //var NameToEmail = Regex.Replace(error, "Name", "Email");
                                    ModelState.AddModelError("", "Tu cuenta ya ha sido activada con anterioridad, si olvidaste tu contraseña puedes restablecerla para poder ingresar");
                                }


                                else
                                {
                                    ModelState.AddModelError("", error);
                                }
                }
            }
        }

        private ActionResult RedirectToLocal(string returnUrl)
        {
            if (Url.IsLocalUrl(returnUrl))
            {
                return Redirect(returnUrl);
            }
            return RedirectToAction("Index", "Home");
        }

        internal class ChallengeResult : HttpUnauthorizedResult
        {
            public ChallengeResult(string provider, string redirectUri)
                : this(provider, redirectUri, null)
            {
            }

            public ChallengeResult(string provider, string redirectUri, string userId)
            {
                LoginProvider = provider;
                RedirectUri = redirectUri;
                UserId = userId;
            }

            public string LoginProvider { get; set; }
            public string RedirectUri { get; set; }
            public string UserId { get; set; }

            public override void ExecuteResult(ControllerContext context)
            {
                var properties = new AuthenticationProperties { RedirectUri = RedirectUri };
                if (UserId != null)
                {
                    properties.Dictionary[XsrfKey] = UserId;
                }
                context.HttpContext.GetOwinContext().Authentication.Challenge(properties, LoginProvider);
            }
        }
        #endregion
    }
}