﻿ 
using Microsoft.AspNet.Identity;
using Microsoft.AspNet.Identity.Owin;
using Microsoft.Owin.Security;
using System;
using System.Globalization;
using System.Linq;
using System.Security.Claims;
using System.Threading.Tasks;
using System.Web;
using System.Web.Mvc;
using Nova;
using Nova.Models;
using System.Net.Mail;
using System.Net;
using Nova.Libraries;
using System.Web.Security;
using SeguridadAlumnos.Models;

namespace Nova.Controllers
{
    
    public class AlumnosController : Controller
    {
        private ApplicationSignInManagerAlumnos _signInManager;
        private ApplicationUserManagerAlumnos _userManager;

        public AlumnosController()
        {
        }

        public AlumnosController(ApplicationUserManagerAlumnos userManager, ApplicationSignInManagerAlumnos signInManager)
        {
            UserManager = userManager;
            SignInManager = signInManager;
        }

        public ApplicationSignInManagerAlumnos SignInManager
        {
            get
            {
                return _signInManager ?? HttpContext.GetOwinContext().Get<ApplicationSignInManagerAlumnos>();
            }
            private set
            {
                _signInManager = value;
            }
        }

        public ApplicationUserManagerAlumnos UserManager
        {
            get
            {
                return _userManager ?? HttpContext.GetOwinContext().GetUserManager<ApplicationUserManagerAlumnos>();
            }
            private set
            {
                _userManager = value;
            }
        }

        //
        // GET: /Account/Login
        [AllowAnonymous]
        public ActionResult Login(string returnUrl)
        {
            ViewBag.ReturnUrl = returnUrl;
            return View();
        }

        //
        // POST: /Account/Login
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> Login(LoginViewModel model, string returnUrl)
        {
            if (!ModelState.IsValid)
            {
                return View(model);
            }

            // This doesn't count login failures towards account lockout
            // To enable password failures to trigger account lockout, change to shouldLockout: true
            var result = await SignInManager.PasswordSignInAsync(model.Email, model.Password, model.RememberMe, shouldLockout: false);
            
            
            switch (result)
            {
                case SignInStatus.Success:
                    SeguridadAlumnos.Alumnos.Instance.ActualizarLog(model.Email);
                    if (returnUrl.IndexOf("home")>-1 || returnUrl=="")
                        return RedirectToLocal(Url.Action("Index","Asignaturas"));
                else
                    return RedirectToLocal(returnUrl);

                case SignInStatus.LockedOut:
                    return View("Lockout");

                case SignInStatus.RequiresVerification:
                    return RedirectToAction("SendCode", new { ReturnUrl = returnUrl, RememberMe = model.RememberMe });

                case SignInStatus.Failure:
                default:
                    ModelState.AddModelError("", "Inicio de sesión no válido");
                    return View(model);
            }
        }

        //
        // GET: /Account/VerifyCode
        [AllowAnonymous]
        public async Task<ActionResult> VerifyCode(string provider, string returnUrl, bool rememberMe)
        {
            // Require that the user has already logged in via username/password or external login
            if (!await SignInManager.HasBeenVerifiedAsync())
            {
                return View("Error");
            }
            return View(new VerifyCodeViewModel { Provider = provider, ReturnUrl = returnUrl, RememberMe = rememberMe });
        }

        //
        // POST: /Account/VerifyCode
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> VerifyCode(VerifyCodeViewModel model)
        {
            if (!ModelState.IsValid)
            {
                return View(model);
            }

            // The following code protects for brute force attacks against the two factor codes.
            // If a user enters incorrect codes for a specified amount of time then the user account
            // will be locked out for a specified amount of time.
            // You can configure the account lockout settings in IdentityConfig
            var result = await SignInManager.TwoFactorSignInAsync(model.Provider, model.Code, isPersistent: model.RememberMe, rememberBrowser: model.RememberBrowser);
            switch (result)
            {
                case SignInStatus.Success:
                    return RedirectToLocal(model.ReturnUrl);

                case SignInStatus.LockedOut:
                    return View("Lockout");

                case SignInStatus.Failure:
                default:
                    ModelState.AddModelError("", "Invalid code.");
                    return View(model);
            }
        }

        //
        //// GET: /Account/Register
        //[AllowAnonymous]
        //public ActionResult Register()
        //{
        //    return View();
        //}


        //
        // GET: /Account/Register
        [AllowAnonymous]
        public ActionResult Register(string email, string id, string check)
        {
            string codificado = Cifrado.Encrypt(email + id.ToString());
            Nova.Models.RegisterViewModel model = new Nova.Models.RegisterViewModel();
            if (HttpUtility.UrlDecode(check) == codificado)
            //  if (check == codificado)
            {

                model.Email = email;
            }
            else
                throw new ApplicationException("La página no es valida");

            return View(model);

        }



        //
        // POST: /Account/Register
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> Register(RegisterViewModel model)
        {
            if (ModelState.IsValid)
            {
                var status = SeguridadAlumnos.Alumnos.Instance.ValidateUser(model.Email);
                if (!status.Success)
                {


                    AddErrors(IdentityResult.Failed("No existe el correo electronico en nuestra base de datos, te sugerimos verificar con tu oficina de control escolar tu cuenta y/o actualizar tu información"));
                }
                else
                {
                    var user = new ApplicationUserAlumnos { UserName = model.Email, Email = model.Email };
                    
                    var result = await UserManager.CreateAsync(user, model.Password);
                    
                    if (result.Succeeded)
                    {
                       

                       // var x =SeguridadAlumnos.Alumnos.Instance.Logeado(user.Email).Curp;
                        // For more information on how to enable account confirmation and password reset please visit http://go.microsoft.com/fwlink/?LinkID=320771
                        // Send an email with this link
                        // string code = await UserManager.GenerateEmailConfirmationTokenAsync(user.Id);
                        // var callbackUrl = Url.Action("ConfirmEmail", "Account", new { userId = user.Id, code = code }, protocol: Request.Url.Scheme);
                        // await UserManager.SendEmailAsync(user.Id, "Confirm your account", "Please confirm your account by clicking <a href=\"" + callbackUrl + "\">here</a>");

                        return RedirectToAction("Login", "Alumnos");
                    }
                    AddErrors(result);
                }
            }
            // If we got this far, something failed, redisplay form
            return View(model);
        }

        //
        // GET: /Account/ConfirmEmail
        [AllowAnonymous]
        public async Task<ActionResult> ConfirmEmail(string userId, string code)
        {
            if (userId == null || code == null)
            {
                return View("Error");
            }
            var result = await UserManager.ConfirmEmailAsync(userId, code);
            return View(result.Succeeded ? "ConfirmEmail" : "Error");
        }

        //
        // GET: /Account/ForgotPassword
        [AllowAnonymous]
        public ActionResult ForgotPassword()
        {
            return View();
        }

            [HttpPost]
        [AllowAnonymous]
        public JsonResult ValidateUser(string email)
        {
            email = email.Trim();
            

           var status=  SeguridadAlumnos.Alumnos.Instance.ValidateUser(email);
          
          if (status.Success)
                if (EnviarEmailActivacion(email,status.Curp))
                {
                    status.Message = "Se ha enviado un mail a la siguiente direccíon: " + email + " , revisa tu bandeja de entrada en unos minutos y sigue las instrucciones para poder activar tu cuenta (IMPORTANTE: revisa también tu bandeja de spam o correo no deseado)";
                    status.Success = true;
                    status.TargetURL = FormsAuthentication.LoginUrl;
                }
                else
                {
                    status.Message = "No se ha podido enviar el email a su cuenta por favor intente más tarde";
                    status.Success = false;
                }
                
            
                
            
           
            return Json(status);
        }


            private bool EnviarEmailActivacion(string email, string curp)
            {
                bool regresa = true;
                MailMessage msg = new MailMessage();

                msg.From = new MailAddress("sistemas@cecyteo.edu.mx");
                msg.To.Add(email);
                msg.Subject = "Activación de cuenta Alumnos";
                msg.IsBodyHtml = true;
                string codificado = Cifrado.Encrypt(email + curp);

                UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);

                string url = HttpContext.Request.Url.Scheme + "://" + HttpContext.Request.Url.Authority + u.Action("Register", "Alumnos", new { email = email, id = curp, check = HttpUtility.UrlEncode(codificado) });

                msg.Body = @"<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional //Es' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'><html xmlns='http://www.w3.org/1999/xhtml' xmlns:v='urn:schemas-microsoft-com:vml' xmlns:o='urn:schemas-microsoft-com:office:office'><head>
  <!--[if gte mso 9]><xml>
   <o:OfficeDocumentSettings>
    <o:AllowPNG/>
    <o:PixelsPerInch>96</o:PixelsPerInch>
   </o:OfficeDocumentSettings>
  </xml><![endif]-->
  <meta http-equiv='Content-Type' content='text/html; charset=utf-8'>
  <meta name='viewport' content='width=device-width'>
  <meta http-equiv='X-UA-Compatible' content='IE=9; IE=8; IE=7; IE=EDGE'>
  <title>Cecyteo</title>
  
  
  <style id='media-query'>
    /* Client-specific Styles & Reset */
    #outlook a {
        padding: 0;
    }

    /* .ExternalClass applies to Outlook.com (the artist formerly known as Hotmail) */
    .ExternalClass {
        width: 100%;
    }

    .ExternalClass,
    .ExternalClass p,
    .ExternalClass span,
    .ExternalClass font,
    .ExternalClass td,
    .ExternalClass div {
        line-height: 100%;
    }

    #backgroundTable {
        margin: 0;
        padding: 0;
        width: 100% !important;
        line-height: 100% !important;
    }

    /* Buttons */
    .button a {
        display: inline-block;
        text-decoration: none;
        -webkit-text-size-adjust: none;
        text-align: center;
    }

    .button a div {
        text-align: center !important;
    }

    /* Outlook First */
    body.outlook p {
        display: inline !important;
    }

    a[x-apple-data-detectors] {
  color: inherit !important;
  text-decoration: none !important;
  font-size: inherit !important;
  font-family: inherit !important;
  font-weight: inherit !important;
  line-height: inherit !important; }

.btn {
  background: #3498db;
  background-image: -webkit-linear-gradient(top, #3498db, #2980b9);
  background-image: -moz-linear-gradient(top, #3498db, #2980b9);
  background-image: -ms-linear-gradient(top, #3498db, #2980b9);
  background-image: -o-linear-gradient(top, #3498db, #2980b9);
  background-image: linear-gradient(to bottom, #3498db, #2980b9);
  -webkit-border-radius: 28;
  -moz-border-radius: 28;
  border-radius: 28px;
  font-family: Arial;
  color: #ffffff;
  font-size: 20px;
  padding: 10px 20px 10px 20px;
  text-decoration: none;
}

.btn:hover {
  background: #3cb0fd;
  background-image: -webkit-linear-gradient(top, #3cb0fd, #3498db);
  background-image: -moz-linear-gradient(top, #3cb0fd, #3498db);
  background-image: -ms-linear-gradient(top, #3cb0fd, #3498db);
  background-image: -o-linear-gradient(top, #3cb0fd, #3498db);
  background-image: linear-gradient(to bottom, #3cb0fd, #3498db);
  text-decoration: none;
}
/*  Media Queries */
@media only screen and (max-width: 500px) {
  table[class='body'] img {
    height: auto !important;
    width: 100% !important; }
  table[class='body'] img.fullwidth {
    max-width: 100% !important; }
  table[class='body'] center {
    min-width: 0 !important; }
  table[class='body'] .container {
    width: 95% !important; }
  table[class='body'] .row {
    width: 100% !important;
    display: block !important; }
  table[class='body'] .wrapper {
    display: block !important;
    padding-right: 0 !important; }
  table[class='body'] .columns, table[class='body'] .column {
    table-layout: fixed !important;
    float: none !important;
    width: 100% !important;
    padding-right: 0px !important;
    padding-left: 0px !important;
    display: block !important; }
  table[class='body'] .wrapper.first .columns, table[class='body'] .wrapper.first .column {
    display: table !important; }
  table[class='body'] table.columns td, table[class='body'] table.column td, .col {
    width: 100% !important; }
  table[class='body'] table.columns td.expander {
    width: 1px !important; }
  table[class='body'] .right-text-pad, table[class='body'] .text-pad-right {
    padding-left: 10px !important; }
  table[class='body'] .left-text-pad, table[class='body'] .text-pad-left {
    padding-right: 10px !important; }
  table[class='body'] .hide-for-small, table[class='body'] .show-for-desktop {
    display: none !important; }
  table[class='body'] .show-for-small, table[class='body'] .hide-for-desktop {
    display: inherit !important; }
  .mixed-two-up .col {
    width: 100% !important; } }
 @media screen and (max-width: 500px) {
      div[class='col'] {
          width: 100% !important;
      }
    }

    @media screen and (min-width: 501px) {
      table[class='container'] {
          width: 500px !important;
      }
    }
  </style>
</head>
<body style='width: 100% !important;min-width: 100%;-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100% !important;margin: 0;padding: 0;background-color: #FFFFFF'>
  <table cellpadding='0' cellspacing='0' width='100%' class='body' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;height: 100%;width: 100%;table-layout: fixed'>
      <tbody><tr style='vertical-align: top'>
          <td class='center' align='center' valign='top' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: center;background-color: #FFFFFF'>

              <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
                <tbody><tr style='vertical-align: top'>
                  <td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: #EDEDED'>
                    <!--[if gte mso 9]>
                    <table id='outlookholder' border='0' cellspacing='0' cellpadding='0' align='center'><tr><td>
                    <![endif]-->
                    <!--[if (IE)]>
                    <table width='500' align='center' cellpadding='0' cellspacing='0' border='0'>
                        <tr>
                            <td>
                    <![endif]-->
                    <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' class='container' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit'><tbody><tr style='vertical-align: top'><td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'><table cellpadding='0' cellspacing='0' width='100%' bgcolor='transparent' class='block-grid two-up' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;width: 100%;max-width: 500px;color: #333;background-color: transparent'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;text-align: center;font-size: 0'><!--[if (gte mso 9)|(IE)]><table width='100%' align='center' bgcolor='transparent' cellpadding='0' cellspacing='0' border='0'><tr><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='250' style='width:250px;'><![endif]--><div class='col num6' style='display: inline-block;vertical-align: top;text-align: center;width: 250px'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 20px;padding-right: 0px;padding-bottom: 5px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table cellpadding='0' cellspacing='0' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
    <tbody><tr style='vertical-align: top'>
        <td align='center' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;width: 100%;padding-top: 0px;padding-right: 0px;padding-bottom: 0px;padding-left: 0px'>
            <div align='center' style='font-size:12px'>
                <a href='https://www.cecyteo.edu.mx' target='_blank'>
                    <img class='center' align='center' border='0' src='https://www.cecyteo.edu.mx/Nova/App_Themes/Site2015/img/icons/logo.png' alt='Image' title='Image' style='outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block;border: none;height: auto;line-height: 100%;margin: 0 auto;float: none;width: 100% !important;max-width: 174px' width='174'>
                </a>

            </div>
        </td>
    </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='250' style='width:250px;'><![endif]--><div class='col num6' style='display: inline-block;vertical-align: top;text-align: center;width: 250px'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 20px;padding-right: 0px;padding-bottom: 20px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 20px;padding-right: 10px;padding-bottom: 20px;padding-left: 10px'>
      <div style='color:#6E6F7A;line-height:150%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
      	<div style='line-height:18px;font-size:12px;color:#6E6F7A;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;text-align:left;'><div style='text-align: right; line-height:18px; font-size:12px;'><strong><span style='font-size: 16px; line-height: 24px;'>Colegio de Estudios Científicos y Tecnológicos del Estado de Oaxaca</span></strong></div></div>
      </div>
    </td>
  </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]--></td></tr></tbody></table></td></tr></tbody></table>
                    <!--[if mso]>
                    </td></tr></table>
                    <![endif]-->
                    <!--[if (IE)]>
                    </td></tr></table>
                    <![endif]-->
                  </td>
                </tr>
              </tbody></table>
              <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
                <tbody><tr style='vertical-align: top'>
                  <td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: #BBBBBB'>
                    <!--[if gte mso 9]>
                    <table id='outlookholder' border='0' cellspacing='0' cellpadding='0' align='center'><tr><td>
                    <![endif]-->
                    <!--[if (IE)]>
                    <table width='500' align='center' cellpadding='0' cellspacing='0' border='0'>
                        <tr>
                            <td>
                    <![endif]-->
                    <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' class='container' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit'><tbody><tr style='vertical-align: top'><td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'><table cellpadding='0' cellspacing='0' width='100%' bgcolor='transparent' class='block-grid ' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;width: 100%;max-width: 500px;color: #333;background-color: transparent'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;text-align: center;font-size: 0'><!--[if (gte mso 9)|(IE)]><table width='100%' align='center' bgcolor='transparent' cellpadding='0' cellspacing='0' border='0'><tr><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='500' style='width:500px;'><![endif]--><div class='col num12' style='display: inline-block;vertical-align: top;width: 100%'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 30px;padding-right: 0px;padding-bottom: 30px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 25px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='color:#ffffff;line-height:120%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
      	<div style='line-height:14px;font-size:12px;color:#ffffff;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;text-align:left;'><p style='margin: 0;font-size: 18px;line-height: 22px;text-align: center'><span style='font-size: 24px; line-height: 28px;'><strong>Estimado alumno has solicitado la activación de tu cuenta para poder ingresar al sistema del Colegio, para poder completar el proceso da click en el siguiente link</strong></span></p></div>
      </div>
    </td>
  </tr>
</tbody></table>
<table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 0px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='color:#000;line-height:150%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>

      	<div style='font-size:14px;line-height:21px;text-align:center;color:#000;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'><p style='margin-top: 60px;font-size: 14px;line-height: 21px;text-align: center'><a class='btn' href='" + url + @"' target='_blank'> Activar mi cuenta</a></p></div><div style='font-size:14px;line-height:21px;text-align:center;color:#000;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
<p></p>
<p style='margin: 0;font-size: 14px;line-height: 21px;text-align: center'><span style='font-size: 14px; line-height: 21px;'>Te recordamos que tu cuenta es personal e intransferible.</span></p></div><div style='font-size:14px;line-height:21px;text-align:center;color:#000;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'><p style='margin: 0;font-size: 14px;line-height: 21px;text-align: center'><span style='font-size: 14px; line-height: 21px;'></span></p></div>
      </div>
    </td>
  </tr>
</tbody></table>
 
<table align='center' width='100%' border='0' cellpadding='0' cellspacing='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td align='center' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 10px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='height: 0px;'>
        <table align='center' border='0' cellspacing='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;border-top: 0px solid transparent;width: 100%'><tbody><tr style='vertical-align: top'><td align='center' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'></td></tr></tbody></table>
      </div>
    </td>
  </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]--></td></tr></tbody></table></td></tr></tbody></table>
                    <!--[if mso]>
                    </td></tr></table>
                    <![endif]-->
                    <!--[if (IE)]>
                    </td></tr></table>
                    <![endif]-->
                  </td>
                </tr>
              </tbody></table>
              <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
                <tbody><tr style='vertical-align: top'>
                  <td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: #ffffff'>
                    <!--[if gte mso 9]>
                    <table id='outlookholder' border='0' cellspacing='0' cellpadding='0' align='center'><tr><td>
                    <![endif]-->
                    <!--[if (IE)]>
                    <table width='500' align='center' cellpadding='0' cellspacing='0' border='0'>
                        <tr>
                            <td>
                    <![endif]-->
                    <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' class='container' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit'><tbody><tr style='vertical-align: top'><td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'><table cellpadding='0' cellspacing='0' width='100%' bgcolor='transparent' class='block-grid ' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;width: 100%;max-width: 500px;color: #333;background-color: transparent'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;text-align: center;font-size: 0'><!--[if (gte mso 9)|(IE)]><table width='100%' align='center' bgcolor='transparent' cellpadding='0' cellspacing='0' border='0'><tr><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='500' style='width:500px;'><![endif]--><div class='col num12' style='display: inline-block;vertical-align: top;width: 100%'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 30px;padding-right: 0px;padding-bottom: 30px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table width='100%' border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td align='center' valign='top' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>
      <table border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
        <tbody><tr style='vertical-align: top'>
          <td align='center' valign='top' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: center;padding-top: 10px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px;max-width: 114px'>

            <!--[if (gte mso 9)|(IE)]>
            <table width='94' align='left' border='0' cellspacing='0' cellpadding='0'>
              <tr>
                <td align='left'>
            <![endif]-->
            <table width='100%' align='left' cellpadding='0' cellspacing='0' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
              <tbody><tr style='vertical-align: top'>
                <td align='left' valign='middle' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>


                  <table align='left' border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;padding: 0 5px 5px 0' height='37'>
                    <tbody><tr style='vertical-align: top'>
                      <td width='37' align='left' valign='middle' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>
                        <a href='https://www.facebook.com/CECyTEOaxaca' title='Facebook' target='_blank'>
                          <img src='https://www.cecyteo.edu.mx/Nova/App_Themes/Site2015/img/facebook.png' alt='Facebook' title='Facebook' width='32' style='outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block;border: none;height: auto;line-height: 100%;max-width: 32px !important'>
                        </a>
                      </td>
                    </tr>
                  </tbody></table>
                  <table align='left' border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;padding: 0 5px 5px 0' height='37'>
                    <tbody><tr style='vertical-align: top'>
                      <td width='37' align='left' valign='middle' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>
                        <a href='http://twitter.com/cecyteoaxaca' title='Twitter' target='_blank'>
                          <img src='https://www.cecyteo.edu.mx/Nova/App_Themes/Site2015/img/twitter.png' alt='Twitter' title='Twitter' width='32' style='outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block;border: none;height: auto;line-height: 100%;max-width: 32px !important'>
                        </a>
                      </td>
                    </tr>
                  </tbody></table>

                </td>
              </tr>
            </tbody></table>
            <!--[if (gte mso 9)|(IE)]>
                </td>
              </tr>
            </table>
            <![endif]-->
          </td>
        </tr>
      </tbody></table>
    </td>
  </tr>
</tbody></table>
<table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 15px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='color:#959595;line-height:150%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
      	<div style='line-height:18px;font-size:12px;color:#959595;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;text-align:left;'>
          <p style='margin: 0;font-size: 12px;line-height: 21px;text-align: center'>Este correo ha sido generado de forma automática.</p>
              <p style='margin: 0;font-size: 14px;line-height: 21px;text-align: center'>Gobierno del Estado de Oaxaca.</p>
          </div>
      </div>
    </td>
  </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]--></td></tr></tbody></table></td></tr></tbody></table>
                    <!--[if mso]>
                    </td></tr></table>
                    <![endif]-->
                    <!--[if (IE)]>
                    </td></tr></table>
                    <![endif]-->
                  </td>
                </tr>
              </tbody></table>
          </td>
      </tr>
  </tbody></table>


</body></html>";
                //msg.Body = "<p>Estimado Trabajador</p><strong></strong><p>Para activar su cuenta para acceso al sistema NOVA del CECYTEO de clic en la siguiente liga <a href='" + url + "'>clic aquí</a> ";

                //msg.Body = msg.Body + " <p></p><p><strong>Cualquier duda o aclaración con este proceso favor de dirigirse con el Departamento de Sistemas a los teléfonos : (951) 666-666  ext. 666 de 08:00 a 16:00 horas de Lunes a Viernes.</strong></p> ";

                //msg.Body = msg.Body + " <p></p><p>Este correo fue generado automáticamente, favor de no responder.</p>";


                //  msg.Priority = MailPriority.High;

                SmtpClient client = new SmtpClient();


                client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
                client.Host = "smtp.gmail.com";
                client.Port = 587;
                client.DeliveryMethod = SmtpDeliveryMethod.Network;
                client.EnableSsl = true;
                // client.UseDefaultCredentials = false;

                try
                {
                    client.Send(msg);

                }
                catch (Exception)
                {
                    regresa = false;
                    // throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
                }
                return regresa;
            }

        private bool EnviarMailRestablecerContraseña(string mailusuario, string url)
        {
            bool regresa = true;

            string mail = @"<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional //Es' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'><html xmlns='http://www.w3.org/1999/xhtml' xmlns:v='urn:schemas-microsoft-com:vml' xmlns:o='urn:schemas-microsoft-com:office:office'><head>
  <!--[if gte mso 9]><xml>
   <o:OfficeDocumentSettings>
    <o:AllowPNG/>
    <o:PixelsPerInch>96</o:PixelsPerInch>
   </o:OfficeDocumentSettings>
  </xml><![endif]-->
  <meta http-equiv='Content-Type' content='text/html; charset=utf-8'>
  <meta name='viewport' content='width=device-width'>
  <meta http-equiv='X-UA-Compatible' content='IE=9; IE=8; IE=7; IE=EDGE'>
  <title>Cecyteo</title>
  
  
  <style id='media-query'>
    /* Client-specific Styles & Reset */
    #outlook a {
        padding: 0;
    }

    /* .ExternalClass applies to Outlook.com (the artist formerly known as Hotmail) */
    .ExternalClass {
        width: 100%;
    }

    .ExternalClass,
    .ExternalClass p,
    .ExternalClass span,
    .ExternalClass font,
    .ExternalClass td,
    .ExternalClass div {
        line-height: 100%;
    }

    #backgroundTable {
        margin: 0;
        padding: 0;
        width: 100% !important;
        line-height: 100% !important;
    }

    /* Buttons */
    .button a {
        display: inline-block;
        text-decoration: none;
        -webkit-text-size-adjust: none;
        text-align: center;
    }

    .button a div {
        text-align: center !important;
    }

    /* Outlook First */
    body.outlook p {
        display: inline !important;
    }

    a[x-apple-data-detectors] {
  color: inherit !important;
  text-decoration: none !important;
  font-size: inherit !important;
  font-family: inherit !important;
  font-weight: inherit !important;
  line-height: inherit !important; }

.btn {
	background-color:#12b317;
	-moz-border-radius:28px;
	-webkit-border-radius:28px;
	border-radius:28px;
	border:1px solid #18ab29;
	display:inline-block;
	cursor:pointer;
	color:#ffffff;
	font-family:Arial;
	font-size:17px;
	padding:16px 31px;
	text-decoration:none;
	text-shadow:0px 1px 0px #2f6627;
}
.btn:hover {
	background-color:#5cbf2a;
}
.btn:active {
	position:relative;
	top:1px;
}

/*  Media Queries */
@media only screen and (max-width: 500px) {
  table[class='body'] img {
    height: auto !important;
    width: 100% !important; }
  table[class='body'] img.fullwidth {
    max-width: 100% !important; }
  table[class='body'] center {
    min-width: 0 !important; }
  table[class='body'] .container {
    width: 95% !important; }
  table[class='body'] .row {
    width: 100% !important;
    display: block !important; }
  table[class='body'] .wrapper {
    display: block !important;
    padding-right: 0 !important; }
  table[class='body'] .columns, table[class='body'] .column {
    table-layout: fixed !important;
    float: none !important;
    width: 100% !important;
    padding-right: 0px !important;
    padding-left: 0px !important;
    display: block !important; }
  table[class='body'] .wrapper.first .columns, table[class='body'] .wrapper.first .column {
    display: table !important; }
  table[class='body'] table.columns td, table[class='body'] table.column td, .col {
    width: 100% !important; }
  table[class='body'] table.columns td.expander {
    width: 1px !important; }
  table[class='body'] .right-text-pad, table[class='body'] .text-pad-right {
    padding-left: 10px !important; }
  table[class='body'] .left-text-pad, table[class='body'] .text-pad-left {
    padding-right: 10px !important; }
  table[class='body'] .hide-for-small, table[class='body'] .show-for-desktop {
    display: none !important; }
  table[class='body'] .show-for-small, table[class='body'] .hide-for-desktop {
    display: inherit !important; }
  .mixed-two-up .col {
    width: 100% !important; } }
 @media screen and (max-width: 500px) {
      div[class='col'] {
          width: 100% !important;
      }
    }

    @media screen and (min-width: 501px) {
      table[class='container'] {
          width: 500px !important;
      }
    }
  </style>
</head>
<body style='width: 100% !important;min-width: 100%;-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100% !important;margin: 0;padding: 0;background-color: #FFFFFF'>
  <table cellpadding='0' cellspacing='0' width='100%' class='body' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;height: 100%;width: 100%;table-layout: fixed'>
      <tbody><tr style='vertical-align: top'>
          <td class='center' align='center' valign='top' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: center;background-color: #FFFFFF'>

              <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
                <tbody><tr style='vertical-align: top'>
                  <td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: #EDEDED'>
                    <!--[if gte mso 9]>
                    <table id='outlookholder' border='0' cellspacing='0' cellpadding='0' align='center'><tr><td>
                    <![endif]-->
                    <!--[if (IE)]>
                    <table width='500' align='center' cellpadding='0' cellspacing='0' border='0'>
                        <tr>
                            <td>
                    <![endif]-->
                    <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' class='container' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit'><tbody><tr style='vertical-align: top'><td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'><table cellpadding='0' cellspacing='0' width='100%' bgcolor='transparent' class='block-grid two-up' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;width: 100%;max-width: 500px;color: #333;background-color: transparent'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;text-align: center;font-size: 0'><!--[if (gte mso 9)|(IE)]><table width='100%' align='center' bgcolor='transparent' cellpadding='0' cellspacing='0' border='0'><tr><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='250' style='width:250px;'><![endif]--><div class='col num6' style='display: inline-block;vertical-align: top;text-align: center;width: 250px'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 20px;padding-right: 0px;padding-bottom: 5px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table cellpadding='0' cellspacing='0' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
    <tbody><tr style='vertical-align: top'>
        <td align='center' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;width: 100%;padding-top: 0px;padding-right: 0px;padding-bottom: 0px;padding-left: 0px'>
            <div align='center' style='font-size:12px'>
                <a href='https://www.cecyteo.edu.mx' target='_blank'>
                    <img class='center' align='center' border='0' src='https://www.cecyteo.edu.mx/Nova/App_Themes/Site2015/img/icons/logo.png' alt='Image' title='Image' style='outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block;border: none;height: auto;line-height: 100%;margin: 0 auto;float: none;width: 100% !important;max-width: 174px' width='174'>
                </a>

            </div>
        </td>
    </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='250' style='width:250px;'><![endif]--><div class='col num6' style='display: inline-block;vertical-align: top;text-align: center;width: 250px'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 20px;padding-right: 0px;padding-bottom: 20px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 20px;padding-right: 10px;padding-bottom: 20px;padding-left: 10px'>
      <div style='color:#6E6F7A;line-height:150%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
      	<div style='line-height:18px;font-size:12px;color:#6E6F7A;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;text-align:left;'><div style='text-align: right; line-height:18px; font-size:12px;'><strong><span style='font-size: 16px; line-height: 24px;'>Colegio de Estudios Científicos y Tecnológicos del Estado de Oaxaca</span></strong></div></div>
      </div>
    </td>
  </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]--></td></tr></tbody></table></td></tr></tbody></table>
                    <!--[if mso]>
                    </td></tr></table>
                    <![endif]-->
                    <!--[if (IE)]>
                    </td></tr></table>
                    <![endif]-->
                  </td>
                </tr>
              </tbody></table>
              <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
                <tbody><tr style='vertical-align: top'>
                  <td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: #BBBBBB'>
                    <!--[if gte mso 9]>
                    <table id='outlookholder' border='0' cellspacing='0' cellpadding='0' align='center'><tr><td>
                    <![endif]-->
                    <!--[if (IE)]>
                    <table width='500' align='center' cellpadding='0' cellspacing='0' border='0'>
                        <tr>
                            <td>
                    <![endif]-->
                    <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' class='container' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit'><tbody><tr style='vertical-align: top'><td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'><table cellpadding='0' cellspacing='0' width='100%' bgcolor='transparent' class='block-grid ' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;width: 100%;max-width: 500px;color: #333;background-color: transparent'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;text-align: center;font-size: 0'><!--[if (gte mso 9)|(IE)]><table width='100%' align='center' bgcolor='transparent' cellpadding='0' cellspacing='0' border='0'><tr><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='500' style='width:500px;'><![endif]--><div class='col num12' style='display: inline-block;vertical-align: top;width: 100%'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 30px;padding-right: 0px;padding-bottom: 30px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 25px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='color:#ffffff;line-height:120%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
      	<div style='line-height:14px;font-size:12px;color:#ffffff;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;text-align:left;'><p style='margin: 0;font-size: 18px;line-height: 22px;text-align: center'><span style='font-size: 24px; line-height: 28px;'><strong>Estimado usuario de click en el siguiente enlace para completar el proceso</strong></span></p></div>
      </div>
    </td>
  </tr>
</tbody></table>
<table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 0px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='color:#B8B8C0;line-height:150%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
      	<div style='font-size:14px;line-height:21px;text-align:center;color:#B8B8C0;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'><p style='margin-top: 60px;font-size: 14px;line-height: 21px;text-align: center'><a class='btn' href='" + url + @"' target='_blank'> Restaurar Contraseña </a></p></div><div style='font-size:14px;line-height:21px;text-align:center;color:#B8B8C0;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'><p style='margin: 0;font-size: 14px;line-height: 21px;text-align: center'><span style='font-size: 14px; line-height: 21px;'></span></p></div><div style='font-size:14px;line-height:21px;text-align:center;color:#B8B8C0;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'><p style='margin: 0;font-size: 14px;line-height: 21px;text-align: center'><span style='font-size: 14px; line-height: 21px;'></span></p></div>
      </div>
    </td>
  </tr>
</tbody></table>
 
<table align='center' width='100%' border='0' cellpadding='0' cellspacing='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td align='center' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 10px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='height: 0px;'>
        <table align='center' border='0' cellspacing='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;border-top: 0px solid transparent;width: 100%'><tbody><tr style='vertical-align: top'><td align='center' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'></td></tr></tbody></table>
      </div>
    </td>
  </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]--></td></tr></tbody></table></td></tr></tbody></table>
                    <!--[if mso]>
                    </td></tr></table>
                    <![endif]-->
                    <!--[if (IE)]>
                    </td></tr></table>
                    <![endif]-->
                  </td>
                </tr>
              </tbody></table>
              <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
                <tbody><tr style='vertical-align: top'>
                  <td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: #ffffff'>
                    <!--[if gte mso 9]>
                    <table id='outlookholder' border='0' cellspacing='0' cellpadding='0' align='center'><tr><td>
                    <![endif]-->
                    <!--[if (IE)]>
                    <table width='500' align='center' cellpadding='0' cellspacing='0' border='0'>
                        <tr>
                            <td>
                    <![endif]-->
                    <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' class='container' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit'><tbody><tr style='vertical-align: top'><td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'><table cellpadding='0' cellspacing='0' width='100%' bgcolor='transparent' class='block-grid ' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;width: 100%;max-width: 500px;color: #333;background-color: transparent'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;text-align: center;font-size: 0'><!--[if (gte mso 9)|(IE)]><table width='100%' align='center' bgcolor='transparent' cellpadding='0' cellspacing='0' border='0'><tr><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='500' style='width:500px;'><![endif]--><div class='col num12' style='display: inline-block;vertical-align: top;width: 100%'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 30px;padding-right: 0px;padding-bottom: 30px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table width='100%' border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td align='center' valign='top' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>
      <table border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
        <tbody><tr style='vertical-align: top'>
          <td align='center' valign='top' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: center;padding-top: 10px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px;max-width: 114px'>

            <!--[if (gte mso 9)|(IE)]>
            <table width='94' align='left' border='0' cellspacing='0' cellpadding='0'>
              <tr>
                <td align='left'>
            <![endif]-->
            <table width='100%' align='left' cellpadding='0' cellspacing='0' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
              <tbody><tr style='vertical-align: top'>
                <td align='left' valign='middle' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>


                  <table align='left' border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;padding: 0 5px 5px 0' height='37'>
                    <tbody><tr style='vertical-align: top'>
                      <td width='37' align='left' valign='middle' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>
                        <a href='https://www.facebook.com/CECyTEOaxaca' title='Facebook' target='_blank'>
                          <img src='https://www.cecyteo.edu.mx/Nova/App_Themes/Site2015/img/facebook.png' alt='Facebook' title='Facebook' width='32' style='outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block;border: none;height: auto;line-height: 100%;max-width: 32px !important'>
                        </a>
                      </td>
                    </tr>
                  </tbody></table>
                  <table align='left' border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;padding: 0 5px 5px 0' height='37'>
                    <tbody><tr style='vertical-align: top'>
                      <td width='37' align='left' valign='middle' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>
                        <a href='http://twitter.com/cecyteoaxaca' title='Twitter' target='_blank'>
                          <img src='https://www.cecyteo.edu.mx/Nova/App_Themes/Site2015/img/twitter.png' alt='Twitter' title='Twitter' width='32' style='outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block;border: none;height: auto;line-height: 100%;max-width: 32px !important'>
                        </a>
                      </td>
                    </tr>
                  </tbody></table>

                </td>
              </tr>
            </tbody></table>
            <!--[if (gte mso 9)|(IE)]>
                </td>
              </tr>
            </table>
            <![endif]-->
          </td>
        </tr>
      </tbody></table>
    </td>
  </tr>
</tbody></table>
<table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 15px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='color:#959595;line-height:150%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
      	<div style='line-height:18px;font-size:12px;color:#959595;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;text-align:left;'>
          <p style='margin: 0;font-size: 12px;line-height: 21px;text-align: center'>Este correo ha sido generado de forma automática.</p>
              <p style='margin: 0;font-size: 14px;line-height: 21px;text-align: center'>Gobierno del Estado de Oaxaca.</p>
          </div>
      </div>
    </td>
  </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]--></td></tr></tbody></table></td></tr></tbody></table>
                    <!--[if mso]>
                    </td></tr></table>
                    <![endif]-->
                    <!--[if (IE)]>
                    </td></tr></table>
                    <![endif]-->
                  </td>
                </tr>
              </tbody></table>
          </td>
      </tr>
  </tbody></table>


</body></html>";
  

            MailMessage msg = new MailMessage();

            msg.From = new MailAddress("sistemas@cecyteo.edu.mx");
            msg.To.Add(mailusuario);
            msg.Subject = "Restablecer clave";
            msg.IsBodyHtml = true;


            UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);



            msg.Body = mail;
            SmtpClient client = new SmtpClient();


            client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
            client.Host = "smtp.gmail.com";
            client.Port = 587;
            client.DeliveryMethod = SmtpDeliveryMethod.Network;
            client.EnableSsl = true;
            // client.UseDefaultCredentials = false;




            try
            {
                client.Send(msg);

            }
            catch (Exception)
            {
                regresa = false;
                // throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
            }
            return regresa;


        }
        //
        // POST: /Account/ForgotPassword
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<JsonResult> ForgotPassword(ForgotPasswordViewModel model)
        {
            if (ModelState.IsValid)
            {
                var user = await UserManager.FindByNameAsync(model.Email);
                if (user == null)
                //if (user == null || !(await UserManager.IsEmailConfirmedAsync(user.Id)))
                {
                    // No revelar que el usuario no existe o que no está confirmado
                    //return View("NoExisteMail");
                    return Json(new { Success = false, Message = "La cuenta de correo electrónico no existe en nuestra base de datos" }, JsonRequestBehavior.AllowGet);
                }

                else
                {
                    // Para obtener más información sobre cómo habilitar la confirmación de cuenta y el restablecimiento de contraseña, visite http://go.microsoft.com/fwlink/?LinkID=320771
                    // Enviar correo electrónico con este vínculo
                    string code = await UserManager.GeneratePasswordResetTokenAsync(user.Id);
                    var callbackUrl = Url.Action("ResetPassword", "Alumnos", new { Email = user.UserName, code = code }, protocol: Request.Url.Scheme);
                    //await UserManager.SendEmailAsync(user.Id, "Restablecer contraseña", "Estimado usuario: Para poder restablecer su  contraseña, haga clic <a href=\"" + callbackUrl + "\">aquí</a>");


                    //MailMessage msg = new MailMessage();

                    //msg.From = new MailAddress("sistemas@cecyteo.edu.mx");
                    //msg.To.Add(user.Email);
                    //msg.Subject = "Restablecer clave";
                    //msg.IsBodyHtml = true;


                    //UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);



                    //msg.Body = "Estimado usuario: Para poder restablecer su  contraseña, haga clic <a href=\"" + callbackUrl + "\">aquí</a>";
                    //SmtpClient client = new SmtpClient();


                    //client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
                    //client.Host = "smtp.gmail.com";
                    //client.Port = 587;
                    //client.DeliveryMethod = SmtpDeliveryMethod.Network;
                    //client.EnableSsl = true;



                    if (EnviarMailRestablecerContraseña(user.UserName, callbackUrl) == false)
                    {

                        //                    throw new Exception(" El mail no ha podido ser enviado , intente más tarde");

                        return Json(new { Success = false, Message = " El correo electrónico  no ha podido ser enviado , intenta más tarde" }, JsonRequestBehavior.AllowGet);
                    }
                    else


                        // return RedirectToAction("ForgotPasswordConfirmation", "Account");

                        return Json(new { Success = true, Message = " El correo electrónico  ha sido enviado exitosamente, en unos minutos revisa su bandeja de entrada o correo no deseado para completar el proceso." }, JsonRequestBehavior.AllowGet);
                }
            }
            else
            {
                string validationErrors = string.Join(",",
                    ModelState.Values.Where(E => E.Errors.Count > 0)
                    .SelectMany(E => E.Errors)
                    .Select(E => E.ErrorMessage)
                    .ToArray());
                return Json(new { Success = false, Message = validationErrors }, JsonRequestBehavior.AllowGet);
            }

            // Si llegamos a este punto, es que se ha producido un error y volvemos a mostrar el formulario
            //return View(model);
            // return resultadofinal
        }

       

        ////
        //// POST: /Account/ForgotPassword
        //[HttpPost]
        //[AllowAnonymous]
        //[ValidateAntiForgeryToken]
        //public async Task<ActionResult> ForgotPassword(ForgotPasswordViewModel model)
        //{
        //    if (ModelState.IsValid)
        //    {
        //        var user = await UserManager.FindByNameAsync(model.Email);
        //        if (user == null || !(await UserManager.IsEmailConfirmedAsync(user.Id)))
        //        {
        //            // Don't reveal that the user does not exist or is not confirmed
        //            return View("ForgotPasswordConfirmation");
        //        }

        //        // For more information on how to enable account confirmation and password reset please visit http://go.microsoft.com/fwlink/?LinkID=320771
        //        // Send an email with this link
        //        // string code = await UserManager.GeneratePasswordResetTokenAsync(user.Id);
        //        // var callbackUrl = Url.Action("ResetPassword", "Account", new { userId = user.Id, code = code }, protocol: Request.Url.Scheme);
        //        // await UserManager.SendEmailAsync(user.Id, "Reset Password", "Please reset your password by clicking <a href=\"" + callbackUrl + "\">here</a>");
        //        // return RedirectToAction("ForgotPasswordConfirmation", "Account");
        //    }

        //    // If we got this far, something failed, redisplay form
        //    return View(model);
        //}

        //
        // GET: /Account/ForgotPasswordConfirmation
        [AllowAnonymous]
        public ActionResult ForgotPasswordConfirmation()
        {
            return View();
        }

        //
        // GET: /Account/ResetPassword
        [AllowAnonymous]
        public ActionResult ResetPassword(string Email, string code)
        {
            return code == null ? View("Error") : View();
        }

        ////
        //// POST: /Account/ResetPassword
        //[HttpPost]
        //[AllowAnonymous]
        //[ValidateAntiForgeryToken]
        //public async Task<ActionResult> ResetPassword(ResetPasswordViewModel model)
        //{
        //    if (!ModelState.IsValid)
        //    {
        //        return View(model);
        //    }
        //    var user = await UserManager.FindByNameAsync(model.Email);
        //    if (user == null)
        //    {
        //        // Don't reveal that the user does not exist
        //        return RedirectToAction("ResetPasswordConfirmation", "Account");
        //    }
        //    var result = await UserManager.ResetPasswordAsync(user.Id, model.Code, model.Password);
        //    if (result.Succeeded)
        //    {
        //        return RedirectToAction("ResetPasswordConfirmation", "Account");
        //    }
        //    AddErrors(result);
        //    return View();
        //}

        //
        // POST: /Account/ResetPassword
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> ResetPassword(Nova.Models.ResetPasswordViewModel model)
        {
            ViewBag.Success = 0;
            if (!ModelState.IsValid)
            {
                return View(model);
            }
            var user = await UserManager.FindByNameAsync(model.Email);

            if (user == null)
            {
                // No revelar que el usuario no existe
                //return RedirectToAction("ResetPasswordConfirmation", "Account");
                View("Error");
            }
            var code = await UserManager.GeneratePasswordResetTokenAsync(user.Id);
            
            var result = await UserManager.ResetPasswordAsync(user.Id, code, model.Password);
            if (result.Succeeded)
            {
                ViewBag.Success = 1;
                return View();
            }
            AddErrors(result);
            return View();
        }

        //
        // GET: /Account/ResetPasswordConfirmation
        [AllowAnonymous]
        public ActionResult ResetPasswordConfirmation()
        {
            return View();
        }

        //
        // POST: /Account/ExternalLogin
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public ActionResult ExternalLogin(string provider, string returnUrl)
        {
            // Request a redirect to the external login provider
            return new ChallengeResult(provider, Url.Action("ExternalLoginCallback", "Account", new { ReturnUrl = returnUrl }));
        }

        //
        // GET: /Account/SendCode
        [AllowAnonymous]
        public async Task<ActionResult> SendCode(string returnUrl, bool rememberMe)
        {
            var userId = await SignInManager.GetVerifiedUserIdAsync();
            if (userId == null)
            {
                return View("Error");
            }
            var userFactors = await UserManager.GetValidTwoFactorProvidersAsync(userId);
            var factorOptions = userFactors.Select(purpose => new SelectListItem { Text = purpose, Value = purpose }).ToList();
            return View(new SendCodeViewModel { Providers = factorOptions, ReturnUrl = returnUrl, RememberMe = rememberMe });
        }

        //
        // POST: /Account/SendCode
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> SendCode(SendCodeViewModel model)
        {
            if (!ModelState.IsValid)
            {
                return View();
            }

            // Generate the token and send it
            if (!await SignInManager.SendTwoFactorCodeAsync(model.SelectedProvider))
            {
                return View("Error");
            }
            return RedirectToAction("VerifyCode", new { Provider = model.SelectedProvider, ReturnUrl = model.ReturnUrl, RememberMe = model.RememberMe });
        }

        //
        // GET: /Account/ExternalLoginCallback
        [AllowAnonymous]
        public async Task<ActionResult> ExternalLoginCallback(string returnUrl)
        {
            var loginInfo = await AuthenticationManager.GetExternalLoginInfoAsync();
            if (loginInfo == null)
            {
                return RedirectToAction("Login");
            }

            // Sign in the user with this external login provider if the user already has a login
            var result = await SignInManager.ExternalSignInAsync(loginInfo, isPersistent: false);
            switch (result)
            {
                case SignInStatus.Success:
                    return RedirectToLocal(returnUrl);

                case SignInStatus.LockedOut:
                    return View("Lockout");

                case SignInStatus.RequiresVerification:
                    return RedirectToAction("SendCode", new { ReturnUrl = returnUrl, RememberMe = false });

                case SignInStatus.Failure:
                default:
                    // If the user does not have an account, then prompt the user to create an account
                    ViewBag.ReturnUrl = returnUrl;
                    ViewBag.LoginProvider = loginInfo.Login.LoginProvider;
                    return View("ExternalLoginConfirmation", new ExternalLoginConfirmationViewModel { Email = loginInfo.Email });
            }
        }

        //
        // POST: /Account/ExternalLoginConfirmation
        [HttpPost]
        [AllowAnonymous]
        [ValidateAntiForgeryToken]
        public async Task<ActionResult> ExternalLoginConfirmation(ExternalLoginConfirmationViewModel model, string returnUrl)
        {
            if (User.Identity.IsAuthenticated)
            {
                return RedirectToAction("Index", "Manage");
            }

            if (ModelState.IsValid)
            {
                // Get the information about the user from the external login provider
                var info = await AuthenticationManager.GetExternalLoginInfoAsync();
                if (info == null)
                {
                    return View("ExternalLoginFailure");
                }
                var user = new ApplicationUserAlumnos { UserName = model.Email, Email = model.Email };
                var result = await UserManager.CreateAsync(user);
                if (result.Succeeded)
                {
                    result = await UserManager.AddLoginAsync(user.Id, info.Login);
                    if (result.Succeeded)
                    {
                        await SignInManager.SignInAsync(user, isPersistent: false, rememberBrowser: false);
                        return RedirectToLocal(returnUrl);
                    }
                }
                AddErrors(result);
            }

            ViewBag.ReturnUrl = returnUrl;
            return View(model);
        }

        //
        // POST: /Account/LogOff
        [HttpPost]
        [ValidateAntiForgeryToken]
        [AllowAnonymous]
        public ActionResult LogOff()
        {
            AuthenticationManager.SignOut(DefaultAuthenticationTypes.ApplicationCookie);
            return RedirectToAction("Login", "Alumnos");
        }

        //
        // GET: /Account/ExternalLoginFailure
        [AllowAnonymous]
        public ActionResult ExternalLoginFailure()
        {
            return View();
        }

          
        

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (_userManager != null)
                {
                    _userManager.Dispose();
                    _userManager = null;
                }

                if (_signInManager != null)
                {
                    _signInManager.Dispose();
                    _signInManager = null;
                }
            }

            base.Dispose(disposing);
        }

        #region Helpers

        // Used for XSRF protection when adding external logins
        private const string XsrfKey = "XsrfId";

        private IAuthenticationManager AuthenticationManager
        {
            get
            {
                return HttpContext.GetOwinContext().Authentication;
            }
        }

        private void AddErrors(IdentityResult result)
        {
            int d = 0;

            foreach (var error in result.Errors)
            {
                d++;
                if (d < 2)
                {
                    if (error.StartsWith("Passwords must have at least one non letter or digit"))
                    {
                        //var NameToEmail = Regex.Replace(error, "Name", "Email");
                        ModelState.AddModelError("", "El password deberá de contener al menos un caracter especial");
                    }
                    else
                        if (error.StartsWith("Passwords must have at least one uppercase ('A'-'Z')"))
                    {
                        //var NameToEmail = Regex.Replace(error, "Name", "Email");
                        ModelState.AddModelError("", "El password deberá de contener al menos una letra MAYÚSCULA");
                    }
                    else
                            if (error.StartsWith("Passwords must have at least one lowercase"))
                    {
                        //var NameToEmail = Regex.Replace(error, "Name", "Email");
                        ModelState.AddModelError("", "El password deberá de contener al menos una letra minúscula");
                    }

                    else
                                if (error.StartsWith("Name"))
                    {
                        //var NameToEmail = Regex.Replace(error, "Name", "Email");
                        ModelState.AddModelError("", "Tu cuenta ya ha sido activada con anterioridad, si olvidaste tu contraseña puedes restablecerla para poder ingresar");
                    }


                    else
                    {
                        ModelState.AddModelError("", error);
                    }
                }
            }
        }


        private ActionResult RedirectToLocal(string returnUrl)
        {
            if (Url.IsLocalUrl(returnUrl))
            {
                return Redirect(returnUrl);
            }
            return RedirectToAction("Index", "Home");
        }

        internal class ChallengeResult : HttpUnauthorizedResult
        {
            public ChallengeResult(string provider, string redirectUri)
                : this(provider, redirectUri, null)
            {
            }

            public ChallengeResult(string provider, string redirectUri, string userId)
            {
                LoginProvider = provider;
                RedirectUri = redirectUri;
                UserId = userId;
            }

            public string LoginProvider { get; set; }
            public string RedirectUri { get; set; }
            public string UserId { get; set; }

            public override void ExecuteResult(ControllerContext context)
            {
                var properties = new AuthenticationProperties { RedirectUri = RedirectUri };
                if (UserId != null)
                {
                    properties.Dictionary[XsrfKey] = UserId;
                }
                context.HttpContext.GetOwinContext().Authentication.Challenge(properties, LoginProvider);
            }
        }

        #endregion Helpers
    }
}