﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
//using Seguridad.Common;
using Nova.Models;
using System.Globalization;
using Seguridad;

namespace Nova.Attributes
{
    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, Inherited = true, AllowMultiple = true)]
    //public class SessionExpireFilterAttribute : ActionFilterAttribute
    //{
    //    public override void OnActionExecuting(ActionExecutingContext filterContext)
    //    {
    //        HttpContext ctx = HttpContext.Current;

    //        // If the browser session or authentication session has expired...
    //        if (ctx.Session["UserName"] == null || !filterContext.HttpContext.Request.IsAuthenticated)
    //        {
    //            if (filterContext.HttpContext.Request.IsAjaxRequest())
    //            {
    //                // For AJAX requests, we're overriding the returned JSON result with a simple string,
    //                // indicating to the calling JavaScript code that a redirect should be performed.
    //                filterContext.Result = new JsonResult { Data = "_Logon_" };
    //            }
    //            else
    //            {
    //                // For round-trip posts, we're forcing a redirect to Home/TimeoutRedirect/, which
    //                // simply displays a temporary 5 second notification that they have timed out, and
    //                // will, in turn, redirect to the logon page.
    //                filterContext.Result = new RedirectToRouteResult(
    //                    new RouteValueDictionary {
    //                    { "Controller", "Home" },
    //                    { "Action", "TimeoutRedirect" }
    //            });
    //            }
    //        }

    //        base.OnActionExecuting(filterContext);
    //    }
    //}
    public class AutorizeMvc : ActionFilterAttribute
    {
        public override void OnActionExecuting(ActionExecutingContext filterContext)
        {

            
            //var user = filterContext.HttpContext.User;
            //if (user == null || !user.Identity.IsAuthenticated)
            //{
            //    filterContext.Result = new HttpUnauthorizedResult();
            //}


            bool skipAuthorization = filterContext.ActionDescriptor.IsDefined(typeof(AllowAnonymousAttribute), inherit: true)
                                 || filterContext.ActionDescriptor.ControllerDescriptor.IsDefined(typeof(AllowAnonymousAttribute), inherit: true);

            bool IsAuthenticatedfilter = filterContext.ActionDescriptor.IsDefined(typeof(AuthorizeAttribute), inherit: true)
                                 || filterContext.ActionDescriptor.ControllerDescriptor.IsDefined(typeof(AuthorizeAttribute), inherit: true);

            var user = filterContext.HttpContext.User;

            if (skipAuthorization)
            {
                return;
            }
            else
                if (IsAuthenticatedfilter && user.Identity.IsAuthenticated)
                { return; }
            else
            {
               
                if (user == null || !user.Identity.IsAuthenticated)
                {
                    filterContext.Result = new HttpUnauthorizedResult();
                }

               
                    // inicia timeout session y autenticación
                    HttpContext ctx = HttpContext.Current;

                    // If the browser session or authentication session has expired...
                    if (ctx.Session["UserName"] == null || !filterContext.HttpContext.Request.IsAuthenticated)
                    {
                        if (filterContext.HttpContext.Request.IsAjaxRequest())
                        {
                            // For AJAX requests, we're overriding the returned JSON result with a simple string,
                            // indicating to the calling JavaScript code that a redirect should be performed.
                            filterContext.Result = new JsonResult { Data = "_Logon_" };
                        }
                        else
                        {
                            // For round-trip posts, we're forcing a redirect to Home/TimeoutRedirect/, which
                            // simply displays a temporary 5 second notification that they have timed out, and
                            // will, in turn, redirect to the logon page.
                        //    filterContext.Result = new RedirectToRouteResult(
                        //        new RouteValueDictionary {
                        //{ "Controller", "Account" },
                        //{ "Action", "Login" }

                        //                                                    });
                            filterContext.Result = new HttpUnauthorizedResult();


                        }
                        //base.OnActionExecuting(filterContext);
                    }
                    // termina timeout session y autenticación
                    else
                    {
                        List<Seguridad.MenuItem> ListaMenu = new List<Seguridad.MenuItem>();


                        bool acceso = false;
                        ListaMenu = Identidad.Roles();
                        filterContext.HttpContext.Session["Aut"] = "NOok";

                        //var t = ListaMenu.Where(f => f.ApplicationName == "Poa").ToList();
                        string  accionsolicitada = filterContext.RouteData.Values["action"].ToString().Trim().ToUpper();
                        string controladorsolicitado =filterContext.RouteData.Values["controller"].ToString().Trim().ToUpper();
                        
                        foreach (var accion in ListaMenu)
                        {
                            //if (accion.ParentId.ToUpper() != "NULL")
                            //{
                            CompareOptions compareOptions = CompareOptions.IgnoreCase
                                  | CompareOptions.IgnoreWidth
                                  | CompareOptions.IgnoreNonSpace;


                            string miaccion = accion.ActionName.Trim().ToUpper();
                            string micontrolador= accion.ControllerName.Trim().ToUpper();
                            if (miaccion == "ALL" && micontrolador == "ALL")
                            //if ((miaccion == filterContext.RouteData.Values["action"].ToString().ToUpper() && accion.ControllerName.ToUpper() == filterContext.RouteData.Values["controller"].ToString().ToUpper()) || (accion.ActionName.ToUpper() == "ALL" && accion.ControllerName.ToUpper() == filterContext.RouteData.Values["controller"].ToString().ToUpper()) || (accion.ControllerName.ToUpper() == "ALL"))
                            {
                                acceso = true;
                                break;
                            }


                            if (miaccion == "ALL" && micontrolador == controladorsolicitado)
                            //if ((miaccion == filterContext.RouteData.Values["action"].ToString().ToUpper() && accion.ControllerName.ToUpper() == filterContext.RouteData.Values["controller"].ToString().ToUpper()) || (accion.ActionName.ToUpper() == "ALL" && accion.ControllerName.ToUpper() == filterContext.RouteData.Values["controller"].ToString().ToUpper()) || (accion.ControllerName.ToUpper() == "ALL"))
                            {
                                acceso = true;
                                break;
                            }

                            if (string.Compare(miaccion, accionsolicitada, CultureInfo.CurrentCulture, compareOptions) == 0 && string.Compare(micontrolador, controladorsolicitado, CultureInfo.CurrentCulture, compareOptions)==0)
                            //if ((miaccion == filterContext.RouteData.Values["action"].ToString().ToUpper() && accion.ControllerName.ToUpper() == filterContext.RouteData.Values["controller"].ToString().ToUpper()) || (accion.ActionName.ToUpper() == "ALL" && accion.ControllerName.ToUpper() == filterContext.RouteData.Values["controller"].ToString().ToUpper()) || (accion.ControllerName.ToUpper() == "ALL"))
                            {
                                acceso = true;
                                break;
                            }

                            //}

                        }
                        if (!acceso)
                        {

                            //filterContext.Result = new HttpForbiddenResult();
                            throw new HttpException((int)System.Net.HttpStatusCode.Forbidden, "No estas autorizado para realizar esta acción");
                             
                          
                        }
                    }
                

            }

        }

    }
}
